/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opsworks.model.Volume;

@SdkInternalApi
public class VolumeMarshaller {
    private static final MarshallingInfo<String> VOLUMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeId").build();
    private static final MarshallingInfo<String> EC2VOLUMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2VolumeId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> RAIDARRAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RaidArrayId").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final MarshallingInfo<String> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Device").build();
    private static final MarshallingInfo<String> MOUNTPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MountPoint").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").build();
    private static final VolumeMarshaller instance = new VolumeMarshaller();

    public static VolumeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Volume volume, ProtocolMarshaller protocolMarshaller) {
        if (volume == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)volume.getVolumeId(), VOLUMEID_BINDING);
            protocolMarshaller.marshall((Object)volume.getEc2VolumeId(), EC2VOLUMEID_BINDING);
            protocolMarshaller.marshall((Object)volume.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)volume.getRaidArrayId(), RAIDARRAYID_BINDING);
            protocolMarshaller.marshall((Object)volume.getInstanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)volume.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)volume.getSize(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)volume.getDevice(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)volume.getMountPoint(), MOUNTPOINT_BINDING);
            protocolMarshaller.marshall((Object)volume.getRegion(), REGION_BINDING);
            protocolMarshaller.marshall((Object)volume.getAvailabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)volume.getVolumeType(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)volume.getIops(), IOPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

