/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.DescribeUserProfilesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeUserProfilesRequestMarshaller
implements Marshaller<Request<DescribeUserProfilesRequest>, DescribeUserProfilesRequest> {
    public Request<DescribeUserProfilesRequest> marshall(DescribeUserProfilesRequest describeUserProfilesRequest) {
        if (describeUserProfilesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeUserProfilesRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeUserProfiles");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            SdkInternalList iamUserArnsList = (SdkInternalList)describeUserProfilesRequest.getIamUserArns();
            if (!iamUserArnsList.isEmpty() || !iamUserArnsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("IamUserArns");
                jsonGenerator.writeStartArray();
                for (String iamUserArnsListValue : iamUserArnsList) {
                    if (iamUserArnsListValue == null) continue;
                    jsonGenerator.writeValue(iamUserArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

