/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.Deployment;
import com.amazonaws.services.opsworks.model.transform.DeploymentCommandJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class DeploymentJsonMarshaller {
    private static DeploymentJsonMarshaller instance;

    public void marshall(Deployment deployment, StructuredJsonGenerator jsonGenerator) {
        if (deployment == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList instanceIdsList;
            jsonGenerator.writeStartObject();
            if (deployment.getDeploymentId() != null) {
                jsonGenerator.writeFieldName("DeploymentId").writeValue(deployment.getDeploymentId());
            }
            if (deployment.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(deployment.getStackId());
            }
            if (deployment.getAppId() != null) {
                jsonGenerator.writeFieldName("AppId").writeValue(deployment.getAppId());
            }
            if (deployment.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(deployment.getCreatedAt());
            }
            if (deployment.getCompletedAt() != null) {
                jsonGenerator.writeFieldName("CompletedAt").writeValue(deployment.getCompletedAt());
            }
            if (deployment.getDuration() != null) {
                jsonGenerator.writeFieldName("Duration").writeValue(deployment.getDuration().intValue());
            }
            if (deployment.getIamUserArn() != null) {
                jsonGenerator.writeFieldName("IamUserArn").writeValue(deployment.getIamUserArn());
            }
            if (deployment.getComment() != null) {
                jsonGenerator.writeFieldName("Comment").writeValue(deployment.getComment());
            }
            if (deployment.getCommand() != null) {
                jsonGenerator.writeFieldName("Command");
                DeploymentCommandJsonMarshaller.getInstance().marshall(deployment.getCommand(), jsonGenerator);
            }
            if (deployment.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(deployment.getStatus());
            }
            if (deployment.getCustomJson() != null) {
                jsonGenerator.writeFieldName("CustomJson").writeValue(deployment.getCustomJson());
            }
            if (!(instanceIdsList = (SdkInternalList)deployment.getInstanceIds()).isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceIds");
                jsonGenerator.writeStartArray();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonGenerator.writeValue(instanceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentJsonMarshaller();
        }
        return instance;
    }
}

