/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.opsworks.model.Volume;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class VolumeJsonMarshaller {
    private static VolumeJsonMarshaller instance;

    public void marshall(Volume volume, StructuredJsonGenerator jsonGenerator) {
        if (volume == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (volume.getVolumeId() != null) {
                jsonGenerator.writeFieldName("VolumeId").writeValue(volume.getVolumeId());
            }
            if (volume.getEc2VolumeId() != null) {
                jsonGenerator.writeFieldName("Ec2VolumeId").writeValue(volume.getEc2VolumeId());
            }
            if (volume.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(volume.getName());
            }
            if (volume.getRaidArrayId() != null) {
                jsonGenerator.writeFieldName("RaidArrayId").writeValue(volume.getRaidArrayId());
            }
            if (volume.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(volume.getInstanceId());
            }
            if (volume.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(volume.getStatus());
            }
            if (volume.getSize() != null) {
                jsonGenerator.writeFieldName("Size").writeValue(volume.getSize().intValue());
            }
            if (volume.getDevice() != null) {
                jsonGenerator.writeFieldName("Device").writeValue(volume.getDevice());
            }
            if (volume.getMountPoint() != null) {
                jsonGenerator.writeFieldName("MountPoint").writeValue(volume.getMountPoint());
            }
            if (volume.getRegion() != null) {
                jsonGenerator.writeFieldName("Region").writeValue(volume.getRegion());
            }
            if (volume.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("AvailabilityZone").writeValue(volume.getAvailabilityZone());
            }
            if (volume.getVolumeType() != null) {
                jsonGenerator.writeFieldName("VolumeType").writeValue(volume.getVolumeType());
            }
            if (volume.getIops() != null) {
                jsonGenerator.writeFieldName("Iops").writeValue(volume.getIops().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VolumeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VolumeJsonMarshaller();
        }
        return instance;
    }
}

