/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.opsworks.model.SetPermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SetPermissionRequestMarshaller
implements Marshaller<Request<SetPermissionRequest>, SetPermissionRequest> {
    public Request<SetPermissionRequest> marshall(SetPermissionRequest setPermissionRequest) {
        if (setPermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setPermissionRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.SetPermission");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (setPermissionRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(setPermissionRequest.getStackId());
            }
            if (setPermissionRequest.getIamUserArn() != null) {
                jsonGenerator.writeFieldName("IamUserArn").writeValue(setPermissionRequest.getIamUserArn());
            }
            if (setPermissionRequest.getAllowSsh() != null) {
                jsonGenerator.writeFieldName("AllowSsh").writeValue(setPermissionRequest.getAllowSsh().booleanValue());
            }
            if (setPermissionRequest.getAllowSudo() != null) {
                jsonGenerator.writeFieldName("AllowSudo").writeValue(setPermissionRequest.getAllowSudo().booleanValue());
            }
            if (setPermissionRequest.getLevel() != null) {
                jsonGenerator.writeFieldName("Level").writeValue(setPermissionRequest.getLevel());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

