/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.opsworks.model.DeleteInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteInstanceRequestMarshaller
implements Marshaller<Request<DeleteInstanceRequest>, DeleteInstanceRequest> {
    public Request<DeleteInstanceRequest> marshall(DeleteInstanceRequest deleteInstanceRequest) {
        if (deleteInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteInstanceRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DeleteInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (deleteInstanceRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(deleteInstanceRequest.getInstanceId());
            }
            if (deleteInstanceRequest.getDeleteElasticIp() != null) {
                jsonGenerator.writeFieldName("DeleteElasticIp").writeValue(deleteInstanceRequest.getDeleteElasticIp().booleanValue());
            }
            if (deleteInstanceRequest.getDeleteVolumes() != null) {
                jsonGenerator.writeFieldName("DeleteVolumes").writeValue(deleteInstanceRequest.getDeleteVolumes().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

