/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.opsworks.model.AgentVersion;
import com.amazonaws.services.opsworks.model.transform.StackConfigurationManagerJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class AgentVersionJsonMarshaller {
    private static AgentVersionJsonMarshaller instance;

    public void marshall(AgentVersion agentVersion, JSONWriter jsonWriter) {
        if (agentVersion == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (agentVersion.getVersion() != null) {
                jsonWriter.key("Version").value((Object)agentVersion.getVersion());
            }
            if (agentVersion.getConfigurationManager() != null) {
                jsonWriter.key("ConfigurationManager");
                StackConfigurationManagerJsonMarshaller.getInstance().marshall(agentVersion.getConfigurationManager(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AgentVersionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AgentVersionJsonMarshaller();
        }
        return instance;
    }
}

