/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.DeploymentCommand;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateDeploymentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String stackId;
    private String appId;
    private SdkInternalList<String> instanceIds;
    private DeploymentCommand command;
    private String comment;
    private String customJson;

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public CreateDeploymentRequest withStackId(String stackId) {
        this.setStackId(stackId);
        return this;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public CreateDeploymentRequest withAppId(String appId) {
        this.setAppId(appId);
        return this;
    }

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new SdkInternalList();
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        this.instanceIds = new SdkInternalList(instanceIds);
    }

    public CreateDeploymentRequest withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.setInstanceIds((Collection<String>)new SdkInternalList(instanceIds.length));
        }
        for (String ele : instanceIds) {
            this.instanceIds.add((Object)ele);
        }
        return this;
    }

    public CreateDeploymentRequest withInstanceIds(Collection<String> instanceIds) {
        this.setInstanceIds(instanceIds);
        return this;
    }

    public void setCommand(DeploymentCommand command) {
        this.command = command;
    }

    public DeploymentCommand getCommand() {
        return this.command;
    }

    public CreateDeploymentRequest withCommand(DeploymentCommand command) {
        this.setCommand(command);
        return this;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public CreateDeploymentRequest withComment(String comment) {
        this.setComment(comment);
        return this;
    }

    public void setCustomJson(String customJson) {
        this.customJson = customJson;
    }

    public String getCustomJson() {
        return this.customJson;
    }

    public CreateDeploymentRequest withCustomJson(String customJson) {
        this.setCustomJson(customJson);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackId() != null) {
            sb.append("StackId: " + this.getStackId() + ",");
        }
        if (this.getAppId() != null) {
            sb.append("AppId: " + this.getAppId() + ",");
        }
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: " + this.getInstanceIds() + ",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: " + this.getCommand() + ",");
        }
        if (this.getComment() != null) {
            sb.append("Comment: " + this.getComment() + ",");
        }
        if (this.getCustomJson() != null) {
            sb.append("CustomJson: " + this.getCustomJson());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)obj;
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getAppId() == null ^ this.getAppId() == null) {
            return false;
        }
        if (other.getAppId() != null && !other.getAppId().equals(this.getAppId())) {
            return false;
        }
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        if (other.getInstanceIds() != null && !other.getInstanceIds().equals(this.getInstanceIds())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getCustomJson() == null ^ this.getCustomJson() == null) {
            return false;
        }
        return other.getCustomJson() == null || other.getCustomJson().equals(this.getCustomJson());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getAppId() == null ? 0 : this.getAppId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.getCustomJson() == null ? 0 : this.getCustomJson().hashCode());
        return hashCode;
    }

    public CreateDeploymentRequest clone() {
        return (CreateDeploymentRequest)super.clone();
    }
}

