/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opensearch.model.JWTOptionsOutput;

@SdkInternalApi
public class JWTOptionsOutputMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<String> SUBJECTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubjectKey").build();
    private static final MarshallingInfo<String> ROLESKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RolesKey").build();
    private static final MarshallingInfo<String> PUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicKey").build();
    private static final JWTOptionsOutputMarshaller instance = new JWTOptionsOutputMarshaller();

    public static JWTOptionsOutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(JWTOptionsOutput jWTOptionsOutput, ProtocolMarshaller protocolMarshaller) {
        if (jWTOptionsOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jWTOptionsOutput.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)jWTOptionsOutput.getSubjectKey(), SUBJECTKEY_BINDING);
            protocolMarshaller.marshall((Object)jWTOptionsOutput.getRolesKey(), ROLESKEY_BINDING);
            protocolMarshaller.marshall((Object)jWTOptionsOutput.getPublicKey(), PUBLICKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

