/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.opensearch.model.PackageVersionHistory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetPackageVersionHistoryResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String packageID;
    private List<PackageVersionHistory> packageVersionHistoryList;
    private String nextToken;

    public void setPackageID(String packageID) {
        this.packageID = packageID;
    }

    public String getPackageID() {
        return this.packageID;
    }

    public GetPackageVersionHistoryResult withPackageID(String packageID) {
        this.setPackageID(packageID);
        return this;
    }

    public List<PackageVersionHistory> getPackageVersionHistoryList() {
        return this.packageVersionHistoryList;
    }

    public void setPackageVersionHistoryList(Collection<PackageVersionHistory> packageVersionHistoryList) {
        if (packageVersionHistoryList == null) {
            this.packageVersionHistoryList = null;
            return;
        }
        this.packageVersionHistoryList = new ArrayList<PackageVersionHistory>(packageVersionHistoryList);
    }

    public GetPackageVersionHistoryResult withPackageVersionHistoryList(PackageVersionHistory ... packageVersionHistoryList) {
        if (this.packageVersionHistoryList == null) {
            this.setPackageVersionHistoryList(new ArrayList<PackageVersionHistory>(packageVersionHistoryList.length));
        }
        for (PackageVersionHistory ele : packageVersionHistoryList) {
            this.packageVersionHistoryList.add(ele);
        }
        return this;
    }

    public GetPackageVersionHistoryResult withPackageVersionHistoryList(Collection<PackageVersionHistory> packageVersionHistoryList) {
        this.setPackageVersionHistoryList(packageVersionHistoryList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetPackageVersionHistoryResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPackageID() != null) {
            sb.append("PackageID: ").append(this.getPackageID()).append(",");
        }
        if (this.getPackageVersionHistoryList() != null) {
            sb.append("PackageVersionHistoryList: ").append(this.getPackageVersionHistoryList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageVersionHistoryResult)) {
            return false;
        }
        GetPackageVersionHistoryResult other = (GetPackageVersionHistoryResult)obj;
        if (other.getPackageID() == null ^ this.getPackageID() == null) {
            return false;
        }
        if (other.getPackageID() != null && !other.getPackageID().equals(this.getPackageID())) {
            return false;
        }
        if (other.getPackageVersionHistoryList() == null ^ this.getPackageVersionHistoryList() == null) {
            return false;
        }
        if (other.getPackageVersionHistoryList() != null && !other.getPackageVersionHistoryList().equals(this.getPackageVersionHistoryList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPackageID() == null ? 0 : this.getPackageID().hashCode());
        hashCode = 31 * hashCode + (this.getPackageVersionHistoryList() == null ? 0 : this.getPackageVersionHistoryList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetPackageVersionHistoryResult clone() {
        try {
            return (GetPackageVersionHistoryResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

