/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.transform.PackageVersionHistoryMarshaller;
import java.io.Serializable;
import java.util.Date;

public class PackageVersionHistory
implements Serializable,
Cloneable,
StructuredPojo {
    private String packageVersion;
    private String commitMessage;
    private Date createdAt;

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public PackageVersionHistory withPackageVersion(String packageVersion) {
        this.setPackageVersion(packageVersion);
        return this;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public PackageVersionHistory withCommitMessage(String commitMessage) {
        this.setCommitMessage(commitMessage);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public PackageVersionHistory withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPackageVersion() != null) {
            sb.append("PackageVersion: ").append(this.getPackageVersion()).append(",");
        }
        if (this.getCommitMessage() != null) {
            sb.append("CommitMessage: ").append(this.getCommitMessage()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionHistory)) {
            return false;
        }
        PackageVersionHistory other = (PackageVersionHistory)obj;
        if (other.getPackageVersion() == null ^ this.getPackageVersion() == null) {
            return false;
        }
        if (other.getPackageVersion() != null && !other.getPackageVersion().equals(this.getPackageVersion())) {
            return false;
        }
        if (other.getCommitMessage() == null ^ this.getCommitMessage() == null) {
            return false;
        }
        if (other.getCommitMessage() != null && !other.getCommitMessage().equals(this.getCommitMessage())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        return other.getCreatedAt() == null || other.getCreatedAt().equals(this.getCreatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPackageVersion() == null ? 0 : this.getPackageVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCommitMessage() == null ? 0 : this.getCommitMessage().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        return hashCode;
    }

    public PackageVersionHistory clone() {
        try {
            return (PackageVersionHistory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PackageVersionHistoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

