/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.internal.auth;

import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.CanHandleNullCredentials;
import com.amazonaws.auth.RequestSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.internal.auth.SignerProviderContext;
import com.amazonaws.opensdk.protect.auth.RequestSignerAware;
import com.amazonaws.opensdk.protect.auth.RequestSignerNotFoundException;
import com.amazonaws.opensdk.protect.auth.RequestSignerProvider;

public final class SignerProviderAdapter
extends SignerProvider {
    private final RequestSignerProvider provider;

    public SignerProviderAdapter(RequestSignerProvider provider) {
        this.provider = provider;
    }

    public Signer getSigner(SignerProviderContext context) {
        Object originalRequest = context.getRequestConfig().getOriginalRequest();
        if (originalRequest instanceof RequestSignerAware) {
            Class<? extends RequestSigner> signerType = ((RequestSignerAware)originalRequest).signerType();
            return this.provider.getSigner(signerType).map(x$0 -> new AuthorizerAsSigner((RequestSigner)x$0)).orElseThrow(() -> new RequestSignerNotFoundException(signerType));
        }
        return null;
    }

    private static class AuthorizerAsSigner
    implements Signer,
    CanHandleNullCredentials {
        private final RequestSigner authorizer;

        private AuthorizerAsSigner(RequestSigner authorizer) {
            this.authorizer = authorizer;
        }

        public void sign(SignableRequest<?> request, AWSCredentials credentials) {
            this.authorizer.sign(request);
        }
    }
}

