/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.internal.protocol;

import com.amazonaws.SdkBaseException;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.SdkHttpMetadata;
import com.amazonaws.internal.http.JsonErrorMessageParser;
import com.amazonaws.opensdk.SdkErrorHttpMetadata;
import com.amazonaws.opensdk.internal.BaseException;
import com.amazonaws.opensdk.internal.protocol.ApiGatewayErrorUnmarshaller;
import com.amazonaws.protocol.json.JsonContent;
import com.amazonaws.util.ValidationUtils;
import com.fasterxml.jackson.core.JsonFactory;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class ApiGatewayErrorResponseHandler
implements HttpResponseHandler<SdkBaseException> {
    private static final Log LOG = LogFactory.getLog(ApiGatewayErrorResponseHandler.class);
    private final List<ApiGatewayErrorUnmarshaller> unmarshallers;
    private final JsonFactory jsonFactory;
    private final JsonErrorMessageParser messageParser = JsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER;

    public ApiGatewayErrorResponseHandler(List<ApiGatewayErrorUnmarshaller> errorUnmarshallers, JsonFactory jsonFactory) {
        this.unmarshallers = (List)ValidationUtils.assertNotNull(errorUnmarshallers, (String)"errorUnmarshallers");
        this.jsonFactory = (JsonFactory)ValidationUtils.assertNotNull((Object)jsonFactory, (String)"jsonFactory");
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }

    public SdkBaseException handle(HttpResponse response) throws Exception {
        JsonContent jsonContent = JsonContent.createJsonContent((HttpResponse)response, (JsonFactory)this.jsonFactory);
        BaseException exception = this.createException(response.getStatusCode(), jsonContent);
        exception.sdkHttpMetadata(new SdkErrorHttpMetadata(SdkHttpMetadata.from((HttpResponse)response), jsonContent.getRawContent()));
        exception.setMessage(this.messageParser.parseErrorMessage(jsonContent.getJsonNode()));
        return (SdkBaseException)exception;
    }

    private BaseException createException(int httpStatusCode, JsonContent jsonContent) {
        return this.unmarshallers.stream().filter(u -> u.matches(httpStatusCode)).findFirst().map(u -> this.safeUnmarshall(jsonContent, (ApiGatewayErrorUnmarshaller)u)).orElseThrow(this::createUnknownException);
    }

    private BaseException safeUnmarshall(JsonContent jsonContent, ApiGatewayErrorUnmarshaller unmarshaller) {
        try {
            return unmarshaller.unmarshall(jsonContent.getJsonNode());
        }
        catch (Exception e) {
            LOG.info((Object)"Unable to unmarshall exception content", (Throwable)e);
            throw new SdkClientException(e.getCause());
        }
    }

    private SdkClientException createUnknownException() {
        return new SdkClientException("Unable to unmarshall exception response with the unmarshallers provided");
    }
}

