/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.omics.model.SequenceInformation;

@SdkInternalApi
public class SequenceInformationMarshaller {
    private static final MarshallingInfo<String> ALIGNMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alignment").build();
    private static final MarshallingInfo<String> GENERATEDFROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("generatedFrom").build();
    private static final MarshallingInfo<Long> TOTALBASECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalBaseCount").build();
    private static final MarshallingInfo<Long> TOTALREADCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalReadCount").build();
    private static final SequenceInformationMarshaller instance = new SequenceInformationMarshaller();

    public static SequenceInformationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SequenceInformation sequenceInformation, ProtocolMarshaller protocolMarshaller) {
        if (sequenceInformation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sequenceInformation.getAlignment(), ALIGNMENT_BINDING);
            protocolMarshaller.marshall((Object)sequenceInformation.getGeneratedFrom(), GENERATEDFROM_BINDING);
            protocolMarshaller.marshall((Object)sequenceInformation.getTotalBaseCount(), TOTALBASECOUNT_BINDING);
            protocolMarshaller.marshall((Object)sequenceInformation.getTotalReadCount(), TOTALREADCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

