/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Use Amazon CloudWatch Observability Access Manager to create and manage links between source accounts and monitoring
 * accounts by using <i>CloudWatch cross-account observability</i>. With CloudWatch cross-account observability, you can
 * monitor and troubleshoot applications that span multiple accounts within a Region. Seamlessly search, visualize, and
 * analyze your metrics, logs, traces, and Application Insights applications in any of the linked accounts without
 * account boundaries.
 * </p>
 * <p>
 * Set up one or more Amazon Web Services accounts as <i>monitoring accounts</i> and link them with multiple <i>source
 * accounts</i>. A monitoring account is a central Amazon Web Services account that can view and interact with
 * observability data generated from source accounts. A source account is an individual Amazon Web Services account that
 * generates observability data for the resources that reside in it. Source accounts share their observability data with
 * the monitoring account. The shared observability data can include metrics in Amazon CloudWatch, logs in Amazon
 * CloudWatch Logs, traces in X-Ray, and applications in Amazon CloudWatch Application Insights.
 * </p>
 */
package com.amazonaws.services.oam;

