/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.oam.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.oam.model.LinkConfiguration;
import com.amazonaws.services.oam.model.ResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateLinkRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String labelTemplate;
    private LinkConfiguration linkConfiguration;
    private List<String> resourceTypes;
    private String sinkIdentifier;
    private Map<String, String> tags;

    public void setLabelTemplate(String labelTemplate) {
        this.labelTemplate = labelTemplate;
    }

    public String getLabelTemplate() {
        return this.labelTemplate;
    }

    public CreateLinkRequest withLabelTemplate(String labelTemplate) {
        this.setLabelTemplate(labelTemplate);
        return this;
    }

    public void setLinkConfiguration(LinkConfiguration linkConfiguration) {
        this.linkConfiguration = linkConfiguration;
    }

    public LinkConfiguration getLinkConfiguration() {
        return this.linkConfiguration;
    }

    public CreateLinkRequest withLinkConfiguration(LinkConfiguration linkConfiguration) {
        this.setLinkConfiguration(linkConfiguration);
        return this;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new ArrayList<String>(resourceTypes);
    }

    public CreateLinkRequest withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes(new ArrayList<String>(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add(ele);
        }
        return this;
    }

    public CreateLinkRequest withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public CreateLinkRequest withResourceTypes(ResourceType ... resourceTypes) {
        ArrayList<String> resourceTypesCopy = new ArrayList<String>(resourceTypes.length);
        for (ResourceType value : resourceTypes) {
            resourceTypesCopy.add(value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes(resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll(resourceTypesCopy);
        }
        return this;
    }

    public void setSinkIdentifier(String sinkIdentifier) {
        this.sinkIdentifier = sinkIdentifier;
    }

    public String getSinkIdentifier() {
        return this.sinkIdentifier;
    }

    public CreateLinkRequest withSinkIdentifier(String sinkIdentifier) {
        this.setSinkIdentifier(sinkIdentifier);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateLinkRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateLinkRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateLinkRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLabelTemplate() != null) {
            sb.append("LabelTemplate: ").append(this.getLabelTemplate()).append(",");
        }
        if (this.getLinkConfiguration() != null) {
            sb.append("LinkConfiguration: ").append(this.getLinkConfiguration()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes()).append(",");
        }
        if (this.getSinkIdentifier() != null) {
            sb.append("SinkIdentifier: ").append(this.getSinkIdentifier()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLinkRequest)) {
            return false;
        }
        CreateLinkRequest other = (CreateLinkRequest)obj;
        if (other.getLabelTemplate() == null ^ this.getLabelTemplate() == null) {
            return false;
        }
        if (other.getLabelTemplate() != null && !other.getLabelTemplate().equals(this.getLabelTemplate())) {
            return false;
        }
        if (other.getLinkConfiguration() == null ^ this.getLinkConfiguration() == null) {
            return false;
        }
        if (other.getLinkConfiguration() != null && !other.getLinkConfiguration().equals(this.getLinkConfiguration())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        if (other.getResourceTypes() != null && !other.getResourceTypes().equals(this.getResourceTypes())) {
            return false;
        }
        if (other.getSinkIdentifier() == null ^ this.getSinkIdentifier() == null) {
            return false;
        }
        if (other.getSinkIdentifier() != null && !other.getSinkIdentifier().equals(this.getSinkIdentifier())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLabelTemplate() == null ? 0 : this.getLabelTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getLinkConfiguration() == null ? 0 : this.getLinkConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSinkIdentifier() == null ? 0 : this.getSinkIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateLinkRequest clone() {
        return (CreateLinkRequest)super.clone();
    }
}

