/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.oam;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.oam.AWSOAM;
import com.amazonaws.services.oam.AWSOAMClientBuilder;
import com.amazonaws.services.oam.model.AWSOAMException;
import com.amazonaws.services.oam.model.CreateLinkRequest;
import com.amazonaws.services.oam.model.CreateLinkResult;
import com.amazonaws.services.oam.model.CreateSinkRequest;
import com.amazonaws.services.oam.model.CreateSinkResult;
import com.amazonaws.services.oam.model.DeleteLinkRequest;
import com.amazonaws.services.oam.model.DeleteLinkResult;
import com.amazonaws.services.oam.model.DeleteSinkRequest;
import com.amazonaws.services.oam.model.DeleteSinkResult;
import com.amazonaws.services.oam.model.GetLinkRequest;
import com.amazonaws.services.oam.model.GetLinkResult;
import com.amazonaws.services.oam.model.GetSinkPolicyRequest;
import com.amazonaws.services.oam.model.GetSinkPolicyResult;
import com.amazonaws.services.oam.model.GetSinkRequest;
import com.amazonaws.services.oam.model.GetSinkResult;
import com.amazonaws.services.oam.model.ListAttachedLinksRequest;
import com.amazonaws.services.oam.model.ListAttachedLinksResult;
import com.amazonaws.services.oam.model.ListLinksRequest;
import com.amazonaws.services.oam.model.ListLinksResult;
import com.amazonaws.services.oam.model.ListSinksRequest;
import com.amazonaws.services.oam.model.ListSinksResult;
import com.amazonaws.services.oam.model.ListTagsForResourceRequest;
import com.amazonaws.services.oam.model.ListTagsForResourceResult;
import com.amazonaws.services.oam.model.PutSinkPolicyRequest;
import com.amazonaws.services.oam.model.PutSinkPolicyResult;
import com.amazonaws.services.oam.model.TagResourceRequest;
import com.amazonaws.services.oam.model.TagResourceResult;
import com.amazonaws.services.oam.model.UntagResourceRequest;
import com.amazonaws.services.oam.model.UntagResourceResult;
import com.amazonaws.services.oam.model.UpdateLinkRequest;
import com.amazonaws.services.oam.model.UpdateLinkResult;
import com.amazonaws.services.oam.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.oam.model.transform.CreateLinkRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.CreateLinkResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.CreateSinkRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.CreateSinkResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.DeleteLinkRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.DeleteLinkResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.DeleteSinkRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.DeleteSinkResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.GetLinkRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.GetLinkResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.GetSinkPolicyRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.GetSinkPolicyResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.GetSinkRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.GetSinkResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.oam.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.oam.model.transform.ListAttachedLinksRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.ListAttachedLinksResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.ListLinksRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.ListLinksResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.ListSinksRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.ListSinksResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.MissingRequiredParameterExceptionUnmarshaller;
import com.amazonaws.services.oam.model.transform.PutSinkPolicyRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.PutSinkPolicyResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.oam.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.oam.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.TooManyTagsExceptionUnmarshaller;
import com.amazonaws.services.oam.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.UpdateLinkRequestProtocolMarshaller;
import com.amazonaws.services.oam.model.transform.UpdateLinkResultJsonUnmarshaller;
import com.amazonaws.services.oam.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSOAMClient
extends AmazonWebServiceClient
implements AWSOAM {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSOAM.class);
    private static final String DEFAULT_SIGNING_NAME = "oam";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyTagsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingRequiredParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)MissingRequiredParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSOAMException.class));

    public static AWSOAMClientBuilder builder() {
        return AWSOAMClientBuilder.standard();
    }

    AWSOAMClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSOAMClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("oam.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/oam/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/oam/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateLinkResult createLink(CreateLinkRequest request) {
        request = (CreateLinkRequest)this.beforeClientExecution(request);
        return this.executeCreateLink(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLinkResult executeCreateLink(CreateLinkRequest createLinkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLinkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLinkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLinkRequestProtocolMarshaller(protocolFactory).marshall((CreateLinkRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLinkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLink");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLinkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLinkResult createLinkResult = (CreateLinkResult)response.getAwsResponse();
            return createLinkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSinkResult createSink(CreateSinkRequest request) {
        request = (CreateSinkRequest)this.beforeClientExecution(request);
        return this.executeCreateSink(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSinkResult executeCreateSink(CreateSinkRequest createSinkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSinkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSinkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSinkRequestProtocolMarshaller(protocolFactory).marshall((CreateSinkRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSinkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSink");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSinkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSinkResult createSinkResult = (CreateSinkResult)response.getAwsResponse();
            return createSinkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLinkResult deleteLink(DeleteLinkRequest request) {
        request = (DeleteLinkRequest)this.beforeClientExecution(request);
        return this.executeDeleteLink(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLinkResult executeDeleteLink(DeleteLinkRequest deleteLinkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLinkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLinkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLinkRequestProtocolMarshaller(protocolFactory).marshall((DeleteLinkRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLinkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLink");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLinkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLinkResult deleteLinkResult = (DeleteLinkResult)response.getAwsResponse();
            return deleteLinkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSinkResult deleteSink(DeleteSinkRequest request) {
        request = (DeleteSinkRequest)this.beforeClientExecution(request);
        return this.executeDeleteSink(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSinkResult executeDeleteSink(DeleteSinkRequest deleteSinkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSinkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSinkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSinkRequestProtocolMarshaller(protocolFactory).marshall((DeleteSinkRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSinkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSink");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSinkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSinkResult deleteSinkResult = (DeleteSinkResult)response.getAwsResponse();
            return deleteSinkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLinkResult getLink(GetLinkRequest request) {
        request = (GetLinkRequest)this.beforeClientExecution(request);
        return this.executeGetLink(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLinkResult executeGetLink(GetLinkRequest getLinkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLinkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLinkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLinkRequestProtocolMarshaller(protocolFactory).marshall((GetLinkRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLinkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLink");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLinkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLinkResult getLinkResult = (GetLinkResult)response.getAwsResponse();
            return getLinkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSinkResult getSink(GetSinkRequest request) {
        request = (GetSinkRequest)this.beforeClientExecution(request);
        return this.executeGetSink(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSinkResult executeGetSink(GetSinkRequest getSinkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSinkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSinkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSinkRequestProtocolMarshaller(protocolFactory).marshall((GetSinkRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSinkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSink");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSinkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSinkResult getSinkResult = (GetSinkResult)response.getAwsResponse();
            return getSinkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSinkPolicyResult getSinkPolicy(GetSinkPolicyRequest request) {
        request = (GetSinkPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetSinkPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSinkPolicyResult executeGetSinkPolicy(GetSinkPolicyRequest getSinkPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSinkPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSinkPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSinkPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetSinkPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSinkPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSinkPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSinkPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSinkPolicyResult getSinkPolicyResult = (GetSinkPolicyResult)response.getAwsResponse();
            return getSinkPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAttachedLinksResult listAttachedLinks(ListAttachedLinksRequest request) {
        request = (ListAttachedLinksRequest)this.beforeClientExecution(request);
        return this.executeListAttachedLinks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAttachedLinksResult executeListAttachedLinks(ListAttachedLinksRequest listAttachedLinksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAttachedLinksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAttachedLinksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAttachedLinksRequestProtocolMarshaller(protocolFactory).marshall((ListAttachedLinksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAttachedLinksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAttachedLinks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAttachedLinksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAttachedLinksResult listAttachedLinksResult = (ListAttachedLinksResult)response.getAwsResponse();
            return listAttachedLinksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLinksResult listLinks(ListLinksRequest request) {
        request = (ListLinksRequest)this.beforeClientExecution(request);
        return this.executeListLinks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLinksResult executeListLinks(ListLinksRequest listLinksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLinksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLinksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLinksRequestProtocolMarshaller(protocolFactory).marshall((ListLinksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLinksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLinks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLinksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLinksResult listLinksResult = (ListLinksResult)response.getAwsResponse();
            return listLinksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSinksResult listSinks(ListSinksRequest request) {
        request = (ListSinksRequest)this.beforeClientExecution(request);
        return this.executeListSinks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSinksResult executeListSinks(ListSinksRequest listSinksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSinksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSinksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSinksRequestProtocolMarshaller(protocolFactory).marshall((ListSinksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSinksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSinks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSinksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSinksResult listSinksResult = (ListSinksResult)response.getAwsResponse();
            return listSinksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutSinkPolicyResult putSinkPolicy(PutSinkPolicyRequest request) {
        request = (PutSinkPolicyRequest)this.beforeClientExecution(request);
        return this.executePutSinkPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutSinkPolicyResult executePutSinkPolicy(PutSinkPolicyRequest putSinkPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putSinkPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutSinkPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutSinkPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutSinkPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putSinkPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutSinkPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutSinkPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutSinkPolicyResult putSinkPolicyResult = (PutSinkPolicyResult)response.getAwsResponse();
            return putSinkPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateLinkResult updateLink(UpdateLinkRequest request) {
        request = (UpdateLinkRequest)this.beforeClientExecution(request);
        return this.executeUpdateLink(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateLinkResult executeUpdateLink(UpdateLinkRequest updateLinkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateLinkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateLinkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateLinkRequestProtocolMarshaller(protocolFactory).marshall((UpdateLinkRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateLinkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"OAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateLink");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLinkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateLinkResult updateLinkResult = (UpdateLinkResult)response.getAwsResponse();
            return updateLinkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

