/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmonitor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmonitor.model.Protocol;
import com.amazonaws.services.networkmonitor.model.transform.CreateMonitorProbeInputMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateMonitorProbeInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String sourceArn;
    private String destination;
    private Integer destinationPort;
    private String protocol;
    private Integer packetSize;
    private Map<String, String> probeTags;

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public CreateMonitorProbeInput withSourceArn(String sourceArn) {
        this.setSourceArn(sourceArn);
        return this;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public CreateMonitorProbeInput withDestination(String destination) {
        this.setDestination(destination);
        return this;
    }

    public void setDestinationPort(Integer destinationPort) {
        this.destinationPort = destinationPort;
    }

    public Integer getDestinationPort() {
        return this.destinationPort;
    }

    public CreateMonitorProbeInput withDestinationPort(Integer destinationPort) {
        this.setDestinationPort(destinationPort);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public CreateMonitorProbeInput withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public CreateMonitorProbeInput withProtocol(Protocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setPacketSize(Integer packetSize) {
        this.packetSize = packetSize;
    }

    public Integer getPacketSize() {
        return this.packetSize;
    }

    public CreateMonitorProbeInput withPacketSize(Integer packetSize) {
        this.setPacketSize(packetSize);
        return this;
    }

    public Map<String, String> getProbeTags() {
        return this.probeTags;
    }

    public void setProbeTags(Map<String, String> probeTags) {
        this.probeTags = probeTags;
    }

    public CreateMonitorProbeInput withProbeTags(Map<String, String> probeTags) {
        this.setProbeTags(probeTags);
        return this;
    }

    public CreateMonitorProbeInput addProbeTagsEntry(String key, String value) {
        if (null == this.probeTags) {
            this.probeTags = new HashMap<String, String>();
        }
        if (this.probeTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.probeTags.put(key, value);
        return this;
    }

    public CreateMonitorProbeInput clearProbeTagsEntries() {
        this.probeTags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceArn() != null) {
            sb.append("SourceArn: ").append(this.getSourceArn()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getDestinationPort() != null) {
            sb.append("DestinationPort: ").append(this.getDestinationPort()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getPacketSize() != null) {
            sb.append("PacketSize: ").append(this.getPacketSize()).append(",");
        }
        if (this.getProbeTags() != null) {
            sb.append("ProbeTags: ").append(this.getProbeTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorProbeInput)) {
            return false;
        }
        CreateMonitorProbeInput other = (CreateMonitorProbeInput)obj;
        if (other.getSourceArn() == null ^ this.getSourceArn() == null) {
            return false;
        }
        if (other.getSourceArn() != null && !other.getSourceArn().equals(this.getSourceArn())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getDestinationPort() == null ^ this.getDestinationPort() == null) {
            return false;
        }
        if (other.getDestinationPort() != null && !other.getDestinationPort().equals(this.getDestinationPort())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getPacketSize() == null ^ this.getPacketSize() == null) {
            return false;
        }
        if (other.getPacketSize() != null && !other.getPacketSize().equals(this.getPacketSize())) {
            return false;
        }
        if (other.getProbeTags() == null ^ this.getProbeTags() == null) {
            return false;
        }
        return other.getProbeTags() == null || other.getProbeTags().equals(this.getProbeTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceArn() == null ? 0 : this.getSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPort() == null ? 0 : this.getDestinationPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getPacketSize() == null ? 0 : this.getPacketSize().hashCode());
        hashCode = 31 * hashCode + (this.getProbeTags() == null ? 0 : this.getProbeTags().hashCode());
        return hashCode;
    }

    public CreateMonitorProbeInput clone() {
        try {
            return (CreateMonitorProbeInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateMonitorProbeInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

