/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.networkmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetTransitGatewayPeering"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetTransitGatewayPeeringResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Returns information about a transit gateway peering.
     * </p>
     */
    private TransitGatewayPeering transitGatewayPeering;

    /**
     * <p>
     * Returns information about a transit gateway peering.
     * </p>
     * 
     * @param transitGatewayPeering
     *        Returns information about a transit gateway peering.
     */

    public void setTransitGatewayPeering(TransitGatewayPeering transitGatewayPeering) {
        this.transitGatewayPeering = transitGatewayPeering;
    }

    /**
     * <p>
     * Returns information about a transit gateway peering.
     * </p>
     * 
     * @return Returns information about a transit gateway peering.
     */

    public TransitGatewayPeering getTransitGatewayPeering() {
        return this.transitGatewayPeering;
    }

    /**
     * <p>
     * Returns information about a transit gateway peering.
     * </p>
     * 
     * @param transitGatewayPeering
     *        Returns information about a transit gateway peering.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetTransitGatewayPeeringResult withTransitGatewayPeering(TransitGatewayPeering transitGatewayPeering) {
        setTransitGatewayPeering(transitGatewayPeering);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTransitGatewayPeering() != null)
            sb.append("TransitGatewayPeering: ").append(getTransitGatewayPeering());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetTransitGatewayPeeringResult == false)
            return false;
        GetTransitGatewayPeeringResult other = (GetTransitGatewayPeeringResult) obj;
        if (other.getTransitGatewayPeering() == null ^ this.getTransitGatewayPeering() == null)
            return false;
        if (other.getTransitGatewayPeering() != null && other.getTransitGatewayPeering().equals(this.getTransitGatewayPeering()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTransitGatewayPeering() == null) ? 0 : getTransitGatewayPeering().hashCode());
        return hashCode;
    }

    @Override
    public GetTransitGatewayPeeringResult clone() {
        try {
            return (GetTransitGatewayPeeringResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
