/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.IPSet;
import com.amazonaws.services.networkfirewall.model.PortSet;
import com.amazonaws.services.networkfirewall.model.transform.RuleVariablesMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RuleVariables
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, IPSet> iPSets;
    private Map<String, PortSet> portSets;

    public Map<String, IPSet> getIPSets() {
        return this.iPSets;
    }

    public void setIPSets(Map<String, IPSet> iPSets) {
        this.iPSets = iPSets;
    }

    public RuleVariables withIPSets(Map<String, IPSet> iPSets) {
        this.setIPSets(iPSets);
        return this;
    }

    public RuleVariables addIPSetsEntry(String key, IPSet value) {
        if (null == this.iPSets) {
            this.iPSets = new HashMap<String, IPSet>();
        }
        if (this.iPSets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.iPSets.put(key, value);
        return this;
    }

    public RuleVariables clearIPSetsEntries() {
        this.iPSets = null;
        return this;
    }

    public Map<String, PortSet> getPortSets() {
        return this.portSets;
    }

    public void setPortSets(Map<String, PortSet> portSets) {
        this.portSets = portSets;
    }

    public RuleVariables withPortSets(Map<String, PortSet> portSets) {
        this.setPortSets(portSets);
        return this;
    }

    public RuleVariables addPortSetsEntry(String key, PortSet value) {
        if (null == this.portSets) {
            this.portSets = new HashMap<String, PortSet>();
        }
        if (this.portSets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.portSets.put(key, value);
        return this;
    }

    public RuleVariables clearPortSetsEntries() {
        this.portSets = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIPSets() != null) {
            sb.append("IPSets: ").append(this.getIPSets()).append(",");
        }
        if (this.getPortSets() != null) {
            sb.append("PortSets: ").append(this.getPortSets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleVariables)) {
            return false;
        }
        RuleVariables other = (RuleVariables)obj;
        if (other.getIPSets() == null ^ this.getIPSets() == null) {
            return false;
        }
        if (other.getIPSets() != null && !other.getIPSets().equals(this.getIPSets())) {
            return false;
        }
        if (other.getPortSets() == null ^ this.getPortSets() == null) {
            return false;
        }
        return other.getPortSets() == null || other.getPortSets().equals(this.getPortSets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIPSets() == null ? 0 : this.getIPSets().hashCode());
        hashCode = 31 * hashCode + (this.getPortSets() == null ? 0 : this.getPortSets().hashCode());
        return hashCode;
    }

    public RuleVariables clone() {
        try {
            return (RuleVariables)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleVariablesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

