/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.networkfirewall.model.FirewallMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFirewallsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<FirewallMetadata> firewalls;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFirewallsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<FirewallMetadata> getFirewalls() {
        return this.firewalls;
    }

    public void setFirewalls(Collection<FirewallMetadata> firewalls) {
        if (firewalls == null) {
            this.firewalls = null;
            return;
        }
        this.firewalls = new ArrayList<FirewallMetadata>(firewalls);
    }

    public ListFirewallsResult withFirewalls(FirewallMetadata ... firewalls) {
        if (this.firewalls == null) {
            this.setFirewalls(new ArrayList<FirewallMetadata>(firewalls.length));
        }
        for (FirewallMetadata ele : firewalls) {
            this.firewalls.add(ele);
        }
        return this;
    }

    public ListFirewallsResult withFirewalls(Collection<FirewallMetadata> firewalls) {
        this.setFirewalls(firewalls);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getFirewalls() != null) {
            sb.append("Firewalls: ").append(this.getFirewalls());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallsResult)) {
            return false;
        }
        ListFirewallsResult other = (ListFirewallsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getFirewalls() == null ^ this.getFirewalls() == null) {
            return false;
        }
        return other.getFirewalls() == null || other.getFirewalls().equals(this.getFirewalls());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getFirewalls() == null ? 0 : this.getFirewalls().hashCode());
        return hashCode;
    }

    public ListFirewallsResult clone() {
        try {
            return (ListFirewallsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

