/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.neptunedata.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ExecuteOpenCypherExplainQueryRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ExecuteOpenCypherExplainQueryRequestMarshaller {

    private static final MarshallingInfo<String> OPENCYPHERQUERY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("query").build();
    private static final MarshallingInfo<String> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").build();
    private static final MarshallingInfo<String> EXPLAINMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("explain").build();

    private static final ExecuteOpenCypherExplainQueryRequestMarshaller instance = new ExecuteOpenCypherExplainQueryRequestMarshaller();

    public static ExecuteOpenCypherExplainQueryRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ExecuteOpenCypherExplainQueryRequest executeOpenCypherExplainQueryRequest, ProtocolMarshaller protocolMarshaller) {

        if (executeOpenCypherExplainQueryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(executeOpenCypherExplainQueryRequest.getOpenCypherQuery(), OPENCYPHERQUERY_BINDING);
            protocolMarshaller.marshall(executeOpenCypherExplainQueryRequest.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(executeOpenCypherExplainQueryRequest.getExplainMode(), EXPLAINMODE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
