/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLDataProcessingJob"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartMLDataProcessingJobRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The job ID of a completed data processing job run on an earlier version of the data.
     * </p>
     */
    private String previousDataProcessingJobId;
    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data processing
     * job.
     * </p>
     */
    private String inputDataS3Location;
    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     * </p>
     */
    private String processedDataS3Location;
    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     */
    private String sagemakerIamRoleArn;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf. This
     * must be listed in your DB cluster parameter group or an error will occur.
     * </p>
     */
    private String neptuneIamRoleArn;
    /**
     * <p>
     * The type of ML instance used during data processing. Its memory should be large enough to hold the processed
     * dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size of the exported
     * graph data on disk.
     * </p>
     */
    private String processingInstanceType;
    /**
     * <p>
     * The disk volume size of the processing instance. Both input data and processed data are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * chooses the volume size automatically based on the data size.
     * </p>
     */
    private Integer processingInstanceVolumeSizeInGB;
    /**
     * <p>
     * Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     * </p>
     */
    private Integer processingTimeOutInSeconds;
    /**
     * <p>
     * One of the two model types that Neptune ML currently supports: heterogeneous graph models (
     * <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not specified,
     * Neptune ML chooses the model type automatically based on the data.
     * </p>
     */
    private String modelType;
    /**
     * <p>
     * A data specification file that describes how to load the exported graph data for training. The file is
     * automatically generated by the Neptune export toolkit. The default is
     * <code>training-data-configuration.json</code>.
     * </p>
     */
    private String configFileName;
    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     */
    private java.util.List<String> subnets;
    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     */
    private java.util.List<String> securityGroupIds;
    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume
     * attached to the ML compute instances that run the training job. The default is None.
     * </p>
     */
    private String volumeEncryptionKMSKey;
    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the processing
     * job. The default is none.
     * </p>
     */
    private String s3OutputEncryptionKMSKey;

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     * 
     * @param id
     *        A unique identifier for the new job. The default is an autogenerated UUID.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     * 
     * @return A unique identifier for the new job. The default is an autogenerated UUID.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     * 
     * @param id
     *        A unique identifier for the new job. The default is an autogenerated UUID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The job ID of a completed data processing job run on an earlier version of the data.
     * </p>
     * 
     * @param previousDataProcessingJobId
     *        The job ID of a completed data processing job run on an earlier version of the data.
     */

    public void setPreviousDataProcessingJobId(String previousDataProcessingJobId) {
        this.previousDataProcessingJobId = previousDataProcessingJobId;
    }

    /**
     * <p>
     * The job ID of a completed data processing job run on an earlier version of the data.
     * </p>
     * 
     * @return The job ID of a completed data processing job run on an earlier version of the data.
     */

    public String getPreviousDataProcessingJobId() {
        return this.previousDataProcessingJobId;
    }

    /**
     * <p>
     * The job ID of a completed data processing job run on an earlier version of the data.
     * </p>
     * 
     * @param previousDataProcessingJobId
     *        The job ID of a completed data processing job run on an earlier version of the data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withPreviousDataProcessingJobId(String previousDataProcessingJobId) {
        setPreviousDataProcessingJobId(previousDataProcessingJobId);
        return this;
    }

    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data processing
     * job.
     * </p>
     * 
     * @param inputDataS3Location
     *        The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data
     *        processing job.
     */

    public void setInputDataS3Location(String inputDataS3Location) {
        this.inputDataS3Location = inputDataS3Location;
    }

    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data processing
     * job.
     * </p>
     * 
     * @return The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data
     *         processing job.
     */

    public String getInputDataS3Location() {
        return this.inputDataS3Location;
    }

    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data processing
     * job.
     * </p>
     * 
     * @param inputDataS3Location
     *        The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data
     *        processing job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withInputDataS3Location(String inputDataS3Location) {
        setInputDataS3Location(inputDataS3Location);
        return this;
    }

    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     * </p>
     * 
     * @param processedDataS3Location
     *        The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     */

    public void setProcessedDataS3Location(String processedDataS3Location) {
        this.processedDataS3Location = processedDataS3Location;
    }

    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     * </p>
     * 
     * @return The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     */

    public String getProcessedDataS3Location() {
        return this.processedDataS3Location;
    }

    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     * </p>
     * 
     * @param processedDataS3Location
     *        The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withProcessedDataS3Location(String processedDataS3Location) {
        setProcessedDataS3Location(processedDataS3Location);
        return this;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     * 
     * @param sagemakerIamRoleArn
     *        The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or
     *        an error will occur.
     */

    public void setSagemakerIamRoleArn(String sagemakerIamRoleArn) {
        this.sagemakerIamRoleArn = sagemakerIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or
     *         an error will occur.
     */

    public String getSagemakerIamRoleArn() {
        return this.sagemakerIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     * 
     * @param sagemakerIamRoleArn
     *        The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or
     *        an error will occur.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withSagemakerIamRoleArn(String sagemakerIamRoleArn) {
        setSagemakerIamRoleArn(sagemakerIamRoleArn);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf. This
     * must be listed in your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @param neptuneIamRoleArn
     *        The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf.
     *        This must be listed in your DB cluster parameter group or an error will occur.
     */

    public void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
        this.neptuneIamRoleArn = neptuneIamRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf. This
     * must be listed in your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf.
     *         This must be listed in your DB cluster parameter group or an error will occur.
     */

    public String getNeptuneIamRoleArn() {
        return this.neptuneIamRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf. This
     * must be listed in your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @param neptuneIamRoleArn
     *        The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf.
     *        This must be listed in your DB cluster parameter group or an error will occur.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withNeptuneIamRoleArn(String neptuneIamRoleArn) {
        setNeptuneIamRoleArn(neptuneIamRoleArn);
        return this;
    }

    /**
     * <p>
     * The type of ML instance used during data processing. Its memory should be large enough to hold the processed
     * dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size of the exported
     * graph data on disk.
     * </p>
     * 
     * @param processingInstanceType
     *        The type of ML instance used during data processing. Its memory should be large enough to hold the
     *        processed dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size
     *        of the exported graph data on disk.
     */

    public void setProcessingInstanceType(String processingInstanceType) {
        this.processingInstanceType = processingInstanceType;
    }

    /**
     * <p>
     * The type of ML instance used during data processing. Its memory should be large enough to hold the processed
     * dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size of the exported
     * graph data on disk.
     * </p>
     * 
     * @return The type of ML instance used during data processing. Its memory should be large enough to hold the
     *         processed dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size
     *         of the exported graph data on disk.
     */

    public String getProcessingInstanceType() {
        return this.processingInstanceType;
    }

    /**
     * <p>
     * The type of ML instance used during data processing. Its memory should be large enough to hold the processed
     * dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size of the exported
     * graph data on disk.
     * </p>
     * 
     * @param processingInstanceType
     *        The type of ML instance used during data processing. Its memory should be large enough to hold the
     *        processed dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size
     *        of the exported graph data on disk.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withProcessingInstanceType(String processingInstanceType) {
        setProcessingInstanceType(processingInstanceType);
        return this;
    }

    /**
     * <p>
     * The disk volume size of the processing instance. Both input data and processed data are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * chooses the volume size automatically based on the data size.
     * </p>
     * 
     * @param processingInstanceVolumeSizeInGB
     *        The disk volume size of the processing instance. Both input data and processed data are stored on disk, so
     *        the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0,
     *        Neptune ML chooses the volume size automatically based on the data size.
     */

    public void setProcessingInstanceVolumeSizeInGB(Integer processingInstanceVolumeSizeInGB) {
        this.processingInstanceVolumeSizeInGB = processingInstanceVolumeSizeInGB;
    }

    /**
     * <p>
     * The disk volume size of the processing instance. Both input data and processed data are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * chooses the volume size automatically based on the data size.
     * </p>
     * 
     * @return The disk volume size of the processing instance. Both input data and processed data are stored on disk,
     *         so the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0,
     *         Neptune ML chooses the volume size automatically based on the data size.
     */

    public Integer getProcessingInstanceVolumeSizeInGB() {
        return this.processingInstanceVolumeSizeInGB;
    }

    /**
     * <p>
     * The disk volume size of the processing instance. Both input data and processed data are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * chooses the volume size automatically based on the data size.
     * </p>
     * 
     * @param processingInstanceVolumeSizeInGB
     *        The disk volume size of the processing instance. Both input data and processed data are stored on disk, so
     *        the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0,
     *        Neptune ML chooses the volume size automatically based on the data size.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withProcessingInstanceVolumeSizeInGB(Integer processingInstanceVolumeSizeInGB) {
        setProcessingInstanceVolumeSizeInGB(processingInstanceVolumeSizeInGB);
        return this;
    }

    /**
     * <p>
     * Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     * </p>
     * 
     * @param processingTimeOutInSeconds
     *        Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     */

    public void setProcessingTimeOutInSeconds(Integer processingTimeOutInSeconds) {
        this.processingTimeOutInSeconds = processingTimeOutInSeconds;
    }

    /**
     * <p>
     * Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     * </p>
     * 
     * @return Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     */

    public Integer getProcessingTimeOutInSeconds() {
        return this.processingTimeOutInSeconds;
    }

    /**
     * <p>
     * Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     * </p>
     * 
     * @param processingTimeOutInSeconds
     *        Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withProcessingTimeOutInSeconds(Integer processingTimeOutInSeconds) {
        setProcessingTimeOutInSeconds(processingTimeOutInSeconds);
        return this;
    }

    /**
     * <p>
     * One of the two model types that Neptune ML currently supports: heterogeneous graph models (
     * <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not specified,
     * Neptune ML chooses the model type automatically based on the data.
     * </p>
     * 
     * @param modelType
     *        One of the two model types that Neptune ML currently supports: heterogeneous graph models (
     *        <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not
     *        specified, Neptune ML chooses the model type automatically based on the data.
     */

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    /**
     * <p>
     * One of the two model types that Neptune ML currently supports: heterogeneous graph models (
     * <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not specified,
     * Neptune ML chooses the model type automatically based on the data.
     * </p>
     * 
     * @return One of the two model types that Neptune ML currently supports: heterogeneous graph models (
     *         <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not
     *         specified, Neptune ML chooses the model type automatically based on the data.
     */

    public String getModelType() {
        return this.modelType;
    }

    /**
     * <p>
     * One of the two model types that Neptune ML currently supports: heterogeneous graph models (
     * <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not specified,
     * Neptune ML chooses the model type automatically based on the data.
     * </p>
     * 
     * @param modelType
     *        One of the two model types that Neptune ML currently supports: heterogeneous graph models (
     *        <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not
     *        specified, Neptune ML chooses the model type automatically based on the data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withModelType(String modelType) {
        setModelType(modelType);
        return this;
    }

    /**
     * <p>
     * A data specification file that describes how to load the exported graph data for training. The file is
     * automatically generated by the Neptune export toolkit. The default is
     * <code>training-data-configuration.json</code>.
     * </p>
     * 
     * @param configFileName
     *        A data specification file that describes how to load the exported graph data for training. The file is
     *        automatically generated by the Neptune export toolkit. The default is
     *        <code>training-data-configuration.json</code>.
     */

    public void setConfigFileName(String configFileName) {
        this.configFileName = configFileName;
    }

    /**
     * <p>
     * A data specification file that describes how to load the exported graph data for training. The file is
     * automatically generated by the Neptune export toolkit. The default is
     * <code>training-data-configuration.json</code>.
     * </p>
     * 
     * @return A data specification file that describes how to load the exported graph data for training. The file is
     *         automatically generated by the Neptune export toolkit. The default is
     *         <code>training-data-configuration.json</code>.
     */

    public String getConfigFileName() {
        return this.configFileName;
    }

    /**
     * <p>
     * A data specification file that describes how to load the exported graph data for training. The file is
     * automatically generated by the Neptune export toolkit. The default is
     * <code>training-data-configuration.json</code>.
     * </p>
     * 
     * @param configFileName
     *        A data specification file that describes how to load the exported graph data for training. The file is
     *        automatically generated by the Neptune export toolkit. The default is
     *        <code>training-data-configuration.json</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withConfigFileName(String configFileName) {
        setConfigFileName(configFileName);
        return this;
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * 
     * @return The IDs of the subnets in the Neptune VPC. The default is None.
     */

    public java.util.List<String> getSubnets() {
        return subnets;
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * 
     * @param subnets
     *        The IDs of the subnets in the Neptune VPC. The default is None.
     */

    public void setSubnets(java.util.Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }

        this.subnets = new java.util.ArrayList<String>(subnets);
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSubnets(java.util.Collection)} or {@link #withSubnets(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param subnets
     *        The IDs of the subnets in the Neptune VPC. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withSubnets(String... subnets) {
        if (this.subnets == null) {
            setSubnets(new java.util.ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * 
     * @param subnets
     *        The IDs of the subnets in the Neptune VPC. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withSubnets(java.util.Collection<String> subnets) {
        setSubnets(subnets);
        return this;
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * 
     * @return The VPC security group IDs. The default is None.
     */

    public java.util.List<String> getSecurityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * 
     * @param securityGroupIds
     *        The VPC security group IDs. The default is None.
     */

    public void setSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }

        this.securityGroupIds = new java.util.ArrayList<String>(securityGroupIds);
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSecurityGroupIds(java.util.Collection)} or {@link #withSecurityGroupIds(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param securityGroupIds
     *        The VPC security group IDs. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withSecurityGroupIds(String... securityGroupIds) {
        if (this.securityGroupIds == null) {
            setSecurityGroupIds(new java.util.ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * 
     * @param securityGroupIds
     *        The VPC security group IDs. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        setSecurityGroupIds(securityGroupIds);
        return this;
    }

    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume
     * attached to the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @param volumeEncryptionKMSKey
     *        The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage
     *        volume attached to the ML compute instances that run the training job. The default is None.
     */

    public void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
        this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume
     * attached to the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @return The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage
     *         volume attached to the ML compute instances that run the training job. The default is None.
     */

    public String getVolumeEncryptionKMSKey() {
        return this.volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume
     * attached to the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @param volumeEncryptionKMSKey
     *        The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage
     *        volume attached to the ML compute instances that run the training job. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
        setVolumeEncryptionKMSKey(volumeEncryptionKMSKey);
        return this;
    }

    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the processing
     * job. The default is none.
     * </p>
     * 
     * @param s3OutputEncryptionKMSKey
     *        The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the
     *        processing job. The default is none.
     */

    public void setS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
        this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the processing
     * job. The default is none.
     * </p>
     * 
     * @return The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the
     *         processing job. The default is none.
     */

    public String getS3OutputEncryptionKMSKey() {
        return this.s3OutputEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the processing
     * job. The default is none.
     * </p>
     * 
     * @param s3OutputEncryptionKMSKey
     *        The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the
     *        processing job. The default is none.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLDataProcessingJobRequest withS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
        setS3OutputEncryptionKMSKey(s3OutputEncryptionKMSKey);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getPreviousDataProcessingJobId() != null)
            sb.append("PreviousDataProcessingJobId: ").append(getPreviousDataProcessingJobId()).append(",");
        if (getInputDataS3Location() != null)
            sb.append("InputDataS3Location: ").append(getInputDataS3Location()).append(",");
        if (getProcessedDataS3Location() != null)
            sb.append("ProcessedDataS3Location: ").append(getProcessedDataS3Location()).append(",");
        if (getSagemakerIamRoleArn() != null)
            sb.append("SagemakerIamRoleArn: ").append(getSagemakerIamRoleArn()).append(",");
        if (getNeptuneIamRoleArn() != null)
            sb.append("NeptuneIamRoleArn: ").append(getNeptuneIamRoleArn()).append(",");
        if (getProcessingInstanceType() != null)
            sb.append("ProcessingInstanceType: ").append(getProcessingInstanceType()).append(",");
        if (getProcessingInstanceVolumeSizeInGB() != null)
            sb.append("ProcessingInstanceVolumeSizeInGB: ").append(getProcessingInstanceVolumeSizeInGB()).append(",");
        if (getProcessingTimeOutInSeconds() != null)
            sb.append("ProcessingTimeOutInSeconds: ").append(getProcessingTimeOutInSeconds()).append(",");
        if (getModelType() != null)
            sb.append("ModelType: ").append(getModelType()).append(",");
        if (getConfigFileName() != null)
            sb.append("ConfigFileName: ").append(getConfigFileName()).append(",");
        if (getSubnets() != null)
            sb.append("Subnets: ").append(getSubnets()).append(",");
        if (getSecurityGroupIds() != null)
            sb.append("SecurityGroupIds: ").append(getSecurityGroupIds()).append(",");
        if (getVolumeEncryptionKMSKey() != null)
            sb.append("VolumeEncryptionKMSKey: ").append(getVolumeEncryptionKMSKey()).append(",");
        if (getS3OutputEncryptionKMSKey() != null)
            sb.append("S3OutputEncryptionKMSKey: ").append(getS3OutputEncryptionKMSKey());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartMLDataProcessingJobRequest == false)
            return false;
        StartMLDataProcessingJobRequest other = (StartMLDataProcessingJobRequest) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getPreviousDataProcessingJobId() == null ^ this.getPreviousDataProcessingJobId() == null)
            return false;
        if (other.getPreviousDataProcessingJobId() != null && other.getPreviousDataProcessingJobId().equals(this.getPreviousDataProcessingJobId()) == false)
            return false;
        if (other.getInputDataS3Location() == null ^ this.getInputDataS3Location() == null)
            return false;
        if (other.getInputDataS3Location() != null && other.getInputDataS3Location().equals(this.getInputDataS3Location()) == false)
            return false;
        if (other.getProcessedDataS3Location() == null ^ this.getProcessedDataS3Location() == null)
            return false;
        if (other.getProcessedDataS3Location() != null && other.getProcessedDataS3Location().equals(this.getProcessedDataS3Location()) == false)
            return false;
        if (other.getSagemakerIamRoleArn() == null ^ this.getSagemakerIamRoleArn() == null)
            return false;
        if (other.getSagemakerIamRoleArn() != null && other.getSagemakerIamRoleArn().equals(this.getSagemakerIamRoleArn()) == false)
            return false;
        if (other.getNeptuneIamRoleArn() == null ^ this.getNeptuneIamRoleArn() == null)
            return false;
        if (other.getNeptuneIamRoleArn() != null && other.getNeptuneIamRoleArn().equals(this.getNeptuneIamRoleArn()) == false)
            return false;
        if (other.getProcessingInstanceType() == null ^ this.getProcessingInstanceType() == null)
            return false;
        if (other.getProcessingInstanceType() != null && other.getProcessingInstanceType().equals(this.getProcessingInstanceType()) == false)
            return false;
        if (other.getProcessingInstanceVolumeSizeInGB() == null ^ this.getProcessingInstanceVolumeSizeInGB() == null)
            return false;
        if (other.getProcessingInstanceVolumeSizeInGB() != null
                && other.getProcessingInstanceVolumeSizeInGB().equals(this.getProcessingInstanceVolumeSizeInGB()) == false)
            return false;
        if (other.getProcessingTimeOutInSeconds() == null ^ this.getProcessingTimeOutInSeconds() == null)
            return false;
        if (other.getProcessingTimeOutInSeconds() != null && other.getProcessingTimeOutInSeconds().equals(this.getProcessingTimeOutInSeconds()) == false)
            return false;
        if (other.getModelType() == null ^ this.getModelType() == null)
            return false;
        if (other.getModelType() != null && other.getModelType().equals(this.getModelType()) == false)
            return false;
        if (other.getConfigFileName() == null ^ this.getConfigFileName() == null)
            return false;
        if (other.getConfigFileName() != null && other.getConfigFileName().equals(this.getConfigFileName()) == false)
            return false;
        if (other.getSubnets() == null ^ this.getSubnets() == null)
            return false;
        if (other.getSubnets() != null && other.getSubnets().equals(this.getSubnets()) == false)
            return false;
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null)
            return false;
        if (other.getSecurityGroupIds() != null && other.getSecurityGroupIds().equals(this.getSecurityGroupIds()) == false)
            return false;
        if (other.getVolumeEncryptionKMSKey() == null ^ this.getVolumeEncryptionKMSKey() == null)
            return false;
        if (other.getVolumeEncryptionKMSKey() != null && other.getVolumeEncryptionKMSKey().equals(this.getVolumeEncryptionKMSKey()) == false)
            return false;
        if (other.getS3OutputEncryptionKMSKey() == null ^ this.getS3OutputEncryptionKMSKey() == null)
            return false;
        if (other.getS3OutputEncryptionKMSKey() != null && other.getS3OutputEncryptionKMSKey().equals(this.getS3OutputEncryptionKMSKey()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getPreviousDataProcessingJobId() == null) ? 0 : getPreviousDataProcessingJobId().hashCode());
        hashCode = prime * hashCode + ((getInputDataS3Location() == null) ? 0 : getInputDataS3Location().hashCode());
        hashCode = prime * hashCode + ((getProcessedDataS3Location() == null) ? 0 : getProcessedDataS3Location().hashCode());
        hashCode = prime * hashCode + ((getSagemakerIamRoleArn() == null) ? 0 : getSagemakerIamRoleArn().hashCode());
        hashCode = prime * hashCode + ((getNeptuneIamRoleArn() == null) ? 0 : getNeptuneIamRoleArn().hashCode());
        hashCode = prime * hashCode + ((getProcessingInstanceType() == null) ? 0 : getProcessingInstanceType().hashCode());
        hashCode = prime * hashCode + ((getProcessingInstanceVolumeSizeInGB() == null) ? 0 : getProcessingInstanceVolumeSizeInGB().hashCode());
        hashCode = prime * hashCode + ((getProcessingTimeOutInSeconds() == null) ? 0 : getProcessingTimeOutInSeconds().hashCode());
        hashCode = prime * hashCode + ((getModelType() == null) ? 0 : getModelType().hashCode());
        hashCode = prime * hashCode + ((getConfigFileName() == null) ? 0 : getConfigFileName().hashCode());
        hashCode = prime * hashCode + ((getSubnets() == null) ? 0 : getSubnets().hashCode());
        hashCode = prime * hashCode + ((getSecurityGroupIds() == null) ? 0 : getSecurityGroupIds().hashCode());
        hashCode = prime * hashCode + ((getVolumeEncryptionKMSKey() == null) ? 0 : getVolumeEncryptionKMSKey().hashCode());
        hashCode = prime * hashCode + ((getS3OutputEncryptionKMSKey() == null) ? 0 : getS3OutputEncryptionKMSKey().hashCode());
        return hashCode;
    }

    @Override
    public StartMLDataProcessingJobRequest clone() {
        return (StartMLDataProcessingJobRequest) super.clone();
    }

}
