/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.SignerTypeAware;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTrainingJob"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartMLModelTrainingJobRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable, SignerTypeAware {

    /**
     * <p>
     * A unique identifier for the new job. The default is An autogenerated UUID.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The job ID of a completed model-training job that you want to update incrementally based on updated data.
     * </p>
     */
    private String previousModelTrainingJobId;
    /**
     * <p>
     * The job ID of the completed data-processing job that has created the data that the training will work with.
     * </p>
     */
    private String dataProcessingJobId;
    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     */
    private String trainModelS3Location;
    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or an error
     * will occur.
     * </p>
     */
    private String sagemakerIamRoleArn;
    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     */
    private String neptuneIamRoleArn;
    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is a CPU instance chosen based
     * on memory requirements for processing the training data and model.
     * </p>
     */
    private String baseProcessingInstanceType;
    /**
     * <p>
     * The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU training.
     * The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training depends on the task
     * type, graph size, and your budget.
     * </p>
     */
    private String trainingInstanceType;
    /**
     * <p>
     * The disk volume size of the training instance. Both input data and the output model are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     */
    private Integer trainingInstanceVolumeSizeInGB;
    /**
     * <p>
     * Timeout in seconds for the training job. The default is 86,400 (1 day).
     * </p>
     */
    private Integer trainingTimeOutInSeconds;
    /**
     * <p>
     * Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2. Neptune ML
     * automatically tunes the hyperparameters of the machine learning model. To obtain a model that performs well, use
     * at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10). In general, the more tuning
     * runs, the better the results.
     * </p>
     */
    private Integer maxHPONumberOfTrainingJobs;
    /**
     * <p>
     * Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2. The number
     * of parallel jobs you can run is limited by the available resources on your training instance.
     * </p>
     */
    private Integer maxHPOParallelTrainingJobs;
    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     */
    private java.util.List<String> subnets;
    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     */
    private java.util.List<String> securityGroupIds;
    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     */
    private String volumeEncryptionKMSKey;
    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     */
    private String s3OutputEncryptionKMSKey;
    /**
     * <p>
     * Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot instances. The
     * default is <code>False</code>.
     * </p>
     */
    private Boolean enableManagedSpotTraining;
    /**
     * <p>
     * The configuration for custom model training. This is a JSON object.
     * </p>
     */
    private CustomModelTrainingParameters customModelTrainingParameters;

    /**
     * <p>
     * A unique identifier for the new job. The default is An autogenerated UUID.
     * </p>
     * 
     * @param id
     *        A unique identifier for the new job. The default is An autogenerated UUID.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * A unique identifier for the new job. The default is An autogenerated UUID.
     * </p>
     * 
     * @return A unique identifier for the new job. The default is An autogenerated UUID.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * A unique identifier for the new job. The default is An autogenerated UUID.
     * </p>
     * 
     * @param id
     *        A unique identifier for the new job. The default is An autogenerated UUID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The job ID of a completed model-training job that you want to update incrementally based on updated data.
     * </p>
     * 
     * @param previousModelTrainingJobId
     *        The job ID of a completed model-training job that you want to update incrementally based on updated data.
     */

    public void setPreviousModelTrainingJobId(String previousModelTrainingJobId) {
        this.previousModelTrainingJobId = previousModelTrainingJobId;
    }

    /**
     * <p>
     * The job ID of a completed model-training job that you want to update incrementally based on updated data.
     * </p>
     * 
     * @return The job ID of a completed model-training job that you want to update incrementally based on updated data.
     */

    public String getPreviousModelTrainingJobId() {
        return this.previousModelTrainingJobId;
    }

    /**
     * <p>
     * The job ID of a completed model-training job that you want to update incrementally based on updated data.
     * </p>
     * 
     * @param previousModelTrainingJobId
     *        The job ID of a completed model-training job that you want to update incrementally based on updated data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withPreviousModelTrainingJobId(String previousModelTrainingJobId) {
        setPreviousModelTrainingJobId(previousModelTrainingJobId);
        return this;
    }

    /**
     * <p>
     * The job ID of the completed data-processing job that has created the data that the training will work with.
     * </p>
     * 
     * @param dataProcessingJobId
     *        The job ID of the completed data-processing job that has created the data that the training will work
     *        with.
     */

    public void setDataProcessingJobId(String dataProcessingJobId) {
        this.dataProcessingJobId = dataProcessingJobId;
    }

    /**
     * <p>
     * The job ID of the completed data-processing job that has created the data that the training will work with.
     * </p>
     * 
     * @return The job ID of the completed data-processing job that has created the data that the training will work
     *         with.
     */

    public String getDataProcessingJobId() {
        return this.dataProcessingJobId;
    }

    /**
     * <p>
     * The job ID of the completed data-processing job that has created the data that the training will work with.
     * </p>
     * 
     * @param dataProcessingJobId
     *        The job ID of the completed data-processing job that has created the data that the training will work
     *        with.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withDataProcessingJobId(String dataProcessingJobId) {
        setDataProcessingJobId(dataProcessingJobId);
        return this;
    }

    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     * 
     * @param trainModelS3Location
     *        The location in Amazon S3 where the model artifacts are to be stored.
     */

    public void setTrainModelS3Location(String trainModelS3Location) {
        this.trainModelS3Location = trainModelS3Location;
    }

    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     * 
     * @return The location in Amazon S3 where the model artifacts are to be stored.
     */

    public String getTrainModelS3Location() {
        return this.trainModelS3Location;
    }

    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     * 
     * @param trainModelS3Location
     *        The location in Amazon S3 where the model artifacts are to be stored.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withTrainModelS3Location(String trainModelS3Location) {
        setTrainModelS3Location(trainModelS3Location);
        return this;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or an error
     * will occur.
     * </p>
     * 
     * @param sagemakerIamRoleArn
     *        The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or
     *        an error will occur.
     */

    public void setSagemakerIamRoleArn(String sagemakerIamRoleArn) {
        this.sagemakerIamRoleArn = sagemakerIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or an error
     * will occur.
     * </p>
     * 
     * @return The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or
     *         an error will occur.
     */

    public String getSagemakerIamRoleArn() {
        return this.sagemakerIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or an error
     * will occur.
     * </p>
     * 
     * @param sagemakerIamRoleArn
     *        The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or
     *        an error will occur.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withSagemakerIamRoleArn(String sagemakerIamRoleArn) {
        setSagemakerIamRoleArn(sagemakerIamRoleArn);
        return this;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @param neptuneIamRoleArn
     *        The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *        listed in your DB cluster parameter group or an error will occur.
     */

    public void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
        this.neptuneIamRoleArn = neptuneIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *         listed in your DB cluster parameter group or an error will occur.
     */

    public String getNeptuneIamRoleArn() {
        return this.neptuneIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @param neptuneIamRoleArn
     *        The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *        listed in your DB cluster parameter group or an error will occur.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withNeptuneIamRoleArn(String neptuneIamRoleArn) {
        setNeptuneIamRoleArn(neptuneIamRoleArn);
        return this;
    }

    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is a CPU instance chosen based
     * on memory requirements for processing the training data and model.
     * </p>
     * 
     * @param baseProcessingInstanceType
     *        The type of ML instance used in preparing and managing training of ML models. This is a CPU instance
     *        chosen based on memory requirements for processing the training data and model.
     */

    public void setBaseProcessingInstanceType(String baseProcessingInstanceType) {
        this.baseProcessingInstanceType = baseProcessingInstanceType;
    }

    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is a CPU instance chosen based
     * on memory requirements for processing the training data and model.
     * </p>
     * 
     * @return The type of ML instance used in preparing and managing training of ML models. This is a CPU instance
     *         chosen based on memory requirements for processing the training data and model.
     */

    public String getBaseProcessingInstanceType() {
        return this.baseProcessingInstanceType;
    }

    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is a CPU instance chosen based
     * on memory requirements for processing the training data and model.
     * </p>
     * 
     * @param baseProcessingInstanceType
     *        The type of ML instance used in preparing and managing training of ML models. This is a CPU instance
     *        chosen based on memory requirements for processing the training data and model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withBaseProcessingInstanceType(String baseProcessingInstanceType) {
        setBaseProcessingInstanceType(baseProcessingInstanceType);
        return this;
    }

    /**
     * <p>
     * The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU training.
     * The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training depends on the task
     * type, graph size, and your budget.
     * </p>
     * 
     * @param trainingInstanceType
     *        The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU
     *        training. The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training depends
     *        on the task type, graph size, and your budget.
     */

    public void setTrainingInstanceType(String trainingInstanceType) {
        this.trainingInstanceType = trainingInstanceType;
    }

    /**
     * <p>
     * The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU training.
     * The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training depends on the task
     * type, graph size, and your budget.
     * </p>
     * 
     * @return The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU
     *         training. The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training
     *         depends on the task type, graph size, and your budget.
     */

    public String getTrainingInstanceType() {
        return this.trainingInstanceType;
    }

    /**
     * <p>
     * The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU training.
     * The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training depends on the task
     * type, graph size, and your budget.
     * </p>
     * 
     * @param trainingInstanceType
     *        The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU
     *        training. The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training depends
     *        on the task type, graph size, and your budget.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withTrainingInstanceType(String trainingInstanceType) {
        setTrainingInstanceType(trainingInstanceType);
        return this;
    }

    /**
     * <p>
     * The disk volume size of the training instance. Both input data and the output model are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     * 
     * @param trainingInstanceVolumeSizeInGB
     *        The disk volume size of the training instance. Both input data and the output model are stored on disk, so
     *        the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0,
     *        Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     */

    public void setTrainingInstanceVolumeSizeInGB(Integer trainingInstanceVolumeSizeInGB) {
        this.trainingInstanceVolumeSizeInGB = trainingInstanceVolumeSizeInGB;
    }

    /**
     * <p>
     * The disk volume size of the training instance. Both input data and the output model are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     * 
     * @return The disk volume size of the training instance. Both input data and the output model are stored on disk,
     *         so the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0,
     *         Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     */

    public Integer getTrainingInstanceVolumeSizeInGB() {
        return this.trainingInstanceVolumeSizeInGB;
    }

    /**
     * <p>
     * The disk volume size of the training instance. Both input data and the output model are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     * 
     * @param trainingInstanceVolumeSizeInGB
     *        The disk volume size of the training instance. Both input data and the output model are stored on disk, so
     *        the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0,
     *        Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withTrainingInstanceVolumeSizeInGB(Integer trainingInstanceVolumeSizeInGB) {
        setTrainingInstanceVolumeSizeInGB(trainingInstanceVolumeSizeInGB);
        return this;
    }

    /**
     * <p>
     * Timeout in seconds for the training job. The default is 86,400 (1 day).
     * </p>
     * 
     * @param trainingTimeOutInSeconds
     *        Timeout in seconds for the training job. The default is 86,400 (1 day).
     */

    public void setTrainingTimeOutInSeconds(Integer trainingTimeOutInSeconds) {
        this.trainingTimeOutInSeconds = trainingTimeOutInSeconds;
    }

    /**
     * <p>
     * Timeout in seconds for the training job. The default is 86,400 (1 day).
     * </p>
     * 
     * @return Timeout in seconds for the training job. The default is 86,400 (1 day).
     */

    public Integer getTrainingTimeOutInSeconds() {
        return this.trainingTimeOutInSeconds;
    }

    /**
     * <p>
     * Timeout in seconds for the training job. The default is 86,400 (1 day).
     * </p>
     * 
     * @param trainingTimeOutInSeconds
     *        Timeout in seconds for the training job. The default is 86,400 (1 day).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withTrainingTimeOutInSeconds(Integer trainingTimeOutInSeconds) {
        setTrainingTimeOutInSeconds(trainingTimeOutInSeconds);
        return this;
    }

    /**
     * <p>
     * Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2. Neptune ML
     * automatically tunes the hyperparameters of the machine learning model. To obtain a model that performs well, use
     * at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10). In general, the more tuning
     * runs, the better the results.
     * </p>
     * 
     * @param maxHPONumberOfTrainingJobs
     *        Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2.
     *        Neptune ML automatically tunes the hyperparameters of the machine learning model. To obtain a model that
     *        performs well, use at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10).
     *        In general, the more tuning runs, the better the results.
     */

    public void setMaxHPONumberOfTrainingJobs(Integer maxHPONumberOfTrainingJobs) {
        this.maxHPONumberOfTrainingJobs = maxHPONumberOfTrainingJobs;
    }

    /**
     * <p>
     * Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2. Neptune ML
     * automatically tunes the hyperparameters of the machine learning model. To obtain a model that performs well, use
     * at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10). In general, the more tuning
     * runs, the better the results.
     * </p>
     * 
     * @return Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2.
     *         Neptune ML automatically tunes the hyperparameters of the machine learning model. To obtain a model that
     *         performs well, use at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10).
     *         In general, the more tuning runs, the better the results.
     */

    public Integer getMaxHPONumberOfTrainingJobs() {
        return this.maxHPONumberOfTrainingJobs;
    }

    /**
     * <p>
     * Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2. Neptune ML
     * automatically tunes the hyperparameters of the machine learning model. To obtain a model that performs well, use
     * at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10). In general, the more tuning
     * runs, the better the results.
     * </p>
     * 
     * @param maxHPONumberOfTrainingJobs
     *        Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2.
     *        Neptune ML automatically tunes the hyperparameters of the machine learning model. To obtain a model that
     *        performs well, use at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10).
     *        In general, the more tuning runs, the better the results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withMaxHPONumberOfTrainingJobs(Integer maxHPONumberOfTrainingJobs) {
        setMaxHPONumberOfTrainingJobs(maxHPONumberOfTrainingJobs);
        return this;
    }

    /**
     * <p>
     * Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2. The number
     * of parallel jobs you can run is limited by the available resources on your training instance.
     * </p>
     * 
     * @param maxHPOParallelTrainingJobs
     *        Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2. The
     *        number of parallel jobs you can run is limited by the available resources on your training instance.
     */

    public void setMaxHPOParallelTrainingJobs(Integer maxHPOParallelTrainingJobs) {
        this.maxHPOParallelTrainingJobs = maxHPOParallelTrainingJobs;
    }

    /**
     * <p>
     * Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2. The number
     * of parallel jobs you can run is limited by the available resources on your training instance.
     * </p>
     * 
     * @return Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2.
     *         The number of parallel jobs you can run is limited by the available resources on your training instance.
     */

    public Integer getMaxHPOParallelTrainingJobs() {
        return this.maxHPOParallelTrainingJobs;
    }

    /**
     * <p>
     * Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2. The number
     * of parallel jobs you can run is limited by the available resources on your training instance.
     * </p>
     * 
     * @param maxHPOParallelTrainingJobs
     *        Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2. The
     *        number of parallel jobs you can run is limited by the available resources on your training instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withMaxHPOParallelTrainingJobs(Integer maxHPOParallelTrainingJobs) {
        setMaxHPOParallelTrainingJobs(maxHPOParallelTrainingJobs);
        return this;
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * 
     * @return The IDs of the subnets in the Neptune VPC. The default is None.
     */

    public java.util.List<String> getSubnets() {
        return subnets;
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * 
     * @param subnets
     *        The IDs of the subnets in the Neptune VPC. The default is None.
     */

    public void setSubnets(java.util.Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }

        this.subnets = new java.util.ArrayList<String>(subnets);
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSubnets(java.util.Collection)} or {@link #withSubnets(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param subnets
     *        The IDs of the subnets in the Neptune VPC. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withSubnets(String... subnets) {
        if (this.subnets == null) {
            setSubnets(new java.util.ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * 
     * @param subnets
     *        The IDs of the subnets in the Neptune VPC. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withSubnets(java.util.Collection<String> subnets) {
        setSubnets(subnets);
        return this;
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * 
     * @return The VPC security group IDs. The default is None.
     */

    public java.util.List<String> getSecurityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * 
     * @param securityGroupIds
     *        The VPC security group IDs. The default is None.
     */

    public void setSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }

        this.securityGroupIds = new java.util.ArrayList<String>(securityGroupIds);
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSecurityGroupIds(java.util.Collection)} or {@link #withSecurityGroupIds(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param securityGroupIds
     *        The VPC security group IDs. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withSecurityGroupIds(String... securityGroupIds) {
        if (this.securityGroupIds == null) {
            setSecurityGroupIds(new java.util.ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * 
     * @param securityGroupIds
     *        The VPC security group IDs. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        setSecurityGroupIds(securityGroupIds);
        return this;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @param volumeEncryptionKMSKey
     *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
     *        attached to the ML compute instances that run the training job. The default is None.
     */

    public void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
        this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @return The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
     *         attached to the ML compute instances that run the training job. The default is None.
     */

    public String getVolumeEncryptionKMSKey() {
        return this.volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @param volumeEncryptionKMSKey
     *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
     *        attached to the ML compute instances that run the training job. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
        setVolumeEncryptionKMSKey(volumeEncryptionKMSKey);
        return this;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     * 
     * @param s3OutputEncryptionKMSKey
     *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing
     *        job. The default is none.
     */

    public void setS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
        this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     * 
     * @return The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing
     *         job. The default is none.
     */

    public String getS3OutputEncryptionKMSKey() {
        return this.s3OutputEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     * 
     * @param s3OutputEncryptionKMSKey
     *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing
     *        job. The default is none.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
        setS3OutputEncryptionKMSKey(s3OutputEncryptionKMSKey);
        return this;
    }

    /**
     * <p>
     * Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot instances. The
     * default is <code>False</code>.
     * </p>
     * 
     * @param enableManagedSpotTraining
     *        Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot
     *        instances. The default is <code>False</code>.
     */

    public void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
        this.enableManagedSpotTraining = enableManagedSpotTraining;
    }

    /**
     * <p>
     * Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot instances. The
     * default is <code>False</code>.
     * </p>
     * 
     * @return Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot
     *         instances. The default is <code>False</code>.
     */

    public Boolean getEnableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    /**
     * <p>
     * Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot instances. The
     * default is <code>False</code>.
     * </p>
     * 
     * @param enableManagedSpotTraining
     *        Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot
     *        instances. The default is <code>False</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
        setEnableManagedSpotTraining(enableManagedSpotTraining);
        return this;
    }

    /**
     * <p>
     * Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot instances. The
     * default is <code>False</code>.
     * </p>
     * 
     * @return Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot
     *         instances. The default is <code>False</code>.
     */

    public Boolean isEnableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    /**
     * <p>
     * The configuration for custom model training. This is a JSON object.
     * </p>
     * 
     * @param customModelTrainingParameters
     *        The configuration for custom model training. This is a JSON object.
     */

    public void setCustomModelTrainingParameters(CustomModelTrainingParameters customModelTrainingParameters) {
        this.customModelTrainingParameters = customModelTrainingParameters;
    }

    /**
     * <p>
     * The configuration for custom model training. This is a JSON object.
     * </p>
     * 
     * @return The configuration for custom model training. This is a JSON object.
     */

    public CustomModelTrainingParameters getCustomModelTrainingParameters() {
        return this.customModelTrainingParameters;
    }

    /**
     * <p>
     * The configuration for custom model training. This is a JSON object.
     * </p>
     * 
     * @param customModelTrainingParameters
     *        The configuration for custom model training. This is a JSON object.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTrainingJobRequest withCustomModelTrainingParameters(CustomModelTrainingParameters customModelTrainingParameters) {
        setCustomModelTrainingParameters(customModelTrainingParameters);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getPreviousModelTrainingJobId() != null)
            sb.append("PreviousModelTrainingJobId: ").append(getPreviousModelTrainingJobId()).append(",");
        if (getDataProcessingJobId() != null)
            sb.append("DataProcessingJobId: ").append(getDataProcessingJobId()).append(",");
        if (getTrainModelS3Location() != null)
            sb.append("TrainModelS3Location: ").append(getTrainModelS3Location()).append(",");
        if (getSagemakerIamRoleArn() != null)
            sb.append("SagemakerIamRoleArn: ").append(getSagemakerIamRoleArn()).append(",");
        if (getNeptuneIamRoleArn() != null)
            sb.append("NeptuneIamRoleArn: ").append(getNeptuneIamRoleArn()).append(",");
        if (getBaseProcessingInstanceType() != null)
            sb.append("BaseProcessingInstanceType: ").append(getBaseProcessingInstanceType()).append(",");
        if (getTrainingInstanceType() != null)
            sb.append("TrainingInstanceType: ").append(getTrainingInstanceType()).append(",");
        if (getTrainingInstanceVolumeSizeInGB() != null)
            sb.append("TrainingInstanceVolumeSizeInGB: ").append(getTrainingInstanceVolumeSizeInGB()).append(",");
        if (getTrainingTimeOutInSeconds() != null)
            sb.append("TrainingTimeOutInSeconds: ").append(getTrainingTimeOutInSeconds()).append(",");
        if (getMaxHPONumberOfTrainingJobs() != null)
            sb.append("MaxHPONumberOfTrainingJobs: ").append(getMaxHPONumberOfTrainingJobs()).append(",");
        if (getMaxHPOParallelTrainingJobs() != null)
            sb.append("MaxHPOParallelTrainingJobs: ").append(getMaxHPOParallelTrainingJobs()).append(",");
        if (getSubnets() != null)
            sb.append("Subnets: ").append(getSubnets()).append(",");
        if (getSecurityGroupIds() != null)
            sb.append("SecurityGroupIds: ").append(getSecurityGroupIds()).append(",");
        if (getVolumeEncryptionKMSKey() != null)
            sb.append("VolumeEncryptionKMSKey: ").append(getVolumeEncryptionKMSKey()).append(",");
        if (getS3OutputEncryptionKMSKey() != null)
            sb.append("S3OutputEncryptionKMSKey: ").append(getS3OutputEncryptionKMSKey()).append(",");
        if (getEnableManagedSpotTraining() != null)
            sb.append("EnableManagedSpotTraining: ").append(getEnableManagedSpotTraining()).append(",");
        if (getCustomModelTrainingParameters() != null)
            sb.append("CustomModelTrainingParameters: ").append(getCustomModelTrainingParameters());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartMLModelTrainingJobRequest == false)
            return false;
        StartMLModelTrainingJobRequest other = (StartMLModelTrainingJobRequest) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getPreviousModelTrainingJobId() == null ^ this.getPreviousModelTrainingJobId() == null)
            return false;
        if (other.getPreviousModelTrainingJobId() != null && other.getPreviousModelTrainingJobId().equals(this.getPreviousModelTrainingJobId()) == false)
            return false;
        if (other.getDataProcessingJobId() == null ^ this.getDataProcessingJobId() == null)
            return false;
        if (other.getDataProcessingJobId() != null && other.getDataProcessingJobId().equals(this.getDataProcessingJobId()) == false)
            return false;
        if (other.getTrainModelS3Location() == null ^ this.getTrainModelS3Location() == null)
            return false;
        if (other.getTrainModelS3Location() != null && other.getTrainModelS3Location().equals(this.getTrainModelS3Location()) == false)
            return false;
        if (other.getSagemakerIamRoleArn() == null ^ this.getSagemakerIamRoleArn() == null)
            return false;
        if (other.getSagemakerIamRoleArn() != null && other.getSagemakerIamRoleArn().equals(this.getSagemakerIamRoleArn()) == false)
            return false;
        if (other.getNeptuneIamRoleArn() == null ^ this.getNeptuneIamRoleArn() == null)
            return false;
        if (other.getNeptuneIamRoleArn() != null && other.getNeptuneIamRoleArn().equals(this.getNeptuneIamRoleArn()) == false)
            return false;
        if (other.getBaseProcessingInstanceType() == null ^ this.getBaseProcessingInstanceType() == null)
            return false;
        if (other.getBaseProcessingInstanceType() != null && other.getBaseProcessingInstanceType().equals(this.getBaseProcessingInstanceType()) == false)
            return false;
        if (other.getTrainingInstanceType() == null ^ this.getTrainingInstanceType() == null)
            return false;
        if (other.getTrainingInstanceType() != null && other.getTrainingInstanceType().equals(this.getTrainingInstanceType()) == false)
            return false;
        if (other.getTrainingInstanceVolumeSizeInGB() == null ^ this.getTrainingInstanceVolumeSizeInGB() == null)
            return false;
        if (other.getTrainingInstanceVolumeSizeInGB() != null
                && other.getTrainingInstanceVolumeSizeInGB().equals(this.getTrainingInstanceVolumeSizeInGB()) == false)
            return false;
        if (other.getTrainingTimeOutInSeconds() == null ^ this.getTrainingTimeOutInSeconds() == null)
            return false;
        if (other.getTrainingTimeOutInSeconds() != null && other.getTrainingTimeOutInSeconds().equals(this.getTrainingTimeOutInSeconds()) == false)
            return false;
        if (other.getMaxHPONumberOfTrainingJobs() == null ^ this.getMaxHPONumberOfTrainingJobs() == null)
            return false;
        if (other.getMaxHPONumberOfTrainingJobs() != null && other.getMaxHPONumberOfTrainingJobs().equals(this.getMaxHPONumberOfTrainingJobs()) == false)
            return false;
        if (other.getMaxHPOParallelTrainingJobs() == null ^ this.getMaxHPOParallelTrainingJobs() == null)
            return false;
        if (other.getMaxHPOParallelTrainingJobs() != null && other.getMaxHPOParallelTrainingJobs().equals(this.getMaxHPOParallelTrainingJobs()) == false)
            return false;
        if (other.getSubnets() == null ^ this.getSubnets() == null)
            return false;
        if (other.getSubnets() != null && other.getSubnets().equals(this.getSubnets()) == false)
            return false;
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null)
            return false;
        if (other.getSecurityGroupIds() != null && other.getSecurityGroupIds().equals(this.getSecurityGroupIds()) == false)
            return false;
        if (other.getVolumeEncryptionKMSKey() == null ^ this.getVolumeEncryptionKMSKey() == null)
            return false;
        if (other.getVolumeEncryptionKMSKey() != null && other.getVolumeEncryptionKMSKey().equals(this.getVolumeEncryptionKMSKey()) == false)
            return false;
        if (other.getS3OutputEncryptionKMSKey() == null ^ this.getS3OutputEncryptionKMSKey() == null)
            return false;
        if (other.getS3OutputEncryptionKMSKey() != null && other.getS3OutputEncryptionKMSKey().equals(this.getS3OutputEncryptionKMSKey()) == false)
            return false;
        if (other.getEnableManagedSpotTraining() == null ^ this.getEnableManagedSpotTraining() == null)
            return false;
        if (other.getEnableManagedSpotTraining() != null && other.getEnableManagedSpotTraining().equals(this.getEnableManagedSpotTraining()) == false)
            return false;
        if (other.getCustomModelTrainingParameters() == null ^ this.getCustomModelTrainingParameters() == null)
            return false;
        if (other.getCustomModelTrainingParameters() != null
                && other.getCustomModelTrainingParameters().equals(this.getCustomModelTrainingParameters()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getPreviousModelTrainingJobId() == null) ? 0 : getPreviousModelTrainingJobId().hashCode());
        hashCode = prime * hashCode + ((getDataProcessingJobId() == null) ? 0 : getDataProcessingJobId().hashCode());
        hashCode = prime * hashCode + ((getTrainModelS3Location() == null) ? 0 : getTrainModelS3Location().hashCode());
        hashCode = prime * hashCode + ((getSagemakerIamRoleArn() == null) ? 0 : getSagemakerIamRoleArn().hashCode());
        hashCode = prime * hashCode + ((getNeptuneIamRoleArn() == null) ? 0 : getNeptuneIamRoleArn().hashCode());
        hashCode = prime * hashCode + ((getBaseProcessingInstanceType() == null) ? 0 : getBaseProcessingInstanceType().hashCode());
        hashCode = prime * hashCode + ((getTrainingInstanceType() == null) ? 0 : getTrainingInstanceType().hashCode());
        hashCode = prime * hashCode + ((getTrainingInstanceVolumeSizeInGB() == null) ? 0 : getTrainingInstanceVolumeSizeInGB().hashCode());
        hashCode = prime * hashCode + ((getTrainingTimeOutInSeconds() == null) ? 0 : getTrainingTimeOutInSeconds().hashCode());
        hashCode = prime * hashCode + ((getMaxHPONumberOfTrainingJobs() == null) ? 0 : getMaxHPONumberOfTrainingJobs().hashCode());
        hashCode = prime * hashCode + ((getMaxHPOParallelTrainingJobs() == null) ? 0 : getMaxHPOParallelTrainingJobs().hashCode());
        hashCode = prime * hashCode + ((getSubnets() == null) ? 0 : getSubnets().hashCode());
        hashCode = prime * hashCode + ((getSecurityGroupIds() == null) ? 0 : getSecurityGroupIds().hashCode());
        hashCode = prime * hashCode + ((getVolumeEncryptionKMSKey() == null) ? 0 : getVolumeEncryptionKMSKey().hashCode());
        hashCode = prime * hashCode + ((getS3OutputEncryptionKMSKey() == null) ? 0 : getS3OutputEncryptionKMSKey().hashCode());
        hashCode = prime * hashCode + ((getEnableManagedSpotTraining() == null) ? 0 : getEnableManagedSpotTraining().hashCode());
        hashCode = prime * hashCode + ((getCustomModelTrainingParameters() == null) ? 0 : getCustomModelTrainingParameters().hashCode());
        return hashCode;
    }

    @Override
    public StartMLModelTrainingJobRequest clone() {
        return (StartMLModelTrainingJobRequest) super.clone();
    }

    @Override
    public String getSignerType() {
        return "AWS4SignerType";
    }

}
