/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata;

import javax.annotation.Generated;

import com.amazonaws.services.neptunedata.model.*;

/**
 * Abstract implementation of {@code AmazonNeptunedataAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonNeptunedataAsync extends AbstractAmazonNeptunedata implements AmazonNeptunedataAsync {

    protected AbstractAmazonNeptunedataAsync() {
    }

    @Override
    public java.util.concurrent.Future<CancelGremlinQueryResult> cancelGremlinQueryAsync(CancelGremlinQueryRequest request) {

        return cancelGremlinQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CancelGremlinQueryResult> cancelGremlinQueryAsync(CancelGremlinQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<CancelGremlinQueryRequest, CancelGremlinQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CancelLoaderJobResult> cancelLoaderJobAsync(CancelLoaderJobRequest request) {

        return cancelLoaderJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CancelLoaderJobResult> cancelLoaderJobAsync(CancelLoaderJobRequest request,
            com.amazonaws.handlers.AsyncHandler<CancelLoaderJobRequest, CancelLoaderJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CancelMLDataProcessingJobResult> cancelMLDataProcessingJobAsync(CancelMLDataProcessingJobRequest request) {

        return cancelMLDataProcessingJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CancelMLDataProcessingJobResult> cancelMLDataProcessingJobAsync(CancelMLDataProcessingJobRequest request,
            com.amazonaws.handlers.AsyncHandler<CancelMLDataProcessingJobRequest, CancelMLDataProcessingJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CancelMLModelTrainingJobResult> cancelMLModelTrainingJobAsync(CancelMLModelTrainingJobRequest request) {

        return cancelMLModelTrainingJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CancelMLModelTrainingJobResult> cancelMLModelTrainingJobAsync(CancelMLModelTrainingJobRequest request,
            com.amazonaws.handlers.AsyncHandler<CancelMLModelTrainingJobRequest, CancelMLModelTrainingJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CancelMLModelTransformJobResult> cancelMLModelTransformJobAsync(CancelMLModelTransformJobRequest request) {

        return cancelMLModelTransformJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CancelMLModelTransformJobResult> cancelMLModelTransformJobAsync(CancelMLModelTransformJobRequest request,
            com.amazonaws.handlers.AsyncHandler<CancelMLModelTransformJobRequest, CancelMLModelTransformJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CancelOpenCypherQueryResult> cancelOpenCypherQueryAsync(CancelOpenCypherQueryRequest request) {

        return cancelOpenCypherQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CancelOpenCypherQueryResult> cancelOpenCypherQueryAsync(CancelOpenCypherQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<CancelOpenCypherQueryRequest, CancelOpenCypherQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateMLEndpointResult> createMLEndpointAsync(CreateMLEndpointRequest request) {

        return createMLEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateMLEndpointResult> createMLEndpointAsync(CreateMLEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateMLEndpointRequest, CreateMLEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteMLEndpointResult> deleteMLEndpointAsync(DeleteMLEndpointRequest request) {

        return deleteMLEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteMLEndpointResult> deleteMLEndpointAsync(DeleteMLEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteMLEndpointRequest, DeleteMLEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeletePropertygraphStatisticsResult> deletePropertygraphStatisticsAsync(DeletePropertygraphStatisticsRequest request) {

        return deletePropertygraphStatisticsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeletePropertygraphStatisticsResult> deletePropertygraphStatisticsAsync(DeletePropertygraphStatisticsRequest request,
            com.amazonaws.handlers.AsyncHandler<DeletePropertygraphStatisticsRequest, DeletePropertygraphStatisticsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSparqlStatisticsResult> deleteSparqlStatisticsAsync(DeleteSparqlStatisticsRequest request) {

        return deleteSparqlStatisticsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSparqlStatisticsResult> deleteSparqlStatisticsAsync(DeleteSparqlStatisticsRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSparqlStatisticsRequest, DeleteSparqlStatisticsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ExecuteFastResetResult> executeFastResetAsync(ExecuteFastResetRequest request) {

        return executeFastResetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ExecuteFastResetResult> executeFastResetAsync(ExecuteFastResetRequest request,
            com.amazonaws.handlers.AsyncHandler<ExecuteFastResetRequest, ExecuteFastResetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ExecuteGremlinExplainQueryResult> executeGremlinExplainQueryAsync(ExecuteGremlinExplainQueryRequest request) {

        return executeGremlinExplainQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ExecuteGremlinExplainQueryResult> executeGremlinExplainQueryAsync(ExecuteGremlinExplainQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<ExecuteGremlinExplainQueryRequest, ExecuteGremlinExplainQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ExecuteGremlinProfileQueryResult> executeGremlinProfileQueryAsync(ExecuteGremlinProfileQueryRequest request) {

        return executeGremlinProfileQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ExecuteGremlinProfileQueryResult> executeGremlinProfileQueryAsync(ExecuteGremlinProfileQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<ExecuteGremlinProfileQueryRequest, ExecuteGremlinProfileQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ExecuteGremlinQueryResult> executeGremlinQueryAsync(ExecuteGremlinQueryRequest request) {

        return executeGremlinQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ExecuteGremlinQueryResult> executeGremlinQueryAsync(ExecuteGremlinQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<ExecuteGremlinQueryRequest, ExecuteGremlinQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ExecuteOpenCypherExplainQueryResult> executeOpenCypherExplainQueryAsync(ExecuteOpenCypherExplainQueryRequest request) {

        return executeOpenCypherExplainQueryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ExecuteOpenCypherExplainQueryResult> executeOpenCypherExplainQueryAsync(ExecuteOpenCypherExplainQueryRequest request,
            com.amazonaws.handlers.AsyncHandler<ExecuteOpenCypherExplainQueryRequest, ExecuteOpenCypherExplainQueryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEngineStatusResult> getEngineStatusAsync(GetEngineStatusRequest request) {

        return getEngineStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEngineStatusResult> getEngineStatusAsync(GetEngineStatusRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEngineStatusRequest, GetEngineStatusResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGremlinQueryStatusResult> getGremlinQueryStatusAsync(GetGremlinQueryStatusRequest request) {

        return getGremlinQueryStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGremlinQueryStatusResult> getGremlinQueryStatusAsync(GetGremlinQueryStatusRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGremlinQueryStatusRequest, GetGremlinQueryStatusResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMLDataProcessingJobResult> getMLDataProcessingJobAsync(GetMLDataProcessingJobRequest request) {

        return getMLDataProcessingJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMLDataProcessingJobResult> getMLDataProcessingJobAsync(GetMLDataProcessingJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMLDataProcessingJobRequest, GetMLDataProcessingJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMLEndpointResult> getMLEndpointAsync(GetMLEndpointRequest request) {

        return getMLEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMLEndpointResult> getMLEndpointAsync(GetMLEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMLEndpointRequest, GetMLEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMLModelTrainingJobResult> getMLModelTrainingJobAsync(GetMLModelTrainingJobRequest request) {

        return getMLModelTrainingJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMLModelTrainingJobResult> getMLModelTrainingJobAsync(GetMLModelTrainingJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMLModelTrainingJobRequest, GetMLModelTrainingJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMLModelTransformJobResult> getMLModelTransformJobAsync(GetMLModelTransformJobRequest request) {

        return getMLModelTransformJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMLModelTransformJobResult> getMLModelTransformJobAsync(GetMLModelTransformJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMLModelTransformJobRequest, GetMLModelTransformJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetOpenCypherQueryStatusResult> getOpenCypherQueryStatusAsync(GetOpenCypherQueryStatusRequest request) {

        return getOpenCypherQueryStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetOpenCypherQueryStatusResult> getOpenCypherQueryStatusAsync(GetOpenCypherQueryStatusRequest request,
            com.amazonaws.handlers.AsyncHandler<GetOpenCypherQueryStatusRequest, GetOpenCypherQueryStatusResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPropertygraphStatisticsResult> getPropertygraphStatisticsAsync(GetPropertygraphStatisticsRequest request) {

        return getPropertygraphStatisticsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPropertygraphStatisticsResult> getPropertygraphStatisticsAsync(GetPropertygraphStatisticsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPropertygraphStatisticsRequest, GetPropertygraphStatisticsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPropertygraphSummaryResult> getPropertygraphSummaryAsync(GetPropertygraphSummaryRequest request) {

        return getPropertygraphSummaryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPropertygraphSummaryResult> getPropertygraphSummaryAsync(GetPropertygraphSummaryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPropertygraphSummaryRequest, GetPropertygraphSummaryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRDFGraphSummaryResult> getRDFGraphSummaryAsync(GetRDFGraphSummaryRequest request) {

        return getRDFGraphSummaryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRDFGraphSummaryResult> getRDFGraphSummaryAsync(GetRDFGraphSummaryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRDFGraphSummaryRequest, GetRDFGraphSummaryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSparqlStatisticsResult> getSparqlStatisticsAsync(GetSparqlStatisticsRequest request) {

        return getSparqlStatisticsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSparqlStatisticsResult> getSparqlStatisticsAsync(GetSparqlStatisticsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSparqlStatisticsRequest, GetSparqlStatisticsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSparqlStreamResult> getSparqlStreamAsync(GetSparqlStreamRequest request) {

        return getSparqlStreamAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSparqlStreamResult> getSparqlStreamAsync(GetSparqlStreamRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSparqlStreamRequest, GetSparqlStreamResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGremlinQueriesResult> listGremlinQueriesAsync(ListGremlinQueriesRequest request) {

        return listGremlinQueriesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGremlinQueriesResult> listGremlinQueriesAsync(ListGremlinQueriesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGremlinQueriesRequest, ListGremlinQueriesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListLoaderJobsResult> listLoaderJobsAsync(ListLoaderJobsRequest request) {

        return listLoaderJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListLoaderJobsResult> listLoaderJobsAsync(ListLoaderJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListLoaderJobsRequest, ListLoaderJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMLDataProcessingJobsResult> listMLDataProcessingJobsAsync(ListMLDataProcessingJobsRequest request) {

        return listMLDataProcessingJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMLDataProcessingJobsResult> listMLDataProcessingJobsAsync(ListMLDataProcessingJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMLDataProcessingJobsRequest, ListMLDataProcessingJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMLEndpointsResult> listMLEndpointsAsync(ListMLEndpointsRequest request) {

        return listMLEndpointsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMLEndpointsResult> listMLEndpointsAsync(ListMLEndpointsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMLEndpointsRequest, ListMLEndpointsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMLModelTrainingJobsResult> listMLModelTrainingJobsAsync(ListMLModelTrainingJobsRequest request) {

        return listMLModelTrainingJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMLModelTrainingJobsResult> listMLModelTrainingJobsAsync(ListMLModelTrainingJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMLModelTrainingJobsRequest, ListMLModelTrainingJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMLModelTransformJobsResult> listMLModelTransformJobsAsync(ListMLModelTransformJobsRequest request) {

        return listMLModelTransformJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMLModelTransformJobsResult> listMLModelTransformJobsAsync(ListMLModelTransformJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMLModelTransformJobsRequest, ListMLModelTransformJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListOpenCypherQueriesResult> listOpenCypherQueriesAsync(ListOpenCypherQueriesRequest request) {

        return listOpenCypherQueriesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListOpenCypherQueriesResult> listOpenCypherQueriesAsync(ListOpenCypherQueriesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListOpenCypherQueriesRequest, ListOpenCypherQueriesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ManagePropertygraphStatisticsResult> managePropertygraphStatisticsAsync(ManagePropertygraphStatisticsRequest request) {

        return managePropertygraphStatisticsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ManagePropertygraphStatisticsResult> managePropertygraphStatisticsAsync(ManagePropertygraphStatisticsRequest request,
            com.amazonaws.handlers.AsyncHandler<ManagePropertygraphStatisticsRequest, ManagePropertygraphStatisticsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ManageSparqlStatisticsResult> manageSparqlStatisticsAsync(ManageSparqlStatisticsRequest request) {

        return manageSparqlStatisticsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ManageSparqlStatisticsResult> manageSparqlStatisticsAsync(ManageSparqlStatisticsRequest request,
            com.amazonaws.handlers.AsyncHandler<ManageSparqlStatisticsRequest, ManageSparqlStatisticsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartLoaderJobResult> startLoaderJobAsync(StartLoaderJobRequest request) {

        return startLoaderJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartLoaderJobResult> startLoaderJobAsync(StartLoaderJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartLoaderJobRequest, StartLoaderJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartMLDataProcessingJobResult> startMLDataProcessingJobAsync(StartMLDataProcessingJobRequest request) {

        return startMLDataProcessingJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartMLDataProcessingJobResult> startMLDataProcessingJobAsync(StartMLDataProcessingJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartMLDataProcessingJobRequest, StartMLDataProcessingJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartMLModelTrainingJobResult> startMLModelTrainingJobAsync(StartMLModelTrainingJobRequest request) {

        return startMLModelTrainingJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartMLModelTrainingJobResult> startMLModelTrainingJobAsync(StartMLModelTrainingJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartMLModelTrainingJobRequest, StartMLModelTrainingJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartMLModelTransformJobResult> startMLModelTransformJobAsync(StartMLModelTransformJobRequest request) {

        return startMLModelTransformJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartMLModelTransformJobResult> startMLModelTransformJobAsync(StartMLModelTransformJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartMLModelTransformJobRequest, StartMLModelTransformJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
