/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.neptune.model.RestoreDBClusterFromSnapshotRequest;
import com.amazonaws.services.neptune.model.ServerlessV2ScalingConfiguration;
import com.amazonaws.services.neptune.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RestoreDBClusterFromSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDBClusterFromSnapshotRequest>, RestoreDBClusterFromSnapshotRequest> {
    public Request<RestoreDBClusterFromSnapshotRequest> marshall(RestoreDBClusterFromSnapshotRequest restoreDBClusterFromSnapshotRequest) {
        ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
        if (restoreDBClusterFromSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBClusterFromSnapshotRequest, "AmazonNeptune");
        request.addParameter("Action", "RestoreDBClusterFromSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBClusterFromSnapshotRequest.getAvailabilityZones() != null) {
            List<String> availabilityZonesList = restoreDBClusterFromSnapshotRequest.getAvailabilityZones();
            if (availabilityZonesList.isEmpty()) {
                request.addParameter("AvailabilityZones", "");
            } else {
                int availabilityZonesListIndex = 1;
                for (String availabilityZonesListValue : availabilityZonesList) {
                    if (availabilityZonesListValue != null) {
                        request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                    }
                    ++availabilityZonesListIndex;
                }
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getEngine()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getEngineVersion()));
        }
        if (restoreDBClusterFromSnapshotRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterFromSnapshotRequest.getPort()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDatabaseName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getOptionGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds() != null) {
            List<String> vpcSecurityGroupIdsList = restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds();
            if (vpcSecurityGroupIdsList.isEmpty()) {
                request.addParameter("VpcSecurityGroupIds", "");
            } else {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getTags() != null) {
            List<Tag> tagsList = restoreDBClusterFromSnapshotRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getKmsKeyId()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBClusterFromSnapshotRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports() != null) {
            List<String> enableCloudwatchLogsExportsList = restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports();
            if (enableCloudwatchLogsExportsList.isEmpty()) {
                request.addParameter("EnableCloudwatchLogsExports", "");
            } else {
                int enableCloudwatchLogsExportsListIndex = 1;
                for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                    if (enableCloudwatchLogsExportsListValue != null) {
                        request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString((String)enableCloudwatchLogsExportsListValue));
                    }
                    ++enableCloudwatchLogsExportsListIndex;
                }
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDBClusterParameterGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)restoreDBClusterFromSnapshotRequest.getDeletionProtection()));
        }
        if (restoreDBClusterFromSnapshotRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)restoreDBClusterFromSnapshotRequest.getCopyTagsToSnapshot()));
        }
        if ((serverlessV2ScalingConfiguration = restoreDBClusterFromSnapshotRequest.getServerlessV2ScalingConfiguration()) != null) {
            if (serverlessV2ScalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ServerlessV2ScalingConfiguration.MinCapacity", StringUtils.fromDouble((Double)serverlessV2ScalingConfiguration.getMinCapacity()));
            }
            if (serverlessV2ScalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ServerlessV2ScalingConfiguration.MaxCapacity", StringUtils.fromDouble((Double)serverlessV2ScalingConfiguration.getMaxCapacity()));
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getStorageType()));
        }
        return request;
    }
}

