/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.neptune.AmazonNeptuneAsync;
import com.amazonaws.services.neptune.AmazonNeptuneAsyncClientBuilder;
import com.amazonaws.services.neptune.AmazonNeptuneClient;
import com.amazonaws.services.neptune.model.AddRoleToDBClusterRequest;
import com.amazonaws.services.neptune.model.AddRoleToDBClusterResult;
import com.amazonaws.services.neptune.model.AddSourceIdentifierToSubscriptionRequest;
import com.amazonaws.services.neptune.model.AddTagsToResourceRequest;
import com.amazonaws.services.neptune.model.AddTagsToResourceResult;
import com.amazonaws.services.neptune.model.ApplyPendingMaintenanceActionRequest;
import com.amazonaws.services.neptune.model.CopyDBClusterParameterGroupRequest;
import com.amazonaws.services.neptune.model.CopyDBClusterSnapshotRequest;
import com.amazonaws.services.neptune.model.CopyDBParameterGroupRequest;
import com.amazonaws.services.neptune.model.CreateDBClusterParameterGroupRequest;
import com.amazonaws.services.neptune.model.CreateDBClusterRequest;
import com.amazonaws.services.neptune.model.CreateDBClusterSnapshotRequest;
import com.amazonaws.services.neptune.model.CreateDBInstanceRequest;
import com.amazonaws.services.neptune.model.CreateDBParameterGroupRequest;
import com.amazonaws.services.neptune.model.CreateDBSubnetGroupRequest;
import com.amazonaws.services.neptune.model.CreateEventSubscriptionRequest;
import com.amazonaws.services.neptune.model.DBCluster;
import com.amazonaws.services.neptune.model.DBClusterParameterGroup;
import com.amazonaws.services.neptune.model.DBClusterSnapshot;
import com.amazonaws.services.neptune.model.DBClusterSnapshotAttributesResult;
import com.amazonaws.services.neptune.model.DBInstance;
import com.amazonaws.services.neptune.model.DBParameterGroup;
import com.amazonaws.services.neptune.model.DBSubnetGroup;
import com.amazonaws.services.neptune.model.DeleteDBClusterParameterGroupRequest;
import com.amazonaws.services.neptune.model.DeleteDBClusterParameterGroupResult;
import com.amazonaws.services.neptune.model.DeleteDBClusterRequest;
import com.amazonaws.services.neptune.model.DeleteDBClusterSnapshotRequest;
import com.amazonaws.services.neptune.model.DeleteDBInstanceRequest;
import com.amazonaws.services.neptune.model.DeleteDBParameterGroupRequest;
import com.amazonaws.services.neptune.model.DeleteDBParameterGroupResult;
import com.amazonaws.services.neptune.model.DeleteDBSubnetGroupRequest;
import com.amazonaws.services.neptune.model.DeleteDBSubnetGroupResult;
import com.amazonaws.services.neptune.model.DeleteEventSubscriptionRequest;
import com.amazonaws.services.neptune.model.DescribeDBClusterParameterGroupsRequest;
import com.amazonaws.services.neptune.model.DescribeDBClusterParameterGroupsResult;
import com.amazonaws.services.neptune.model.DescribeDBClusterParametersRequest;
import com.amazonaws.services.neptune.model.DescribeDBClusterParametersResult;
import com.amazonaws.services.neptune.model.DescribeDBClusterSnapshotAttributesRequest;
import com.amazonaws.services.neptune.model.DescribeDBClusterSnapshotsRequest;
import com.amazonaws.services.neptune.model.DescribeDBClusterSnapshotsResult;
import com.amazonaws.services.neptune.model.DescribeDBClustersRequest;
import com.amazonaws.services.neptune.model.DescribeDBClustersResult;
import com.amazonaws.services.neptune.model.DescribeDBEngineVersionsRequest;
import com.amazonaws.services.neptune.model.DescribeDBEngineVersionsResult;
import com.amazonaws.services.neptune.model.DescribeDBInstancesRequest;
import com.amazonaws.services.neptune.model.DescribeDBInstancesResult;
import com.amazonaws.services.neptune.model.DescribeDBParameterGroupsRequest;
import com.amazonaws.services.neptune.model.DescribeDBParameterGroupsResult;
import com.amazonaws.services.neptune.model.DescribeDBParametersRequest;
import com.amazonaws.services.neptune.model.DescribeDBParametersResult;
import com.amazonaws.services.neptune.model.DescribeDBSubnetGroupsRequest;
import com.amazonaws.services.neptune.model.DescribeDBSubnetGroupsResult;
import com.amazonaws.services.neptune.model.DescribeEngineDefaultClusterParametersRequest;
import com.amazonaws.services.neptune.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.neptune.model.DescribeEventCategoriesRequest;
import com.amazonaws.services.neptune.model.DescribeEventCategoriesResult;
import com.amazonaws.services.neptune.model.DescribeEventSubscriptionsRequest;
import com.amazonaws.services.neptune.model.DescribeEventSubscriptionsResult;
import com.amazonaws.services.neptune.model.DescribeEventsRequest;
import com.amazonaws.services.neptune.model.DescribeEventsResult;
import com.amazonaws.services.neptune.model.DescribeOrderableDBInstanceOptionsRequest;
import com.amazonaws.services.neptune.model.DescribeOrderableDBInstanceOptionsResult;
import com.amazonaws.services.neptune.model.DescribePendingMaintenanceActionsRequest;
import com.amazonaws.services.neptune.model.DescribePendingMaintenanceActionsResult;
import com.amazonaws.services.neptune.model.DescribeValidDBInstanceModificationsRequest;
import com.amazonaws.services.neptune.model.EngineDefaults;
import com.amazonaws.services.neptune.model.EventSubscription;
import com.amazonaws.services.neptune.model.FailoverDBClusterRequest;
import com.amazonaws.services.neptune.model.ListTagsForResourceRequest;
import com.amazonaws.services.neptune.model.ListTagsForResourceResult;
import com.amazonaws.services.neptune.model.ModifyDBClusterParameterGroupRequest;
import com.amazonaws.services.neptune.model.ModifyDBClusterParameterGroupResult;
import com.amazonaws.services.neptune.model.ModifyDBClusterRequest;
import com.amazonaws.services.neptune.model.ModifyDBClusterSnapshotAttributeRequest;
import com.amazonaws.services.neptune.model.ModifyDBInstanceRequest;
import com.amazonaws.services.neptune.model.ModifyDBParameterGroupRequest;
import com.amazonaws.services.neptune.model.ModifyDBParameterGroupResult;
import com.amazonaws.services.neptune.model.ModifyDBSubnetGroupRequest;
import com.amazonaws.services.neptune.model.ModifyEventSubscriptionRequest;
import com.amazonaws.services.neptune.model.PromoteReadReplicaDBClusterRequest;
import com.amazonaws.services.neptune.model.RebootDBInstanceRequest;
import com.amazonaws.services.neptune.model.RemoveRoleFromDBClusterRequest;
import com.amazonaws.services.neptune.model.RemoveRoleFromDBClusterResult;
import com.amazonaws.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest;
import com.amazonaws.services.neptune.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.neptune.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.neptune.model.ResetDBClusterParameterGroupRequest;
import com.amazonaws.services.neptune.model.ResetDBClusterParameterGroupResult;
import com.amazonaws.services.neptune.model.ResetDBParameterGroupRequest;
import com.amazonaws.services.neptune.model.ResetDBParameterGroupResult;
import com.amazonaws.services.neptune.model.ResourcePendingMaintenanceActions;
import com.amazonaws.services.neptune.model.RestoreDBClusterFromSnapshotRequest;
import com.amazonaws.services.neptune.model.RestoreDBClusterToPointInTimeRequest;
import com.amazonaws.services.neptune.model.StartDBClusterRequest;
import com.amazonaws.services.neptune.model.StopDBClusterRequest;
import com.amazonaws.services.neptune.model.ValidDBInstanceModificationsMessage;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonNeptuneAsyncClient
extends AmazonNeptuneClient
implements AmazonNeptuneAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonNeptuneAsyncClientBuilder asyncBuilder() {
        return AmazonNeptuneAsyncClientBuilder.standard();
    }

    AmazonNeptuneAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonNeptuneAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddRoleToDBClusterResult> addRoleToDBClusterAsync(AddRoleToDBClusterRequest request) {
        return this.addRoleToDBClusterAsync(request, null);
    }

    @Override
    public Future<AddRoleToDBClusterResult> addRoleToDBClusterAsync(AddRoleToDBClusterRequest request, final AsyncHandler<AddRoleToDBClusterRequest, AddRoleToDBClusterResult> asyncHandler) {
        final AddRoleToDBClusterRequest finalRequest = (AddRoleToDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddRoleToDBClusterResult>(){

            @Override
            public AddRoleToDBClusterResult call() throws Exception {
                AddRoleToDBClusterResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeAddRoleToDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> addSourceIdentifierToSubscriptionAsync(AddSourceIdentifierToSubscriptionRequest request) {
        return this.addSourceIdentifierToSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> addSourceIdentifierToSubscriptionAsync(AddSourceIdentifierToSubscriptionRequest request, final AsyncHandler<AddSourceIdentifierToSubscriptionRequest, EventSubscription> asyncHandler) {
        final AddSourceIdentifierToSubscriptionRequest finalRequest = (AddSourceIdentifierToSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeAddSourceIdentifierToSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request) {
        return this.addTagsToResourceAsync(request, null);
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request, final AsyncHandler<AddTagsToResourceRequest, AddTagsToResourceResult> asyncHandler) {
        final AddTagsToResourceRequest finalRequest = (AddTagsToResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsToResourceResult>(){

            @Override
            public AddTagsToResourceResult call() throws Exception {
                AddTagsToResourceResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeAddTagsToResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResourcePendingMaintenanceActions> applyPendingMaintenanceActionAsync(ApplyPendingMaintenanceActionRequest request) {
        return this.applyPendingMaintenanceActionAsync(request, null);
    }

    @Override
    public Future<ResourcePendingMaintenanceActions> applyPendingMaintenanceActionAsync(ApplyPendingMaintenanceActionRequest request, final AsyncHandler<ApplyPendingMaintenanceActionRequest, ResourcePendingMaintenanceActions> asyncHandler) {
        final ApplyPendingMaintenanceActionRequest finalRequest = (ApplyPendingMaintenanceActionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResourcePendingMaintenanceActions>(){

            @Override
            public ResourcePendingMaintenanceActions call() throws Exception {
                ResourcePendingMaintenanceActions result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeApplyPendingMaintenanceAction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterParameterGroup> copyDBClusterParameterGroupAsync(CopyDBClusterParameterGroupRequest request) {
        return this.copyDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBClusterParameterGroup> copyDBClusterParameterGroupAsync(CopyDBClusterParameterGroupRequest request, final AsyncHandler<CopyDBClusterParameterGroupRequest, DBClusterParameterGroup> asyncHandler) {
        final CopyDBClusterParameterGroupRequest finalRequest = (CopyDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterParameterGroup>(){

            @Override
            public DBClusterParameterGroup call() throws Exception {
                DBClusterParameterGroup result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCopyDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshot> copyDBClusterSnapshotAsync(CopyDBClusterSnapshotRequest request) {
        return this.copyDBClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshot> copyDBClusterSnapshotAsync(CopyDBClusterSnapshotRequest request, final AsyncHandler<CopyDBClusterSnapshotRequest, DBClusterSnapshot> asyncHandler) {
        final CopyDBClusterSnapshotRequest finalRequest = (CopyDBClusterSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshot>(){

            @Override
            public DBClusterSnapshot call() throws Exception {
                DBClusterSnapshot result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCopyDBClusterSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBParameterGroup> copyDBParameterGroupAsync(CopyDBParameterGroupRequest request) {
        return this.copyDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBParameterGroup> copyDBParameterGroupAsync(CopyDBParameterGroupRequest request, final AsyncHandler<CopyDBParameterGroupRequest, DBParameterGroup> asyncHandler) {
        final CopyDBParameterGroupRequest finalRequest = (CopyDBParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBParameterGroup>(){

            @Override
            public DBParameterGroup call() throws Exception {
                DBParameterGroup result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCopyDBParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> createDBClusterAsync(CreateDBClusterRequest request) {
        return this.createDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> createDBClusterAsync(CreateDBClusterRequest request, final AsyncHandler<CreateDBClusterRequest, DBCluster> asyncHandler) {
        final CreateDBClusterRequest finalRequest = (CreateDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCreateDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterParameterGroup> createDBClusterParameterGroupAsync(CreateDBClusterParameterGroupRequest request) {
        return this.createDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBClusterParameterGroup> createDBClusterParameterGroupAsync(CreateDBClusterParameterGroupRequest request, final AsyncHandler<CreateDBClusterParameterGroupRequest, DBClusterParameterGroup> asyncHandler) {
        final CreateDBClusterParameterGroupRequest finalRequest = (CreateDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterParameterGroup>(){

            @Override
            public DBClusterParameterGroup call() throws Exception {
                DBClusterParameterGroup result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCreateDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshot> createDBClusterSnapshotAsync(CreateDBClusterSnapshotRequest request) {
        return this.createDBClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshot> createDBClusterSnapshotAsync(CreateDBClusterSnapshotRequest request, final AsyncHandler<CreateDBClusterSnapshotRequest, DBClusterSnapshot> asyncHandler) {
        final CreateDBClusterSnapshotRequest finalRequest = (CreateDBClusterSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshot>(){

            @Override
            public DBClusterSnapshot call() throws Exception {
                DBClusterSnapshot result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCreateDBClusterSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> createDBInstanceAsync(CreateDBInstanceRequest request) {
        return this.createDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> createDBInstanceAsync(CreateDBInstanceRequest request, final AsyncHandler<CreateDBInstanceRequest, DBInstance> asyncHandler) {
        final CreateDBInstanceRequest finalRequest = (CreateDBInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCreateDBInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBParameterGroup> createDBParameterGroupAsync(CreateDBParameterGroupRequest request) {
        return this.createDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBParameterGroup> createDBParameterGroupAsync(CreateDBParameterGroupRequest request, final AsyncHandler<CreateDBParameterGroupRequest, DBParameterGroup> asyncHandler) {
        final CreateDBParameterGroupRequest finalRequest = (CreateDBParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBParameterGroup>(){

            @Override
            public DBParameterGroup call() throws Exception {
                DBParameterGroup result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCreateDBParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> createDBSubnetGroupAsync(CreateDBSubnetGroupRequest request) {
        return this.createDBSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DBSubnetGroup> createDBSubnetGroupAsync(CreateDBSubnetGroupRequest request, final AsyncHandler<CreateDBSubnetGroupRequest, DBSubnetGroup> asyncHandler) {
        final CreateDBSubnetGroupRequest finalRequest = (CreateDBSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                DBSubnetGroup result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCreateDBSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(CreateEventSubscriptionRequest request) {
        return this.createEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(CreateEventSubscriptionRequest request, final AsyncHandler<CreateEventSubscriptionRequest, EventSubscription> asyncHandler) {
        final CreateEventSubscriptionRequest finalRequest = (CreateEventSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeCreateEventSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> deleteDBClusterAsync(DeleteDBClusterRequest request) {
        return this.deleteDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> deleteDBClusterAsync(DeleteDBClusterRequest request, final AsyncHandler<DeleteDBClusterRequest, DBCluster> asyncHandler) {
        final DeleteDBClusterRequest finalRequest = (DeleteDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDeleteDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDBClusterParameterGroupResult> deleteDBClusterParameterGroupAsync(DeleteDBClusterParameterGroupRequest request) {
        return this.deleteDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDBClusterParameterGroupResult> deleteDBClusterParameterGroupAsync(DeleteDBClusterParameterGroupRequest request, final AsyncHandler<DeleteDBClusterParameterGroupRequest, DeleteDBClusterParameterGroupResult> asyncHandler) {
        final DeleteDBClusterParameterGroupRequest finalRequest = (DeleteDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDBClusterParameterGroupResult>(){

            @Override
            public DeleteDBClusterParameterGroupResult call() throws Exception {
                DeleteDBClusterParameterGroupResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDeleteDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshot> deleteDBClusterSnapshotAsync(DeleteDBClusterSnapshotRequest request) {
        return this.deleteDBClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshot> deleteDBClusterSnapshotAsync(DeleteDBClusterSnapshotRequest request, final AsyncHandler<DeleteDBClusterSnapshotRequest, DBClusterSnapshot> asyncHandler) {
        final DeleteDBClusterSnapshotRequest finalRequest = (DeleteDBClusterSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshot>(){

            @Override
            public DBClusterSnapshot call() throws Exception {
                DBClusterSnapshot result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDeleteDBClusterSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> deleteDBInstanceAsync(DeleteDBInstanceRequest request) {
        return this.deleteDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> deleteDBInstanceAsync(DeleteDBInstanceRequest request, final AsyncHandler<DeleteDBInstanceRequest, DBInstance> asyncHandler) {
        final DeleteDBInstanceRequest finalRequest = (DeleteDBInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDeleteDBInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDBParameterGroupResult> deleteDBParameterGroupAsync(DeleteDBParameterGroupRequest request) {
        return this.deleteDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDBParameterGroupResult> deleteDBParameterGroupAsync(DeleteDBParameterGroupRequest request, final AsyncHandler<DeleteDBParameterGroupRequest, DeleteDBParameterGroupResult> asyncHandler) {
        final DeleteDBParameterGroupRequest finalRequest = (DeleteDBParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDBParameterGroupResult>(){

            @Override
            public DeleteDBParameterGroupResult call() throws Exception {
                DeleteDBParameterGroupResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDeleteDBParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDBSubnetGroupResult> deleteDBSubnetGroupAsync(DeleteDBSubnetGroupRequest request) {
        return this.deleteDBSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDBSubnetGroupResult> deleteDBSubnetGroupAsync(DeleteDBSubnetGroupRequest request, final AsyncHandler<DeleteDBSubnetGroupRequest, DeleteDBSubnetGroupResult> asyncHandler) {
        final DeleteDBSubnetGroupRequest finalRequest = (DeleteDBSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDBSubnetGroupResult>(){

            @Override
            public DeleteDBSubnetGroupResult call() throws Exception {
                DeleteDBSubnetGroupResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDeleteDBSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> deleteEventSubscriptionAsync(DeleteEventSubscriptionRequest request) {
        return this.deleteEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> deleteEventSubscriptionAsync(DeleteEventSubscriptionRequest request, final AsyncHandler<DeleteEventSubscriptionRequest, EventSubscription> asyncHandler) {
        final DeleteEventSubscriptionRequest finalRequest = (DeleteEventSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDeleteEventSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClusterParameterGroupsResult> describeDBClusterParameterGroupsAsync(DescribeDBClusterParameterGroupsRequest request) {
        return this.describeDBClusterParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeDBClusterParameterGroupsResult> describeDBClusterParameterGroupsAsync(DescribeDBClusterParameterGroupsRequest request, final AsyncHandler<DescribeDBClusterParameterGroupsRequest, DescribeDBClusterParameterGroupsResult> asyncHandler) {
        final DescribeDBClusterParameterGroupsRequest finalRequest = (DescribeDBClusterParameterGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBClusterParameterGroupsResult>(){

            @Override
            public DescribeDBClusterParameterGroupsResult call() throws Exception {
                DescribeDBClusterParameterGroupsResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBClusterParameterGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClusterParametersResult> describeDBClusterParametersAsync(DescribeDBClusterParametersRequest request) {
        return this.describeDBClusterParametersAsync(request, null);
    }

    @Override
    public Future<DescribeDBClusterParametersResult> describeDBClusterParametersAsync(DescribeDBClusterParametersRequest request, final AsyncHandler<DescribeDBClusterParametersRequest, DescribeDBClusterParametersResult> asyncHandler) {
        final DescribeDBClusterParametersRequest finalRequest = (DescribeDBClusterParametersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBClusterParametersResult>(){

            @Override
            public DescribeDBClusterParametersResult call() throws Exception {
                DescribeDBClusterParametersResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBClusterParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> describeDBClusterSnapshotAttributesAsync(DescribeDBClusterSnapshotAttributesRequest request) {
        return this.describeDBClusterSnapshotAttributesAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> describeDBClusterSnapshotAttributesAsync(DescribeDBClusterSnapshotAttributesRequest request, final AsyncHandler<DescribeDBClusterSnapshotAttributesRequest, DBClusterSnapshotAttributesResult> asyncHandler) {
        final DescribeDBClusterSnapshotAttributesRequest finalRequest = (DescribeDBClusterSnapshotAttributesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshotAttributesResult>(){

            @Override
            public DBClusterSnapshotAttributesResult call() throws Exception {
                DBClusterSnapshotAttributesResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBClusterSnapshotAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClusterSnapshotsResult> describeDBClusterSnapshotsAsync(DescribeDBClusterSnapshotsRequest request) {
        return this.describeDBClusterSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeDBClusterSnapshotsResult> describeDBClusterSnapshotsAsync(DescribeDBClusterSnapshotsRequest request, final AsyncHandler<DescribeDBClusterSnapshotsRequest, DescribeDBClusterSnapshotsResult> asyncHandler) {
        final DescribeDBClusterSnapshotsRequest finalRequest = (DescribeDBClusterSnapshotsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBClusterSnapshotsResult>(){

            @Override
            public DescribeDBClusterSnapshotsResult call() throws Exception {
                DescribeDBClusterSnapshotsResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBClusterSnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClustersResult> describeDBClustersAsync(DescribeDBClustersRequest request) {
        return this.describeDBClustersAsync(request, null);
    }

    @Override
    public Future<DescribeDBClustersResult> describeDBClustersAsync(DescribeDBClustersRequest request, final AsyncHandler<DescribeDBClustersRequest, DescribeDBClustersResult> asyncHandler) {
        final DescribeDBClustersRequest finalRequest = (DescribeDBClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBClustersResult>(){

            @Override
            public DescribeDBClustersResult call() throws Exception {
                DescribeDBClustersResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(DescribeDBEngineVersionsRequest request) {
        return this.describeDBEngineVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(DescribeDBEngineVersionsRequest request, final AsyncHandler<DescribeDBEngineVersionsRequest, DescribeDBEngineVersionsResult> asyncHandler) {
        final DescribeDBEngineVersionsRequest finalRequest = (DescribeDBEngineVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBEngineVersionsResult>(){

            @Override
            public DescribeDBEngineVersionsResult call() throws Exception {
                DescribeDBEngineVersionsResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBEngineVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(DescribeDBInstancesRequest request) {
        return this.describeDBInstancesAsync(request, null);
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(DescribeDBInstancesRequest request, final AsyncHandler<DescribeDBInstancesRequest, DescribeDBInstancesResult> asyncHandler) {
        final DescribeDBInstancesRequest finalRequest = (DescribeDBInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBInstancesResult>(){

            @Override
            public DescribeDBInstancesResult call() throws Exception {
                DescribeDBInstancesResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBParameterGroupsResult> describeDBParameterGroupsAsync(DescribeDBParameterGroupsRequest request) {
        return this.describeDBParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeDBParameterGroupsResult> describeDBParameterGroupsAsync(DescribeDBParameterGroupsRequest request, final AsyncHandler<DescribeDBParameterGroupsRequest, DescribeDBParameterGroupsResult> asyncHandler) {
        final DescribeDBParameterGroupsRequest finalRequest = (DescribeDBParameterGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBParameterGroupsResult>(){

            @Override
            public DescribeDBParameterGroupsResult call() throws Exception {
                DescribeDBParameterGroupsResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBParameterGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBParametersResult> describeDBParametersAsync(DescribeDBParametersRequest request) {
        return this.describeDBParametersAsync(request, null);
    }

    @Override
    public Future<DescribeDBParametersResult> describeDBParametersAsync(DescribeDBParametersRequest request, final AsyncHandler<DescribeDBParametersRequest, DescribeDBParametersResult> asyncHandler) {
        final DescribeDBParametersRequest finalRequest = (DescribeDBParametersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBParametersResult>(){

            @Override
            public DescribeDBParametersResult call() throws Exception {
                DescribeDBParametersResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(DescribeDBSubnetGroupsRequest request) {
        return this.describeDBSubnetGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(DescribeDBSubnetGroupsRequest request, final AsyncHandler<DescribeDBSubnetGroupsRequest, DescribeDBSubnetGroupsResult> asyncHandler) {
        final DescribeDBSubnetGroupsRequest finalRequest = (DescribeDBSubnetGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBSubnetGroupsResult>(){

            @Override
            public DescribeDBSubnetGroupsResult call() throws Exception {
                DescribeDBSubnetGroupsResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeDBSubnetGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultClusterParametersAsync(DescribeEngineDefaultClusterParametersRequest request) {
        return this.describeEngineDefaultClusterParametersAsync(request, null);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultClusterParametersAsync(DescribeEngineDefaultClusterParametersRequest request, final AsyncHandler<DescribeEngineDefaultClusterParametersRequest, EngineDefaults> asyncHandler) {
        final DescribeEngineDefaultClusterParametersRequest finalRequest = (DescribeEngineDefaultClusterParametersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeEngineDefaultClusterParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(DescribeEngineDefaultParametersRequest request) {
        return this.describeEngineDefaultParametersAsync(request, null);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(DescribeEngineDefaultParametersRequest request, final AsyncHandler<DescribeEngineDefaultParametersRequest, EngineDefaults> asyncHandler) {
        final DescribeEngineDefaultParametersRequest finalRequest = (DescribeEngineDefaultParametersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeEngineDefaultParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(DescribeEventCategoriesRequest request) {
        return this.describeEventCategoriesAsync(request, null);
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(DescribeEventCategoriesRequest request, final AsyncHandler<DescribeEventCategoriesRequest, DescribeEventCategoriesResult> asyncHandler) {
        final DescribeEventCategoriesRequest finalRequest = (DescribeEventCategoriesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventCategoriesResult>(){

            @Override
            public DescribeEventCategoriesResult call() throws Exception {
                DescribeEventCategoriesResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeEventCategories(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(DescribeEventSubscriptionsRequest request) {
        return this.describeEventSubscriptionsAsync(request, null);
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(DescribeEventSubscriptionsRequest request, final AsyncHandler<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResult> asyncHandler) {
        final DescribeEventSubscriptionsRequest finalRequest = (DescribeEventSubscriptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventSubscriptionsResult>(){

            @Override
            public DescribeEventSubscriptionsResult call() throws Exception {
                DescribeEventSubscriptionsResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeEventSubscriptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        final DescribeEventsRequest finalRequest = (DescribeEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrderableDBInstanceOptionsResult> describeOrderableDBInstanceOptionsAsync(DescribeOrderableDBInstanceOptionsRequest request) {
        return this.describeOrderableDBInstanceOptionsAsync(request, null);
    }

    @Override
    public Future<DescribeOrderableDBInstanceOptionsResult> describeOrderableDBInstanceOptionsAsync(DescribeOrderableDBInstanceOptionsRequest request, final AsyncHandler<DescribeOrderableDBInstanceOptionsRequest, DescribeOrderableDBInstanceOptionsResult> asyncHandler) {
        final DescribeOrderableDBInstanceOptionsRequest finalRequest = (DescribeOrderableDBInstanceOptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOrderableDBInstanceOptionsResult>(){

            @Override
            public DescribeOrderableDBInstanceOptionsResult call() throws Exception {
                DescribeOrderableDBInstanceOptionsResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeOrderableDBInstanceOptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync(DescribePendingMaintenanceActionsRequest request) {
        return this.describePendingMaintenanceActionsAsync(request, null);
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync(DescribePendingMaintenanceActionsRequest request, final AsyncHandler<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResult> asyncHandler) {
        final DescribePendingMaintenanceActionsRequest finalRequest = (DescribePendingMaintenanceActionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePendingMaintenanceActionsResult>(){

            @Override
            public DescribePendingMaintenanceActionsResult call() throws Exception {
                DescribePendingMaintenanceActionsResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribePendingMaintenanceActions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ValidDBInstanceModificationsMessage> describeValidDBInstanceModificationsAsync(DescribeValidDBInstanceModificationsRequest request) {
        return this.describeValidDBInstanceModificationsAsync(request, null);
    }

    @Override
    public Future<ValidDBInstanceModificationsMessage> describeValidDBInstanceModificationsAsync(DescribeValidDBInstanceModificationsRequest request, final AsyncHandler<DescribeValidDBInstanceModificationsRequest, ValidDBInstanceModificationsMessage> asyncHandler) {
        final DescribeValidDBInstanceModificationsRequest finalRequest = (DescribeValidDBInstanceModificationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ValidDBInstanceModificationsMessage>(){

            @Override
            public ValidDBInstanceModificationsMessage call() throws Exception {
                ValidDBInstanceModificationsMessage result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeDescribeValidDBInstanceModifications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> failoverDBClusterAsync(FailoverDBClusterRequest request) {
        return this.failoverDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> failoverDBClusterAsync(FailoverDBClusterRequest request, final AsyncHandler<FailoverDBClusterRequest, DBCluster> asyncHandler) {
        final FailoverDBClusterRequest finalRequest = (FailoverDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeFailoverDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> modifyDBClusterAsync(ModifyDBClusterRequest request) {
        return this.modifyDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> modifyDBClusterAsync(ModifyDBClusterRequest request, final AsyncHandler<ModifyDBClusterRequest, DBCluster> asyncHandler) {
        final ModifyDBClusterRequest finalRequest = (ModifyDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeModifyDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyDBClusterParameterGroupResult> modifyDBClusterParameterGroupAsync(ModifyDBClusterParameterGroupRequest request) {
        return this.modifyDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<ModifyDBClusterParameterGroupResult> modifyDBClusterParameterGroupAsync(ModifyDBClusterParameterGroupRequest request, final AsyncHandler<ModifyDBClusterParameterGroupRequest, ModifyDBClusterParameterGroupResult> asyncHandler) {
        final ModifyDBClusterParameterGroupRequest finalRequest = (ModifyDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ModifyDBClusterParameterGroupResult>(){

            @Override
            public ModifyDBClusterParameterGroupResult call() throws Exception {
                ModifyDBClusterParameterGroupResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeModifyDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> modifyDBClusterSnapshotAttributeAsync(ModifyDBClusterSnapshotAttributeRequest request) {
        return this.modifyDBClusterSnapshotAttributeAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> modifyDBClusterSnapshotAttributeAsync(ModifyDBClusterSnapshotAttributeRequest request, final AsyncHandler<ModifyDBClusterSnapshotAttributeRequest, DBClusterSnapshotAttributesResult> asyncHandler) {
        final ModifyDBClusterSnapshotAttributeRequest finalRequest = (ModifyDBClusterSnapshotAttributeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshotAttributesResult>(){

            @Override
            public DBClusterSnapshotAttributesResult call() throws Exception {
                DBClusterSnapshotAttributesResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeModifyDBClusterSnapshotAttribute(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> modifyDBInstanceAsync(ModifyDBInstanceRequest request) {
        return this.modifyDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> modifyDBInstanceAsync(ModifyDBInstanceRequest request, final AsyncHandler<ModifyDBInstanceRequest, DBInstance> asyncHandler) {
        final ModifyDBInstanceRequest finalRequest = (ModifyDBInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeModifyDBInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyDBParameterGroupResult> modifyDBParameterGroupAsync(ModifyDBParameterGroupRequest request) {
        return this.modifyDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<ModifyDBParameterGroupResult> modifyDBParameterGroupAsync(ModifyDBParameterGroupRequest request, final AsyncHandler<ModifyDBParameterGroupRequest, ModifyDBParameterGroupResult> asyncHandler) {
        final ModifyDBParameterGroupRequest finalRequest = (ModifyDBParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ModifyDBParameterGroupResult>(){

            @Override
            public ModifyDBParameterGroupResult call() throws Exception {
                ModifyDBParameterGroupResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeModifyDBParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> modifyDBSubnetGroupAsync(ModifyDBSubnetGroupRequest request) {
        return this.modifyDBSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DBSubnetGroup> modifyDBSubnetGroupAsync(ModifyDBSubnetGroupRequest request, final AsyncHandler<ModifyDBSubnetGroupRequest, DBSubnetGroup> asyncHandler) {
        final ModifyDBSubnetGroupRequest finalRequest = (ModifyDBSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                DBSubnetGroup result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeModifyDBSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(ModifyEventSubscriptionRequest request) {
        return this.modifyEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(ModifyEventSubscriptionRequest request, final AsyncHandler<ModifyEventSubscriptionRequest, EventSubscription> asyncHandler) {
        final ModifyEventSubscriptionRequest finalRequest = (ModifyEventSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeModifyEventSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> promoteReadReplicaDBClusterAsync(PromoteReadReplicaDBClusterRequest request) {
        return this.promoteReadReplicaDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> promoteReadReplicaDBClusterAsync(PromoteReadReplicaDBClusterRequest request, final AsyncHandler<PromoteReadReplicaDBClusterRequest, DBCluster> asyncHandler) {
        final PromoteReadReplicaDBClusterRequest finalRequest = (PromoteReadReplicaDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executePromoteReadReplicaDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> rebootDBInstanceAsync(RebootDBInstanceRequest request) {
        return this.rebootDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> rebootDBInstanceAsync(RebootDBInstanceRequest request, final AsyncHandler<RebootDBInstanceRequest, DBInstance> asyncHandler) {
        final RebootDBInstanceRequest finalRequest = (RebootDBInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeRebootDBInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveRoleFromDBClusterResult> removeRoleFromDBClusterAsync(RemoveRoleFromDBClusterRequest request) {
        return this.removeRoleFromDBClusterAsync(request, null);
    }

    @Override
    public Future<RemoveRoleFromDBClusterResult> removeRoleFromDBClusterAsync(RemoveRoleFromDBClusterRequest request, final AsyncHandler<RemoveRoleFromDBClusterRequest, RemoveRoleFromDBClusterResult> asyncHandler) {
        final RemoveRoleFromDBClusterRequest finalRequest = (RemoveRoleFromDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveRoleFromDBClusterResult>(){

            @Override
            public RemoveRoleFromDBClusterResult call() throws Exception {
                RemoveRoleFromDBClusterResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeRemoveRoleFromDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> removeSourceIdentifierFromSubscriptionAsync(RemoveSourceIdentifierFromSubscriptionRequest request) {
        return this.removeSourceIdentifierFromSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> removeSourceIdentifierFromSubscriptionAsync(RemoveSourceIdentifierFromSubscriptionRequest request, final AsyncHandler<RemoveSourceIdentifierFromSubscriptionRequest, EventSubscription> asyncHandler) {
        final RemoveSourceIdentifierFromSubscriptionRequest finalRequest = (RemoveSourceIdentifierFromSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeRemoveSourceIdentifierFromSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request) {
        return this.removeTagsFromResourceAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request, final AsyncHandler<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResult> asyncHandler) {
        final RemoveTagsFromResourceRequest finalRequest = (RemoveTagsFromResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTagsFromResourceResult>(){

            @Override
            public RemoveTagsFromResourceResult call() throws Exception {
                RemoveTagsFromResourceResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeRemoveTagsFromResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetDBClusterParameterGroupResult> resetDBClusterParameterGroupAsync(ResetDBClusterParameterGroupRequest request) {
        return this.resetDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<ResetDBClusterParameterGroupResult> resetDBClusterParameterGroupAsync(ResetDBClusterParameterGroupRequest request, final AsyncHandler<ResetDBClusterParameterGroupRequest, ResetDBClusterParameterGroupResult> asyncHandler) {
        final ResetDBClusterParameterGroupRequest finalRequest = (ResetDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResetDBClusterParameterGroupResult>(){

            @Override
            public ResetDBClusterParameterGroupResult call() throws Exception {
                ResetDBClusterParameterGroupResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeResetDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetDBParameterGroupResult> resetDBParameterGroupAsync(ResetDBParameterGroupRequest request) {
        return this.resetDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<ResetDBParameterGroupResult> resetDBParameterGroupAsync(ResetDBParameterGroupRequest request, final AsyncHandler<ResetDBParameterGroupRequest, ResetDBParameterGroupResult> asyncHandler) {
        final ResetDBParameterGroupRequest finalRequest = (ResetDBParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResetDBParameterGroupResult>(){

            @Override
            public ResetDBParameterGroupResult call() throws Exception {
                ResetDBParameterGroupResult result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeResetDBParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> restoreDBClusterFromSnapshotAsync(RestoreDBClusterFromSnapshotRequest request) {
        return this.restoreDBClusterFromSnapshotAsync(request, null);
    }

    @Override
    public Future<DBCluster> restoreDBClusterFromSnapshotAsync(RestoreDBClusterFromSnapshotRequest request, final AsyncHandler<RestoreDBClusterFromSnapshotRequest, DBCluster> asyncHandler) {
        final RestoreDBClusterFromSnapshotRequest finalRequest = (RestoreDBClusterFromSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeRestoreDBClusterFromSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> restoreDBClusterToPointInTimeAsync(RestoreDBClusterToPointInTimeRequest request) {
        return this.restoreDBClusterToPointInTimeAsync(request, null);
    }

    @Override
    public Future<DBCluster> restoreDBClusterToPointInTimeAsync(RestoreDBClusterToPointInTimeRequest request, final AsyncHandler<RestoreDBClusterToPointInTimeRequest, DBCluster> asyncHandler) {
        final RestoreDBClusterToPointInTimeRequest finalRequest = (RestoreDBClusterToPointInTimeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeRestoreDBClusterToPointInTime(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> startDBClusterAsync(StartDBClusterRequest request) {
        return this.startDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> startDBClusterAsync(StartDBClusterRequest request, final AsyncHandler<StartDBClusterRequest, DBCluster> asyncHandler) {
        final StartDBClusterRequest finalRequest = (StartDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeStartDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> stopDBClusterAsync(StopDBClusterRequest request) {
        return this.stopDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> stopDBClusterAsync(StopDBClusterRequest request, final AsyncHandler<StopDBClusterRequest, DBCluster> asyncHandler) {
        final StopDBClusterRequest finalRequest = (StopDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonNeptuneAsyncClient.this.executeStopDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

