/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mq.model.AvailabilityZone;
import com.amazonaws.services.mq.model.EngineType;
import com.amazonaws.services.mq.model.transform.BrokerInstanceOptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BrokerInstanceOption
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AvailabilityZone> availabilityZones;
    private String engineType;
    private String hostInstanceType;
    private List<String> supportedEngineVersions;

    public List<AvailabilityZone> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new ArrayList<AvailabilityZone>(availabilityZones);
    }

    public BrokerInstanceOption withAvailabilityZones(AvailabilityZone ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new ArrayList<AvailabilityZone>(availabilityZones.length));
        }
        for (AvailabilityZone ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public BrokerInstanceOption withAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public BrokerInstanceOption withEngineType(String engineType) {
        this.setEngineType(engineType);
        return this;
    }

    public BrokerInstanceOption withEngineType(EngineType engineType) {
        this.engineType = engineType.toString();
        return this;
    }

    public void setHostInstanceType(String hostInstanceType) {
        this.hostInstanceType = hostInstanceType;
    }

    public String getHostInstanceType() {
        return this.hostInstanceType;
    }

    public BrokerInstanceOption withHostInstanceType(String hostInstanceType) {
        this.setHostInstanceType(hostInstanceType);
        return this;
    }

    public List<String> getSupportedEngineVersions() {
        return this.supportedEngineVersions;
    }

    public void setSupportedEngineVersions(Collection<String> supportedEngineVersions) {
        if (supportedEngineVersions == null) {
            this.supportedEngineVersions = null;
            return;
        }
        this.supportedEngineVersions = new ArrayList<String>(supportedEngineVersions);
    }

    public BrokerInstanceOption withSupportedEngineVersions(String ... supportedEngineVersions) {
        if (this.supportedEngineVersions == null) {
            this.setSupportedEngineVersions(new ArrayList<String>(supportedEngineVersions.length));
        }
        for (String ele : supportedEngineVersions) {
            this.supportedEngineVersions.add(ele);
        }
        return this;
    }

    public BrokerInstanceOption withSupportedEngineVersions(Collection<String> supportedEngineVersions) {
        this.setSupportedEngineVersions(supportedEngineVersions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getEngineType() != null) {
            sb.append("EngineType: ").append(this.getEngineType()).append(",");
        }
        if (this.getHostInstanceType() != null) {
            sb.append("HostInstanceType: ").append(this.getHostInstanceType()).append(",");
        }
        if (this.getSupportedEngineVersions() != null) {
            sb.append("SupportedEngineVersions: ").append(this.getSupportedEngineVersions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerInstanceOption)) {
            return false;
        }
        BrokerInstanceOption other = (BrokerInstanceOption)obj;
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getEngineType() == null ^ this.getEngineType() == null) {
            return false;
        }
        if (other.getEngineType() != null && !other.getEngineType().equals(this.getEngineType())) {
            return false;
        }
        if (other.getHostInstanceType() == null ^ this.getHostInstanceType() == null) {
            return false;
        }
        if (other.getHostInstanceType() != null && !other.getHostInstanceType().equals(this.getHostInstanceType())) {
            return false;
        }
        if (other.getSupportedEngineVersions() == null ^ this.getSupportedEngineVersions() == null) {
            return false;
        }
        return other.getSupportedEngineVersions() == null || other.getSupportedEngineVersions().equals(this.getSupportedEngineVersions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getEngineType() == null ? 0 : this.getEngineType().hashCode());
        hashCode = 31 * hashCode + (this.getHostInstanceType() == null ? 0 : this.getHostInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedEngineVersions() == null ? 0 : this.getSupportedEngineVersions().hashCode());
        return hashCode;
    }

    public BrokerInstanceOption clone() {
        try {
            return (BrokerInstanceOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BrokerInstanceOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

