/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mq.model.Configurations;
import java.util.List;

@SdkInternalApi
public class ConfigurationsMarshaller {
    private static final MarshallingInfo<StructuredPojo> CURRENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("current").build();
    private static final MarshallingInfo<List> HISTORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("history").build();
    private static final MarshallingInfo<StructuredPojo> PENDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pending").build();
    private static final ConfigurationsMarshaller instance = new ConfigurationsMarshaller();

    public static ConfigurationsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Configurations configurations, ProtocolMarshaller protocolMarshaller) {
        if (configurations == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)configurations.getCurrent(), CURRENT_BINDING);
            protocolMarshaller.marshall(configurations.getHistory(), HISTORY_BINDING);
            protocolMarshaller.marshall((Object)configurations.getPending(), PENDING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

