/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhubstrategyrecommendations.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.migrationhubstrategyrecommendations.model.NetworkInfo;
import com.amazonaws.services.migrationhubstrategyrecommendations.model.OSInfo;
import com.amazonaws.services.migrationhubstrategyrecommendations.model.transform.SystemInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SystemInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String cpuArchitecture;
    private String fileSystemType;
    private List<NetworkInfo> networkInfoList;
    private OSInfo osInfo;

    public void setCpuArchitecture(String cpuArchitecture) {
        this.cpuArchitecture = cpuArchitecture;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public SystemInfo withCpuArchitecture(String cpuArchitecture) {
        this.setCpuArchitecture(cpuArchitecture);
        return this;
    }

    public void setFileSystemType(String fileSystemType) {
        this.fileSystemType = fileSystemType;
    }

    public String getFileSystemType() {
        return this.fileSystemType;
    }

    public SystemInfo withFileSystemType(String fileSystemType) {
        this.setFileSystemType(fileSystemType);
        return this;
    }

    public List<NetworkInfo> getNetworkInfoList() {
        return this.networkInfoList;
    }

    public void setNetworkInfoList(Collection<NetworkInfo> networkInfoList) {
        if (networkInfoList == null) {
            this.networkInfoList = null;
            return;
        }
        this.networkInfoList = new ArrayList<NetworkInfo>(networkInfoList);
    }

    public SystemInfo withNetworkInfoList(NetworkInfo ... networkInfoList) {
        if (this.networkInfoList == null) {
            this.setNetworkInfoList(new ArrayList<NetworkInfo>(networkInfoList.length));
        }
        for (NetworkInfo ele : networkInfoList) {
            this.networkInfoList.add(ele);
        }
        return this;
    }

    public SystemInfo withNetworkInfoList(Collection<NetworkInfo> networkInfoList) {
        this.setNetworkInfoList(networkInfoList);
        return this;
    }

    public void setOsInfo(OSInfo osInfo) {
        this.osInfo = osInfo;
    }

    public OSInfo getOsInfo() {
        return this.osInfo;
    }

    public SystemInfo withOsInfo(OSInfo osInfo) {
        this.setOsInfo(osInfo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCpuArchitecture() != null) {
            sb.append("CpuArchitecture: ").append(this.getCpuArchitecture()).append(",");
        }
        if (this.getFileSystemType() != null) {
            sb.append("FileSystemType: ").append(this.getFileSystemType()).append(",");
        }
        if (this.getNetworkInfoList() != null) {
            sb.append("NetworkInfoList: ").append(this.getNetworkInfoList()).append(",");
        }
        if (this.getOsInfo() != null) {
            sb.append("OsInfo: ").append(this.getOsInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemInfo)) {
            return false;
        }
        SystemInfo other = (SystemInfo)obj;
        if (other.getCpuArchitecture() == null ^ this.getCpuArchitecture() == null) {
            return false;
        }
        if (other.getCpuArchitecture() != null && !other.getCpuArchitecture().equals(this.getCpuArchitecture())) {
            return false;
        }
        if (other.getFileSystemType() == null ^ this.getFileSystemType() == null) {
            return false;
        }
        if (other.getFileSystemType() != null && !other.getFileSystemType().equals(this.getFileSystemType())) {
            return false;
        }
        if (other.getNetworkInfoList() == null ^ this.getNetworkInfoList() == null) {
            return false;
        }
        if (other.getNetworkInfoList() != null && !other.getNetworkInfoList().equals(this.getNetworkInfoList())) {
            return false;
        }
        if (other.getOsInfo() == null ^ this.getOsInfo() == null) {
            return false;
        }
        return other.getOsInfo() == null || other.getOsInfo().equals(this.getOsInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCpuArchitecture() == null ? 0 : this.getCpuArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemType() == null ? 0 : this.getFileSystemType().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInfoList() == null ? 0 : this.getNetworkInfoList().hashCode());
        hashCode = 31 * hashCode + (this.getOsInfo() == null ? 0 : this.getOsInfo().hashCode());
        return hashCode;
    }

    public SystemInfo clone() {
        try {
            return (SystemInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SystemInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

