/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhuborchestrator.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.migrationhuborchestrator.model.StepInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateWorkflowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String id;
    private String name;
    private String description;
    private Map<String, StepInput> inputParameters;
    private List<String> stepTargets;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public UpdateWorkflowRequest withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateWorkflowRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateWorkflowRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, StepInput> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(Map<String, StepInput> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public UpdateWorkflowRequest withInputParameters(Map<String, StepInput> inputParameters) {
        this.setInputParameters(inputParameters);
        return this;
    }

    public UpdateWorkflowRequest addInputParametersEntry(String key, StepInput value) {
        if (null == this.inputParameters) {
            this.inputParameters = new HashMap<String, StepInput>();
        }
        if (this.inputParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.inputParameters.put(key, value);
        return this;
    }

    public UpdateWorkflowRequest clearInputParametersEntries() {
        this.inputParameters = null;
        return this;
    }

    public List<String> getStepTargets() {
        return this.stepTargets;
    }

    public void setStepTargets(Collection<String> stepTargets) {
        if (stepTargets == null) {
            this.stepTargets = null;
            return;
        }
        this.stepTargets = new ArrayList<String>(stepTargets);
    }

    public UpdateWorkflowRequest withStepTargets(String ... stepTargets) {
        if (this.stepTargets == null) {
            this.setStepTargets(new ArrayList<String>(stepTargets.length));
        }
        for (String ele : stepTargets) {
            this.stepTargets.add(ele);
        }
        return this;
    }

    public UpdateWorkflowRequest withStepTargets(Collection<String> stepTargets) {
        this.setStepTargets(stepTargets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getInputParameters() != null) {
            sb.append("InputParameters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStepTargets() != null) {
            sb.append("StepTargets: ").append(this.getStepTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowRequest)) {
            return false;
        }
        UpdateWorkflowRequest other = (UpdateWorkflowRequest)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getInputParameters() == null ^ this.getInputParameters() == null) {
            return false;
        }
        if (other.getInputParameters() != null && !other.getInputParameters().equals(this.getInputParameters())) {
            return false;
        }
        if (other.getStepTargets() == null ^ this.getStepTargets() == null) {
            return false;
        }
        return other.getStepTargets() == null || other.getStepTargets().equals(this.getStepTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getInputParameters() == null ? 0 : this.getInputParameters().hashCode());
        hashCode = 31 * hashCode + (this.getStepTargets() == null ? 0 : this.getStepTargets().hashCode());
        return hashCode;
    }

    public UpdateWorkflowRequest clone() {
        return (UpdateWorkflowRequest)super.clone();
    }
}

