/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.memorydb.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateACLRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String aCLName;
    private List<String> userNames;
    private List<Tag> tags;

    public void setACLName(String aCLName) {
        this.aCLName = aCLName;
    }

    public String getACLName() {
        return this.aCLName;
    }

    public CreateACLRequest withACLName(String aCLName) {
        this.setACLName(aCLName);
        return this;
    }

    public List<String> getUserNames() {
        return this.userNames;
    }

    public void setUserNames(Collection<String> userNames) {
        if (userNames == null) {
            this.userNames = null;
            return;
        }
        this.userNames = new ArrayList<String>(userNames);
    }

    public CreateACLRequest withUserNames(String ... userNames) {
        if (this.userNames == null) {
            this.setUserNames(new ArrayList<String>(userNames.length));
        }
        for (String ele : userNames) {
            this.userNames.add(ele);
        }
        return this;
    }

    public CreateACLRequest withUserNames(Collection<String> userNames) {
        this.setUserNames(userNames);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateACLRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateACLRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getACLName() != null) {
            sb.append("ACLName: ").append(this.getACLName()).append(",");
        }
        if (this.getUserNames() != null) {
            sb.append("UserNames: ").append(this.getUserNames()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateACLRequest)) {
            return false;
        }
        CreateACLRequest other = (CreateACLRequest)obj;
        if (other.getACLName() == null ^ this.getACLName() == null) {
            return false;
        }
        if (other.getACLName() != null && !other.getACLName().equals(this.getACLName())) {
            return false;
        }
        if (other.getUserNames() == null ^ this.getUserNames() == null) {
            return false;
        }
        if (other.getUserNames() != null && !other.getUserNames().equals(this.getUserNames())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getACLName() == null ? 0 : this.getACLName().hashCode());
        hashCode = 31 * hashCode + (this.getUserNames() == null ? 0 : this.getUserNames().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateACLRequest clone() {
        return (CreateACLRequest)super.clone();
    }
}

