/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mediatailor.model.LogType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigureLogsForChannelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String channelName;
    private List<String> logTypes;

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public ConfigureLogsForChannelRequest withChannelName(String channelName) {
        this.setChannelName(channelName);
        return this;
    }

    public List<String> getLogTypes() {
        return this.logTypes;
    }

    public void setLogTypes(Collection<String> logTypes) {
        if (logTypes == null) {
            this.logTypes = null;
            return;
        }
        this.logTypes = new ArrayList<String>(logTypes);
    }

    public ConfigureLogsForChannelRequest withLogTypes(String ... logTypes) {
        if (this.logTypes == null) {
            this.setLogTypes(new ArrayList<String>(logTypes.length));
        }
        for (String ele : logTypes) {
            this.logTypes.add(ele);
        }
        return this;
    }

    public ConfigureLogsForChannelRequest withLogTypes(Collection<String> logTypes) {
        this.setLogTypes(logTypes);
        return this;
    }

    public ConfigureLogsForChannelRequest withLogTypes(LogType ... logTypes) {
        ArrayList<String> logTypesCopy = new ArrayList<String>(logTypes.length);
        for (LogType value : logTypes) {
            logTypesCopy.add(value.toString());
        }
        if (this.getLogTypes() == null) {
            this.setLogTypes(logTypesCopy);
        } else {
            this.getLogTypes().addAll(logTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannelName() != null) {
            sb.append("ChannelName: ").append(this.getChannelName()).append(",");
        }
        if (this.getLogTypes() != null) {
            sb.append("LogTypes: ").append(this.getLogTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsForChannelRequest)) {
            return false;
        }
        ConfigureLogsForChannelRequest other = (ConfigureLogsForChannelRequest)obj;
        if (other.getChannelName() == null ^ this.getChannelName() == null) {
            return false;
        }
        if (other.getChannelName() != null && !other.getChannelName().equals(this.getChannelName())) {
            return false;
        }
        if (other.getLogTypes() == null ^ this.getLogTypes() == null) {
            return false;
        }
        return other.getLogTypes() == null || other.getLogTypes().equals(this.getLogTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannelName() == null ? 0 : this.getChannelName().hashCode());
        hashCode = 31 * hashCode + (this.getLogTypes() == null ? 0 : this.getLogTypes().hashCode());
        return hashCode;
    }

    public ConfigureLogsForChannelRequest clone() {
        return (ConfigureLogsForChannelRequest)super.clone();
    }
}

