/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mediatailor.AWSMediaTailor;
import com.amazonaws.services.mediatailor.AWSMediaTailorClientBuilder;
import com.amazonaws.services.mediatailor.model.AWSMediaTailorException;
import com.amazonaws.services.mediatailor.model.CreateChannelRequest;
import com.amazonaws.services.mediatailor.model.CreateChannelResult;
import com.amazonaws.services.mediatailor.model.CreateProgramRequest;
import com.amazonaws.services.mediatailor.model.CreateProgramResult;
import com.amazonaws.services.mediatailor.model.CreateSourceLocationRequest;
import com.amazonaws.services.mediatailor.model.CreateSourceLocationResult;
import com.amazonaws.services.mediatailor.model.CreateVodSourceRequest;
import com.amazonaws.services.mediatailor.model.CreateVodSourceResult;
import com.amazonaws.services.mediatailor.model.DeleteChannelPolicyRequest;
import com.amazonaws.services.mediatailor.model.DeleteChannelPolicyResult;
import com.amazonaws.services.mediatailor.model.DeleteChannelRequest;
import com.amazonaws.services.mediatailor.model.DeleteChannelResult;
import com.amazonaws.services.mediatailor.model.DeletePlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.DeletePlaybackConfigurationResult;
import com.amazonaws.services.mediatailor.model.DeleteProgramRequest;
import com.amazonaws.services.mediatailor.model.DeleteProgramResult;
import com.amazonaws.services.mediatailor.model.DeleteSourceLocationRequest;
import com.amazonaws.services.mediatailor.model.DeleteSourceLocationResult;
import com.amazonaws.services.mediatailor.model.DeleteVodSourceRequest;
import com.amazonaws.services.mediatailor.model.DeleteVodSourceResult;
import com.amazonaws.services.mediatailor.model.DescribeChannelRequest;
import com.amazonaws.services.mediatailor.model.DescribeChannelResult;
import com.amazonaws.services.mediatailor.model.DescribeProgramRequest;
import com.amazonaws.services.mediatailor.model.DescribeProgramResult;
import com.amazonaws.services.mediatailor.model.DescribeSourceLocationRequest;
import com.amazonaws.services.mediatailor.model.DescribeSourceLocationResult;
import com.amazonaws.services.mediatailor.model.DescribeVodSourceRequest;
import com.amazonaws.services.mediatailor.model.DescribeVodSourceResult;
import com.amazonaws.services.mediatailor.model.GetChannelPolicyRequest;
import com.amazonaws.services.mediatailor.model.GetChannelPolicyResult;
import com.amazonaws.services.mediatailor.model.GetChannelScheduleRequest;
import com.amazonaws.services.mediatailor.model.GetChannelScheduleResult;
import com.amazonaws.services.mediatailor.model.GetPlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.GetPlaybackConfigurationResult;
import com.amazonaws.services.mediatailor.model.ListAlertsRequest;
import com.amazonaws.services.mediatailor.model.ListAlertsResult;
import com.amazonaws.services.mediatailor.model.ListChannelsRequest;
import com.amazonaws.services.mediatailor.model.ListChannelsResult;
import com.amazonaws.services.mediatailor.model.ListPlaybackConfigurationsRequest;
import com.amazonaws.services.mediatailor.model.ListPlaybackConfigurationsResult;
import com.amazonaws.services.mediatailor.model.ListSourceLocationsRequest;
import com.amazonaws.services.mediatailor.model.ListSourceLocationsResult;
import com.amazonaws.services.mediatailor.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediatailor.model.ListTagsForResourceResult;
import com.amazonaws.services.mediatailor.model.ListVodSourcesRequest;
import com.amazonaws.services.mediatailor.model.ListVodSourcesResult;
import com.amazonaws.services.mediatailor.model.PutChannelPolicyRequest;
import com.amazonaws.services.mediatailor.model.PutChannelPolicyResult;
import com.amazonaws.services.mediatailor.model.PutPlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.PutPlaybackConfigurationResult;
import com.amazonaws.services.mediatailor.model.StartChannelRequest;
import com.amazonaws.services.mediatailor.model.StartChannelResult;
import com.amazonaws.services.mediatailor.model.StopChannelRequest;
import com.amazonaws.services.mediatailor.model.StopChannelResult;
import com.amazonaws.services.mediatailor.model.TagResourceRequest;
import com.amazonaws.services.mediatailor.model.TagResourceResult;
import com.amazonaws.services.mediatailor.model.UntagResourceRequest;
import com.amazonaws.services.mediatailor.model.UntagResourceResult;
import com.amazonaws.services.mediatailor.model.UpdateChannelRequest;
import com.amazonaws.services.mediatailor.model.UpdateChannelResult;
import com.amazonaws.services.mediatailor.model.UpdateSourceLocationRequest;
import com.amazonaws.services.mediatailor.model.UpdateSourceLocationResult;
import com.amazonaws.services.mediatailor.model.UpdateVodSourceRequest;
import com.amazonaws.services.mediatailor.model.UpdateVodSourceResult;
import com.amazonaws.services.mediatailor.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.CreateChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.CreateChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.CreateProgramRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.CreateProgramResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.CreateSourceLocationRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.CreateSourceLocationResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.CreateVodSourceRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.CreateVodSourceResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteChannelPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteChannelPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeletePlaybackConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeletePlaybackConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteProgramRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteProgramResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteSourceLocationRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteSourceLocationResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteVodSourceRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DeleteVodSourceResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DescribeChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DescribeChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DescribeProgramRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DescribeProgramResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DescribeSourceLocationRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DescribeSourceLocationResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.DescribeVodSourceRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.DescribeVodSourceResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.GetChannelPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.GetChannelPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.GetChannelScheduleRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.GetChannelScheduleResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.GetPlaybackConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.GetPlaybackConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListAlertsRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListAlertsResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListChannelsRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListChannelsResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListPlaybackConfigurationsRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListPlaybackConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListSourceLocationsRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListSourceLocationsResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListVodSourcesRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.ListVodSourcesResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.PutChannelPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.PutChannelPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.PutPlaybackConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.PutPlaybackConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.StartChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.StartChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.StopChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.StopChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.UpdateChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.UpdateChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.UpdateSourceLocationRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.UpdateSourceLocationResultJsonUnmarshaller;
import com.amazonaws.services.mediatailor.model.transform.UpdateVodSourceRequestProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.transform.UpdateVodSourceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMediaTailorClient
extends AmazonWebServiceClient
implements AWSMediaTailor {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaTailor.class);
    private static final String DEFAULT_SIGNING_NAME = "mediatailor";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMediaTailorException.class));

    public static AWSMediaTailorClientBuilder builder() {
        return AWSMediaTailorClientBuilder.standard();
    }

    AWSMediaTailorClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMediaTailorClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("api.mediatailor");
        this.setEndpoint("api.mediatailor.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mediatailor/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mediatailor/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        request = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executeCreateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChannelResult executeCreateChannel(CreateChannelRequest createChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChannelRequestProtocolMarshaller(protocolFactory).marshall((CreateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChannelResult createChannelResult = (CreateChannelResult)response.getAwsResponse();
            return createChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProgramResult createProgram(CreateProgramRequest request) {
        request = (CreateProgramRequest)this.beforeClientExecution(request);
        return this.executeCreateProgram(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProgramResult executeCreateProgram(CreateProgramRequest createProgramRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProgramRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProgramRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProgramRequestProtocolMarshaller(protocolFactory).marshall((CreateProgramRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProgramRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProgram");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProgramResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProgramResult createProgramResult = (CreateProgramResult)response.getAwsResponse();
            return createProgramResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSourceLocationResult createSourceLocation(CreateSourceLocationRequest request) {
        request = (CreateSourceLocationRequest)this.beforeClientExecution(request);
        return this.executeCreateSourceLocation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSourceLocationResult executeCreateSourceLocation(CreateSourceLocationRequest createSourceLocationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSourceLocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSourceLocationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSourceLocationRequestProtocolMarshaller(protocolFactory).marshall((CreateSourceLocationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSourceLocationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSourceLocation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSourceLocationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSourceLocationResult createSourceLocationResult = (CreateSourceLocationResult)response.getAwsResponse();
            return createSourceLocationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateVodSourceResult createVodSource(CreateVodSourceRequest request) {
        request = (CreateVodSourceRequest)this.beforeClientExecution(request);
        return this.executeCreateVodSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateVodSourceResult executeCreateVodSource(CreateVodSourceRequest createVodSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createVodSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVodSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVodSourceRequestProtocolMarshaller(protocolFactory).marshall((CreateVodSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createVodSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateVodSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateVodSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateVodSourceResult createVodSourceResult = (CreateVodSourceResult)response.getAwsResponse();
            return createVodSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        request = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executeDeleteChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelResult executeDeleteChannel(DeleteChannelRequest deleteChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelRequestProtocolMarshaller(protocolFactory).marshall((DeleteChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelResult deleteChannelResult = (DeleteChannelResult)response.getAwsResponse();
            return deleteChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelPolicyResult deleteChannelPolicy(DeleteChannelPolicyRequest request) {
        request = (DeleteChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteChannelPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelPolicyResult executeDeleteChannelPolicy(DeleteChannelPolicyRequest deleteChannelPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelPolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteChannelPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChannelPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChannelPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelPolicyResult deleteChannelPolicyResult = (DeleteChannelPolicyResult)response.getAwsResponse();
            return deleteChannelPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePlaybackConfigurationResult deletePlaybackConfiguration(DeletePlaybackConfigurationRequest request) {
        request = (DeletePlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeletePlaybackConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePlaybackConfigurationResult executeDeletePlaybackConfiguration(DeletePlaybackConfigurationRequest deletePlaybackConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePlaybackConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePlaybackConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePlaybackConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeletePlaybackConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePlaybackConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePlaybackConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePlaybackConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePlaybackConfigurationResult deletePlaybackConfigurationResult = (DeletePlaybackConfigurationResult)response.getAwsResponse();
            return deletePlaybackConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProgramResult deleteProgram(DeleteProgramRequest request) {
        request = (DeleteProgramRequest)this.beforeClientExecution(request);
        return this.executeDeleteProgram(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProgramResult executeDeleteProgram(DeleteProgramRequest deleteProgramRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProgramRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProgramRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProgramRequestProtocolMarshaller(protocolFactory).marshall((DeleteProgramRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProgramRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteProgram");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProgramResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProgramResult deleteProgramResult = (DeleteProgramResult)response.getAwsResponse();
            return deleteProgramResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSourceLocationResult deleteSourceLocation(DeleteSourceLocationRequest request) {
        request = (DeleteSourceLocationRequest)this.beforeClientExecution(request);
        return this.executeDeleteSourceLocation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSourceLocationResult executeDeleteSourceLocation(DeleteSourceLocationRequest deleteSourceLocationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSourceLocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSourceLocationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSourceLocationRequestProtocolMarshaller(protocolFactory).marshall((DeleteSourceLocationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSourceLocationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSourceLocation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSourceLocationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSourceLocationResult deleteSourceLocationResult = (DeleteSourceLocationResult)response.getAwsResponse();
            return deleteSourceLocationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteVodSourceResult deleteVodSource(DeleteVodSourceRequest request) {
        request = (DeleteVodSourceRequest)this.beforeClientExecution(request);
        return this.executeDeleteVodSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteVodSourceResult executeDeleteVodSource(DeleteVodSourceRequest deleteVodSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVodSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVodSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVodSourceRequestProtocolMarshaller(protocolFactory).marshall((DeleteVodSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVodSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteVodSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVodSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVodSourceResult deleteVodSourceResult = (DeleteVodSourceResult)response.getAwsResponse();
            return deleteVodSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        request = (DescribeChannelRequest)this.beforeClientExecution(request);
        return this.executeDescribeChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeChannelResult executeDescribeChannel(DescribeChannelRequest describeChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeChannelRequestProtocolMarshaller(protocolFactory).marshall((DescribeChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeChannelResult describeChannelResult = (DescribeChannelResult)response.getAwsResponse();
            return describeChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProgramResult describeProgram(DescribeProgramRequest request) {
        request = (DescribeProgramRequest)this.beforeClientExecution(request);
        return this.executeDescribeProgram(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProgramResult executeDescribeProgram(DescribeProgramRequest describeProgramRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProgramRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProgramRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProgramRequestProtocolMarshaller(protocolFactory).marshall((DescribeProgramRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProgramRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeProgram");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProgramResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProgramResult describeProgramResult = (DescribeProgramResult)response.getAwsResponse();
            return describeProgramResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSourceLocationResult describeSourceLocation(DescribeSourceLocationRequest request) {
        request = (DescribeSourceLocationRequest)this.beforeClientExecution(request);
        return this.executeDescribeSourceLocation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSourceLocationResult executeDescribeSourceLocation(DescribeSourceLocationRequest describeSourceLocationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSourceLocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSourceLocationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSourceLocationRequestProtocolMarshaller(protocolFactory).marshall((DescribeSourceLocationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSourceLocationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSourceLocation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSourceLocationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSourceLocationResult describeSourceLocationResult = (DescribeSourceLocationResult)response.getAwsResponse();
            return describeSourceLocationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeVodSourceResult describeVodSource(DescribeVodSourceRequest request) {
        request = (DescribeVodSourceRequest)this.beforeClientExecution(request);
        return this.executeDescribeVodSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeVodSourceResult executeDescribeVodSource(DescribeVodSourceRequest describeVodSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVodSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVodSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVodSourceRequestProtocolMarshaller(protocolFactory).marshall((DescribeVodSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeVodSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeVodSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeVodSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeVodSourceResult describeVodSourceResult = (DescribeVodSourceResult)response.getAwsResponse();
            return describeVodSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChannelPolicyResult getChannelPolicy(GetChannelPolicyRequest request) {
        request = (GetChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetChannelPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChannelPolicyResult executeGetChannelPolicy(GetChannelPolicyRequest getChannelPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChannelPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChannelPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChannelPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetChannelPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChannelPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChannelPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetChannelPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetChannelPolicyResult getChannelPolicyResult = (GetChannelPolicyResult)response.getAwsResponse();
            return getChannelPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChannelScheduleResult getChannelSchedule(GetChannelScheduleRequest request) {
        request = (GetChannelScheduleRequest)this.beforeClientExecution(request);
        return this.executeGetChannelSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChannelScheduleResult executeGetChannelSchedule(GetChannelScheduleRequest getChannelScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChannelScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChannelScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChannelScheduleRequestProtocolMarshaller(protocolFactory).marshall((GetChannelScheduleRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChannelScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChannelSchedule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetChannelScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetChannelScheduleResult getChannelScheduleResult = (GetChannelScheduleResult)response.getAwsResponse();
            return getChannelScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPlaybackConfigurationResult getPlaybackConfiguration(GetPlaybackConfigurationRequest request) {
        request = (GetPlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetPlaybackConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPlaybackConfigurationResult executeGetPlaybackConfiguration(GetPlaybackConfigurationRequest getPlaybackConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPlaybackConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPlaybackConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPlaybackConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetPlaybackConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPlaybackConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPlaybackConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPlaybackConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPlaybackConfigurationResult getPlaybackConfigurationResult = (GetPlaybackConfigurationResult)response.getAwsResponse();
            return getPlaybackConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAlertsResult listAlerts(ListAlertsRequest request) {
        request = (ListAlertsRequest)this.beforeClientExecution(request);
        return this.executeListAlerts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAlertsResult executeListAlerts(ListAlertsRequest listAlertsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAlertsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAlertsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAlertsRequestProtocolMarshaller(protocolFactory).marshall((ListAlertsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAlertsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAlerts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAlertsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAlertsResult listAlertsResult = (ListAlertsResult)response.getAwsResponse();
            return listAlertsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        request = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executeListChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChannelsResult executeListChannels(ListChannelsRequest listChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChannelsRequestProtocolMarshaller(protocolFactory).marshall((ListChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChannels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChannelsResult listChannelsResult = (ListChannelsResult)response.getAwsResponse();
            return listChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPlaybackConfigurationsResult listPlaybackConfigurations(ListPlaybackConfigurationsRequest request) {
        request = (ListPlaybackConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListPlaybackConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPlaybackConfigurationsResult executeListPlaybackConfigurations(ListPlaybackConfigurationsRequest listPlaybackConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPlaybackConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPlaybackConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPlaybackConfigurationsRequestProtocolMarshaller(protocolFactory).marshall((ListPlaybackConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPlaybackConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPlaybackConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPlaybackConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPlaybackConfigurationsResult listPlaybackConfigurationsResult = (ListPlaybackConfigurationsResult)response.getAwsResponse();
            return listPlaybackConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSourceLocationsResult listSourceLocations(ListSourceLocationsRequest request) {
        request = (ListSourceLocationsRequest)this.beforeClientExecution(request);
        return this.executeListSourceLocations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSourceLocationsResult executeListSourceLocations(ListSourceLocationsRequest listSourceLocationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSourceLocationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSourceLocationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSourceLocationsRequestProtocolMarshaller(protocolFactory).marshall((ListSourceLocationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSourceLocationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSourceLocations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSourceLocationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSourceLocationsResult listSourceLocationsResult = (ListSourceLocationsResult)response.getAwsResponse();
            return listSourceLocationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListVodSourcesResult listVodSources(ListVodSourcesRequest request) {
        request = (ListVodSourcesRequest)this.beforeClientExecution(request);
        return this.executeListVodSources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListVodSourcesResult executeListVodSources(ListVodSourcesRequest listVodSourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVodSourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVodSourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVodSourcesRequestProtocolMarshaller(protocolFactory).marshall((ListVodSourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVodSourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListVodSources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVodSourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListVodSourcesResult listVodSourcesResult = (ListVodSourcesResult)response.getAwsResponse();
            return listVodSourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutChannelPolicyResult putChannelPolicy(PutChannelPolicyRequest request) {
        request = (PutChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executePutChannelPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutChannelPolicyResult executePutChannelPolicy(PutChannelPolicyRequest putChannelPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putChannelPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutChannelPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutChannelPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutChannelPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putChannelPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutChannelPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutChannelPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutChannelPolicyResult putChannelPolicyResult = (PutChannelPolicyResult)response.getAwsResponse();
            return putChannelPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutPlaybackConfigurationResult putPlaybackConfiguration(PutPlaybackConfigurationRequest request) {
        request = (PutPlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executePutPlaybackConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutPlaybackConfigurationResult executePutPlaybackConfiguration(PutPlaybackConfigurationRequest putPlaybackConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPlaybackConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPlaybackConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPlaybackConfigurationRequestProtocolMarshaller(protocolFactory).marshall((PutPlaybackConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)putPlaybackConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutPlaybackConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutPlaybackConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutPlaybackConfigurationResult putPlaybackConfigurationResult = (PutPlaybackConfigurationResult)response.getAwsResponse();
            return putPlaybackConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartChannelResult startChannel(StartChannelRequest request) {
        request = (StartChannelRequest)this.beforeClientExecution(request);
        return this.executeStartChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartChannelResult executeStartChannel(StartChannelRequest startChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartChannelRequestProtocolMarshaller(protocolFactory).marshall((StartChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)startChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartChannelResult startChannelResult = (StartChannelResult)response.getAwsResponse();
            return startChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopChannelResult stopChannel(StopChannelRequest request) {
        request = (StopChannelRequest)this.beforeClientExecution(request);
        return this.executeStopChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopChannelResult executeStopChannel(StopChannelRequest stopChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopChannelRequestProtocolMarshaller(protocolFactory).marshall((StopChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopChannelResult stopChannelResult = (StopChannelResult)response.getAwsResponse();
            return stopChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        request = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executeUpdateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChannelResult executeUpdateChannel(UpdateChannelRequest updateChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChannelRequestProtocolMarshaller(protocolFactory).marshall((UpdateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChannelResult updateChannelResult = (UpdateChannelResult)response.getAwsResponse();
            return updateChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSourceLocationResult updateSourceLocation(UpdateSourceLocationRequest request) {
        request = (UpdateSourceLocationRequest)this.beforeClientExecution(request);
        return this.executeUpdateSourceLocation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSourceLocationResult executeUpdateSourceLocation(UpdateSourceLocationRequest updateSourceLocationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSourceLocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSourceLocationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSourceLocationRequestProtocolMarshaller(protocolFactory).marshall((UpdateSourceLocationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSourceLocationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSourceLocation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSourceLocationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSourceLocationResult updateSourceLocationResult = (UpdateSourceLocationResult)response.getAwsResponse();
            return updateSourceLocationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateVodSourceResult updateVodSource(UpdateVodSourceRequest request) {
        request = (UpdateVodSourceRequest)this.beforeClientExecution(request);
        return this.executeUpdateVodSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateVodSourceResult executeUpdateVodSource(UpdateVodSourceRequest updateVodSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateVodSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateVodSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateVodSourceRequestProtocolMarshaller(protocolFactory).marshall((UpdateVodSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateVodSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaTailor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateVodSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateVodSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateVodSourceResult updateVodSourceResult = (UpdateVodSourceResult)response.getAwsResponse();
            return updateVodSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

