/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.Alert;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AlertMarshaller {
    private static final MarshallingInfo<String> ALERTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlertCode").build();
    private static final MarshallingInfo<String> ALERTMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlertMessage").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> RELATEDRESOURCEARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelatedResourceArns").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final AlertMarshaller instance = new AlertMarshaller();

    public static AlertMarshaller getInstance() {
        return instance;
    }

    public void marshall(Alert alert, ProtocolMarshaller protocolMarshaller) {
        if (alert == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)alert.getAlertCode(), ALERTCODE_BINDING);
            protocolMarshaller.marshall((Object)alert.getAlertMessage(), ALERTMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)alert.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall(alert.getRelatedResourceArns(), RELATEDRESOURCEARNS_BINDING);
            protocolMarshaller.marshall((Object)alert.getResourceArn(), RESOURCEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

