/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mediatailor.model.HttpPackageConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateVodSourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<HttpPackageConfiguration> httpPackageConfigurations;
    private String sourceLocationName;
    private Map<String, String> tags;
    private String vodSourceName;

    public List<HttpPackageConfiguration> getHttpPackageConfigurations() {
        return this.httpPackageConfigurations;
    }

    public void setHttpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
        if (httpPackageConfigurations == null) {
            this.httpPackageConfigurations = null;
            return;
        }
        this.httpPackageConfigurations = new ArrayList<HttpPackageConfiguration>(httpPackageConfigurations);
    }

    public CreateVodSourceRequest withHttpPackageConfigurations(HttpPackageConfiguration ... httpPackageConfigurations) {
        if (this.httpPackageConfigurations == null) {
            this.setHttpPackageConfigurations(new ArrayList<HttpPackageConfiguration>(httpPackageConfigurations.length));
        }
        for (HttpPackageConfiguration ele : httpPackageConfigurations) {
            this.httpPackageConfigurations.add(ele);
        }
        return this;
    }

    public CreateVodSourceRequest withHttpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
        this.setHttpPackageConfigurations(httpPackageConfigurations);
        return this;
    }

    public void setSourceLocationName(String sourceLocationName) {
        this.sourceLocationName = sourceLocationName;
    }

    public String getSourceLocationName() {
        return this.sourceLocationName;
    }

    public CreateVodSourceRequest withSourceLocationName(String sourceLocationName) {
        this.setSourceLocationName(sourceLocationName);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateVodSourceRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateVodSourceRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateVodSourceRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setVodSourceName(String vodSourceName) {
        this.vodSourceName = vodSourceName;
    }

    public String getVodSourceName() {
        return this.vodSourceName;
    }

    public CreateVodSourceRequest withVodSourceName(String vodSourceName) {
        this.setVodSourceName(vodSourceName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHttpPackageConfigurations() != null) {
            sb.append("HttpPackageConfigurations: ").append(this.getHttpPackageConfigurations()).append(",");
        }
        if (this.getSourceLocationName() != null) {
            sb.append("SourceLocationName: ").append(this.getSourceLocationName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVodSourceName() != null) {
            sb.append("VodSourceName: ").append(this.getVodSourceName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVodSourceRequest)) {
            return false;
        }
        CreateVodSourceRequest other = (CreateVodSourceRequest)obj;
        if (other.getHttpPackageConfigurations() == null ^ this.getHttpPackageConfigurations() == null) {
            return false;
        }
        if (other.getHttpPackageConfigurations() != null && !other.getHttpPackageConfigurations().equals(this.getHttpPackageConfigurations())) {
            return false;
        }
        if (other.getSourceLocationName() == null ^ this.getSourceLocationName() == null) {
            return false;
        }
        if (other.getSourceLocationName() != null && !other.getSourceLocationName().equals(this.getSourceLocationName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVodSourceName() == null ^ this.getVodSourceName() == null) {
            return false;
        }
        return other.getVodSourceName() == null || other.getVodSourceName().equals(this.getVodSourceName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHttpPackageConfigurations() == null ? 0 : this.getHttpPackageConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getSourceLocationName() == null ? 0 : this.getSourceLocationName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVodSourceName() == null ? 0 : this.getVodSourceName().hashCode());
        return hashCode;
    }

    public CreateVodSourceRequest clone() {
        return (CreateVodSourceRequest)super.clone();
    }
}

