/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediapackagevod;

import javax.annotation.Generated;

import com.amazonaws.services.mediapackagevod.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSMediaPackageVod}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMediaPackageVod implements AWSMediaPackageVod {

    protected AbstractAWSMediaPackageVod() {
    }

    @Override
    public ConfigureLogsResult configureLogs(ConfigureLogsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssetResult createAsset(CreateAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePackagingConfigurationResult createPackagingConfiguration(CreatePackagingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePackagingGroupResult createPackagingGroup(CreatePackagingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssetResult deleteAsset(DeleteAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePackagingConfigurationResult deletePackagingConfiguration(DeletePackagingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePackagingGroupResult deletePackagingGroup(DeletePackagingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAssetResult describeAsset(DescribeAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePackagingConfigurationResult describePackagingConfiguration(DescribePackagingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePackagingGroupResult describePackagingGroup(DescribePackagingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssetsResult listAssets(ListAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPackagingConfigurationsResult listPackagingConfigurations(ListPackagingConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPackagingGroupsResult listPackagingGroups(ListPackagingGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePackagingGroupResult updatePackagingGroup(UpdatePackagingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
