/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagev2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediapackagev2.AWSMediaPackageV2Async;
import com.amazonaws.services.mediapackagev2.AWSMediaPackageV2AsyncClientBuilder;
import com.amazonaws.services.mediapackagev2.AWSMediaPackageV2Client;
import com.amazonaws.services.mediapackagev2.model.CreateChannelGroupRequest;
import com.amazonaws.services.mediapackagev2.model.CreateChannelGroupResult;
import com.amazonaws.services.mediapackagev2.model.CreateChannelRequest;
import com.amazonaws.services.mediapackagev2.model.CreateChannelResult;
import com.amazonaws.services.mediapackagev2.model.CreateOriginEndpointRequest;
import com.amazonaws.services.mediapackagev2.model.CreateOriginEndpointResult;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelGroupRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelGroupResult;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelPolicyResult;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelResult;
import com.amazonaws.services.mediapackagev2.model.DeleteOriginEndpointPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteOriginEndpointPolicyResult;
import com.amazonaws.services.mediapackagev2.model.DeleteOriginEndpointRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteOriginEndpointResult;
import com.amazonaws.services.mediapackagev2.model.GetChannelGroupRequest;
import com.amazonaws.services.mediapackagev2.model.GetChannelGroupResult;
import com.amazonaws.services.mediapackagev2.model.GetChannelPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.GetChannelPolicyResult;
import com.amazonaws.services.mediapackagev2.model.GetChannelRequest;
import com.amazonaws.services.mediapackagev2.model.GetChannelResult;
import com.amazonaws.services.mediapackagev2.model.GetOriginEndpointPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.GetOriginEndpointPolicyResult;
import com.amazonaws.services.mediapackagev2.model.GetOriginEndpointRequest;
import com.amazonaws.services.mediapackagev2.model.GetOriginEndpointResult;
import com.amazonaws.services.mediapackagev2.model.ListChannelGroupsRequest;
import com.amazonaws.services.mediapackagev2.model.ListChannelGroupsResult;
import com.amazonaws.services.mediapackagev2.model.ListChannelsRequest;
import com.amazonaws.services.mediapackagev2.model.ListChannelsResult;
import com.amazonaws.services.mediapackagev2.model.ListOriginEndpointsRequest;
import com.amazonaws.services.mediapackagev2.model.ListOriginEndpointsResult;
import com.amazonaws.services.mediapackagev2.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediapackagev2.model.ListTagsForResourceResult;
import com.amazonaws.services.mediapackagev2.model.PutChannelPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.PutChannelPolicyResult;
import com.amazonaws.services.mediapackagev2.model.PutOriginEndpointPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.PutOriginEndpointPolicyResult;
import com.amazonaws.services.mediapackagev2.model.TagResourceRequest;
import com.amazonaws.services.mediapackagev2.model.TagResourceResult;
import com.amazonaws.services.mediapackagev2.model.UntagResourceRequest;
import com.amazonaws.services.mediapackagev2.model.UntagResourceResult;
import com.amazonaws.services.mediapackagev2.model.UpdateChannelGroupRequest;
import com.amazonaws.services.mediapackagev2.model.UpdateChannelGroupResult;
import com.amazonaws.services.mediapackagev2.model.UpdateChannelRequest;
import com.amazonaws.services.mediapackagev2.model.UpdateChannelResult;
import com.amazonaws.services.mediapackagev2.model.UpdateOriginEndpointRequest;
import com.amazonaws.services.mediapackagev2.model.UpdateOriginEndpointResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaPackageV2AsyncClient
extends AWSMediaPackageV2Client
implements AWSMediaPackageV2Async {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaPackageV2AsyncClientBuilder asyncBuilder() {
        return AWSMediaPackageV2AsyncClientBuilder.standard();
    }

    AWSMediaPackageV2AsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMediaPackageV2AsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelAsync(request, null);
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request, final AsyncHandler<CreateChannelRequest, CreateChannelResult> asyncHandler) {
        final CreateChannelRequest finalRequest = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChannelResult>(){

            @Override
            public CreateChannelResult call() throws Exception {
                CreateChannelResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeCreateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateChannelGroupResult> createChannelGroupAsync(CreateChannelGroupRequest request) {
        return this.createChannelGroupAsync(request, null);
    }

    @Override
    public Future<CreateChannelGroupResult> createChannelGroupAsync(CreateChannelGroupRequest request, final AsyncHandler<CreateChannelGroupRequest, CreateChannelGroupResult> asyncHandler) {
        final CreateChannelGroupRequest finalRequest = (CreateChannelGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChannelGroupResult>(){

            @Override
            public CreateChannelGroupResult call() throws Exception {
                CreateChannelGroupResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeCreateChannelGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateOriginEndpointResult> createOriginEndpointAsync(CreateOriginEndpointRequest request) {
        return this.createOriginEndpointAsync(request, null);
    }

    @Override
    public Future<CreateOriginEndpointResult> createOriginEndpointAsync(CreateOriginEndpointRequest request, final AsyncHandler<CreateOriginEndpointRequest, CreateOriginEndpointResult> asyncHandler) {
        final CreateOriginEndpointRequest finalRequest = (CreateOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateOriginEndpointResult>(){

            @Override
            public CreateOriginEndpointResult call() throws Exception {
                CreateOriginEndpointResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeCreateOriginEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelAsync(request, null);
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request, final AsyncHandler<DeleteChannelRequest, DeleteChannelResult> asyncHandler) {
        final DeleteChannelRequest finalRequest = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelResult>(){

            @Override
            public DeleteChannelResult call() throws Exception {
                DeleteChannelResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeDeleteChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelGroupResult> deleteChannelGroupAsync(DeleteChannelGroupRequest request) {
        return this.deleteChannelGroupAsync(request, null);
    }

    @Override
    public Future<DeleteChannelGroupResult> deleteChannelGroupAsync(DeleteChannelGroupRequest request, final AsyncHandler<DeleteChannelGroupRequest, DeleteChannelGroupResult> asyncHandler) {
        final DeleteChannelGroupRequest finalRequest = (DeleteChannelGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelGroupResult>(){

            @Override
            public DeleteChannelGroupResult call() throws Exception {
                DeleteChannelGroupResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeDeleteChannelGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelPolicyResult> deleteChannelPolicyAsync(DeleteChannelPolicyRequest request) {
        return this.deleteChannelPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteChannelPolicyResult> deleteChannelPolicyAsync(DeleteChannelPolicyRequest request, final AsyncHandler<DeleteChannelPolicyRequest, DeleteChannelPolicyResult> asyncHandler) {
        final DeleteChannelPolicyRequest finalRequest = (DeleteChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelPolicyResult>(){

            @Override
            public DeleteChannelPolicyResult call() throws Exception {
                DeleteChannelPolicyResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeDeleteChannelPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteOriginEndpointResult> deleteOriginEndpointAsync(DeleteOriginEndpointRequest request) {
        return this.deleteOriginEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteOriginEndpointResult> deleteOriginEndpointAsync(DeleteOriginEndpointRequest request, final AsyncHandler<DeleteOriginEndpointRequest, DeleteOriginEndpointResult> asyncHandler) {
        final DeleteOriginEndpointRequest finalRequest = (DeleteOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteOriginEndpointResult>(){

            @Override
            public DeleteOriginEndpointResult call() throws Exception {
                DeleteOriginEndpointResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeDeleteOriginEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteOriginEndpointPolicyResult> deleteOriginEndpointPolicyAsync(DeleteOriginEndpointPolicyRequest request) {
        return this.deleteOriginEndpointPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteOriginEndpointPolicyResult> deleteOriginEndpointPolicyAsync(DeleteOriginEndpointPolicyRequest request, final AsyncHandler<DeleteOriginEndpointPolicyRequest, DeleteOriginEndpointPolicyResult> asyncHandler) {
        final DeleteOriginEndpointPolicyRequest finalRequest = (DeleteOriginEndpointPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteOriginEndpointPolicyResult>(){

            @Override
            public DeleteOriginEndpointPolicyResult call() throws Exception {
                DeleteOriginEndpointPolicyResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeDeleteOriginEndpointPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChannelResult> getChannelAsync(GetChannelRequest request) {
        return this.getChannelAsync(request, null);
    }

    @Override
    public Future<GetChannelResult> getChannelAsync(GetChannelRequest request, final AsyncHandler<GetChannelRequest, GetChannelResult> asyncHandler) {
        final GetChannelRequest finalRequest = (GetChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetChannelResult>(){

            @Override
            public GetChannelResult call() throws Exception {
                GetChannelResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeGetChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChannelGroupResult> getChannelGroupAsync(GetChannelGroupRequest request) {
        return this.getChannelGroupAsync(request, null);
    }

    @Override
    public Future<GetChannelGroupResult> getChannelGroupAsync(GetChannelGroupRequest request, final AsyncHandler<GetChannelGroupRequest, GetChannelGroupResult> asyncHandler) {
        final GetChannelGroupRequest finalRequest = (GetChannelGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetChannelGroupResult>(){

            @Override
            public GetChannelGroupResult call() throws Exception {
                GetChannelGroupResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeGetChannelGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChannelPolicyResult> getChannelPolicyAsync(GetChannelPolicyRequest request) {
        return this.getChannelPolicyAsync(request, null);
    }

    @Override
    public Future<GetChannelPolicyResult> getChannelPolicyAsync(GetChannelPolicyRequest request, final AsyncHandler<GetChannelPolicyRequest, GetChannelPolicyResult> asyncHandler) {
        final GetChannelPolicyRequest finalRequest = (GetChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetChannelPolicyResult>(){

            @Override
            public GetChannelPolicyResult call() throws Exception {
                GetChannelPolicyResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeGetChannelPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOriginEndpointResult> getOriginEndpointAsync(GetOriginEndpointRequest request) {
        return this.getOriginEndpointAsync(request, null);
    }

    @Override
    public Future<GetOriginEndpointResult> getOriginEndpointAsync(GetOriginEndpointRequest request, final AsyncHandler<GetOriginEndpointRequest, GetOriginEndpointResult> asyncHandler) {
        final GetOriginEndpointRequest finalRequest = (GetOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOriginEndpointResult>(){

            @Override
            public GetOriginEndpointResult call() throws Exception {
                GetOriginEndpointResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeGetOriginEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOriginEndpointPolicyResult> getOriginEndpointPolicyAsync(GetOriginEndpointPolicyRequest request) {
        return this.getOriginEndpointPolicyAsync(request, null);
    }

    @Override
    public Future<GetOriginEndpointPolicyResult> getOriginEndpointPolicyAsync(GetOriginEndpointPolicyRequest request, final AsyncHandler<GetOriginEndpointPolicyRequest, GetOriginEndpointPolicyResult> asyncHandler) {
        final GetOriginEndpointPolicyRequest finalRequest = (GetOriginEndpointPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOriginEndpointPolicyResult>(){

            @Override
            public GetOriginEndpointPolicyResult call() throws Exception {
                GetOriginEndpointPolicyResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeGetOriginEndpointPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChannelGroupsResult> listChannelGroupsAsync(ListChannelGroupsRequest request) {
        return this.listChannelGroupsAsync(request, null);
    }

    @Override
    public Future<ListChannelGroupsResult> listChannelGroupsAsync(ListChannelGroupsRequest request, final AsyncHandler<ListChannelGroupsRequest, ListChannelGroupsResult> asyncHandler) {
        final ListChannelGroupsRequest finalRequest = (ListChannelGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChannelGroupsResult>(){

            @Override
            public ListChannelGroupsResult call() throws Exception {
                ListChannelGroupsResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeListChannelGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request) {
        return this.listChannelsAsync(request, null);
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request, final AsyncHandler<ListChannelsRequest, ListChannelsResult> asyncHandler) {
        final ListChannelsRequest finalRequest = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChannelsResult>(){

            @Override
            public ListChannelsResult call() throws Exception {
                ListChannelsResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeListChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOriginEndpointsResult> listOriginEndpointsAsync(ListOriginEndpointsRequest request) {
        return this.listOriginEndpointsAsync(request, null);
    }

    @Override
    public Future<ListOriginEndpointsResult> listOriginEndpointsAsync(ListOriginEndpointsRequest request, final AsyncHandler<ListOriginEndpointsRequest, ListOriginEndpointsResult> asyncHandler) {
        final ListOriginEndpointsRequest finalRequest = (ListOriginEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOriginEndpointsResult>(){

            @Override
            public ListOriginEndpointsResult call() throws Exception {
                ListOriginEndpointsResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeListOriginEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutChannelPolicyResult> putChannelPolicyAsync(PutChannelPolicyRequest request) {
        return this.putChannelPolicyAsync(request, null);
    }

    @Override
    public Future<PutChannelPolicyResult> putChannelPolicyAsync(PutChannelPolicyRequest request, final AsyncHandler<PutChannelPolicyRequest, PutChannelPolicyResult> asyncHandler) {
        final PutChannelPolicyRequest finalRequest = (PutChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutChannelPolicyResult>(){

            @Override
            public PutChannelPolicyResult call() throws Exception {
                PutChannelPolicyResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executePutChannelPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutOriginEndpointPolicyResult> putOriginEndpointPolicyAsync(PutOriginEndpointPolicyRequest request) {
        return this.putOriginEndpointPolicyAsync(request, null);
    }

    @Override
    public Future<PutOriginEndpointPolicyResult> putOriginEndpointPolicyAsync(PutOriginEndpointPolicyRequest request, final AsyncHandler<PutOriginEndpointPolicyRequest, PutOriginEndpointPolicyResult> asyncHandler) {
        final PutOriginEndpointPolicyRequest finalRequest = (PutOriginEndpointPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutOriginEndpointPolicyResult>(){

            @Override
            public PutOriginEndpointPolicyResult call() throws Exception {
                PutOriginEndpointPolicyResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executePutOriginEndpointPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelAsync(request, null);
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request, final AsyncHandler<UpdateChannelRequest, UpdateChannelResult> asyncHandler) {
        final UpdateChannelRequest finalRequest = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChannelResult>(){

            @Override
            public UpdateChannelResult call() throws Exception {
                UpdateChannelResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeUpdateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChannelGroupResult> updateChannelGroupAsync(UpdateChannelGroupRequest request) {
        return this.updateChannelGroupAsync(request, null);
    }

    @Override
    public Future<UpdateChannelGroupResult> updateChannelGroupAsync(UpdateChannelGroupRequest request, final AsyncHandler<UpdateChannelGroupRequest, UpdateChannelGroupResult> asyncHandler) {
        final UpdateChannelGroupRequest finalRequest = (UpdateChannelGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChannelGroupResult>(){

            @Override
            public UpdateChannelGroupResult call() throws Exception {
                UpdateChannelGroupResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeUpdateChannelGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateOriginEndpointResult> updateOriginEndpointAsync(UpdateOriginEndpointRequest request) {
        return this.updateOriginEndpointAsync(request, null);
    }

    @Override
    public Future<UpdateOriginEndpointResult> updateOriginEndpointAsync(UpdateOriginEndpointRequest request, final AsyncHandler<UpdateOriginEndpointRequest, UpdateOriginEndpointResult> asyncHandler) {
        final UpdateOriginEndpointRequest finalRequest = (UpdateOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateOriginEndpointResult>(){

            @Override
            public UpdateOriginEndpointResult call() throws Exception {
                UpdateOriginEndpointResult result = null;
                try {
                    result = AWSMediaPackageV2AsyncClient.this.executeUpdateOriginEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

