/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.medialive.model.Thumbnail;
import java.util.Date;

@SdkInternalApi
public class ThumbnailMarshaller {
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("body").build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentType").build();
    private static final MarshallingInfo<String> THUMBNAILTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thumbnailType").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeStamp").timestampFormat("iso8601").build();
    private static final ThumbnailMarshaller instance = new ThumbnailMarshaller();

    public static ThumbnailMarshaller getInstance() {
        return instance;
    }

    public void marshall(Thumbnail thumbnail, ProtocolMarshaller protocolMarshaller) {
        if (thumbnail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)thumbnail.getBody(), BODY_BINDING);
            protocolMarshaller.marshall((Object)thumbnail.getContentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)thumbnail.getThumbnailType(), THUMBNAILTYPE_BINDING);
            protocolMarshaller.marshall((Object)thumbnail.getTimeStamp(), TIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

