/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.ThumbnailType;
import com.amazonaws.services.medialive.model.transform.ThumbnailMarshaller;
import java.io.Serializable;
import java.util.Date;

public class Thumbnail
implements Serializable,
Cloneable,
StructuredPojo {
    private String body;
    private String contentType;
    private String thumbnailType;
    private Date timeStamp;

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public Thumbnail withBody(String body) {
        this.setBody(body);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Thumbnail withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public void setThumbnailType(String thumbnailType) {
        this.thumbnailType = thumbnailType;
    }

    public String getThumbnailType() {
        return this.thumbnailType;
    }

    public Thumbnail withThumbnailType(String thumbnailType) {
        this.setThumbnailType(thumbnailType);
        return this;
    }

    public Thumbnail withThumbnailType(ThumbnailType thumbnailType) {
        this.thumbnailType = thumbnailType.toString();
        return this;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Thumbnail withTimeStamp(Date timeStamp) {
        this.setTimeStamp(timeStamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getThumbnailType() != null) {
            sb.append("ThumbnailType: ").append(this.getThumbnailType()).append(",");
        }
        if (this.getTimeStamp() != null) {
            sb.append("TimeStamp: ").append(this.getTimeStamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Thumbnail)) {
            return false;
        }
        Thumbnail other = (Thumbnail)obj;
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getThumbnailType() == null ^ this.getThumbnailType() == null) {
            return false;
        }
        if (other.getThumbnailType() != null && !other.getThumbnailType().equals(this.getThumbnailType())) {
            return false;
        }
        if (other.getTimeStamp() == null ^ this.getTimeStamp() == null) {
            return false;
        }
        return other.getTimeStamp() == null || other.getTimeStamp().equals(this.getTimeStamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getThumbnailType() == null ? 0 : this.getThumbnailType().hashCode());
        hashCode = 31 * hashCode + (this.getTimeStamp() == null ? 0 : this.getTimeStamp().hashCode());
        return hashCode;
    }

    public Thumbnail clone() {
        try {
            return (Thumbnail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThumbnailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

