/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.AudioChannelMapping;
import com.amazonaws.services.medialive.model.transform.RemixSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemixSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AudioChannelMapping> channelMappings;
    private Integer channelsIn;
    private Integer channelsOut;

    public List<AudioChannelMapping> getChannelMappings() {
        return this.channelMappings;
    }

    public void setChannelMappings(Collection<AudioChannelMapping> channelMappings) {
        if (channelMappings == null) {
            this.channelMappings = null;
            return;
        }
        this.channelMappings = new ArrayList<AudioChannelMapping>(channelMappings);
    }

    public RemixSettings withChannelMappings(AudioChannelMapping ... channelMappings) {
        if (this.channelMappings == null) {
            this.setChannelMappings(new ArrayList<AudioChannelMapping>(channelMappings.length));
        }
        for (AudioChannelMapping ele : channelMappings) {
            this.channelMappings.add(ele);
        }
        return this;
    }

    public RemixSettings withChannelMappings(Collection<AudioChannelMapping> channelMappings) {
        this.setChannelMappings(channelMappings);
        return this;
    }

    public void setChannelsIn(Integer channelsIn) {
        this.channelsIn = channelsIn;
    }

    public Integer getChannelsIn() {
        return this.channelsIn;
    }

    public RemixSettings withChannelsIn(Integer channelsIn) {
        this.setChannelsIn(channelsIn);
        return this;
    }

    public void setChannelsOut(Integer channelsOut) {
        this.channelsOut = channelsOut;
    }

    public Integer getChannelsOut() {
        return this.channelsOut;
    }

    public RemixSettings withChannelsOut(Integer channelsOut) {
        this.setChannelsOut(channelsOut);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannelMappings() != null) {
            sb.append("ChannelMappings: ").append(this.getChannelMappings()).append(",");
        }
        if (this.getChannelsIn() != null) {
            sb.append("ChannelsIn: ").append(this.getChannelsIn()).append(",");
        }
        if (this.getChannelsOut() != null) {
            sb.append("ChannelsOut: ").append(this.getChannelsOut());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemixSettings)) {
            return false;
        }
        RemixSettings other = (RemixSettings)obj;
        if (other.getChannelMappings() == null ^ this.getChannelMappings() == null) {
            return false;
        }
        if (other.getChannelMappings() != null && !other.getChannelMappings().equals(this.getChannelMappings())) {
            return false;
        }
        if (other.getChannelsIn() == null ^ this.getChannelsIn() == null) {
            return false;
        }
        if (other.getChannelsIn() != null && !other.getChannelsIn().equals(this.getChannelsIn())) {
            return false;
        }
        if (other.getChannelsOut() == null ^ this.getChannelsOut() == null) {
            return false;
        }
        return other.getChannelsOut() == null || other.getChannelsOut().equals(this.getChannelsOut());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannelMappings() == null ? 0 : this.getChannelMappings().hashCode());
        hashCode = 31 * hashCode + (this.getChannelsIn() == null ? 0 : this.getChannelsIn().hashCode());
        hashCode = 31 * hashCode + (this.getChannelsOut() == null ? 0 : this.getChannelsOut().hashCode());
        return hashCode;
    }

    public RemixSettings clone() {
        try {
            return (RemixSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemixSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

