/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.medialive.AWSMediaLive;
import com.amazonaws.services.medialive.model.DescribeChannelRequest;
import com.amazonaws.services.medialive.waiters.ChannelCreated;
import com.amazonaws.services.medialive.waiters.ChannelDeleted;
import com.amazonaws.services.medialive.waiters.ChannelRunning;
import com.amazonaws.services.medialive.waiters.ChannelStopped;
import com.amazonaws.services.medialive.waiters.DescribeChannelFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpFailureStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;

public class AWSMediaLiveWaiters {
    private final AWSMediaLive client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSMediaLiveWaiters");

    @SdkInternalApi
    public AWSMediaLiveWaiters(AWSMediaLive client) {
        this.client = client;
    }

    public Waiter<DescribeChannelRequest> channelCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeChannelFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ChannelCreated.IsIDLEMatcher(), new ChannelCreated.IsCREATINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY), new ChannelCreated.IsCREATE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(5), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeChannelRequest> channelStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeChannelFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ChannelStopped.IsIDLEMatcher(), new ChannelStopped.IsSTOPPINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY)}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(28), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeChannelRequest> channelRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeChannelFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ChannelRunning.IsRUNNINGMatcher(), new ChannelRunning.IsSTARTINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY)}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeChannelRequest> channelDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeChannelFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ChannelDeleted.IsDELETEDMatcher(), new ChannelDeleted.IsDELETINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY)}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

