/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.InputDestination;
import com.amazonaws.services.medialive.model.InputSource;
import com.amazonaws.services.medialive.model.InputState;
import com.amazonaws.services.medialive.model.InputType;
import com.amazonaws.services.medialive.model.MediaConnectFlow;
import com.amazonaws.services.medialive.model.transform.InputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Input
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private List<String> attachedChannels;
    private List<InputDestination> destinations;
    private String id;
    private List<MediaConnectFlow> mediaConnectFlows;
    private String name;
    private String roleArn;
    private List<String> securityGroups;
    private List<InputSource> sources;
    private String state;
    private String type;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Input withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<String> getAttachedChannels() {
        return this.attachedChannels;
    }

    public void setAttachedChannels(Collection<String> attachedChannels) {
        if (attachedChannels == null) {
            this.attachedChannels = null;
            return;
        }
        this.attachedChannels = new ArrayList<String>(attachedChannels);
    }

    public Input withAttachedChannels(String ... attachedChannels) {
        if (this.attachedChannels == null) {
            this.setAttachedChannels(new ArrayList<String>(attachedChannels.length));
        }
        for (String ele : attachedChannels) {
            this.attachedChannels.add(ele);
        }
        return this;
    }

    public Input withAttachedChannels(Collection<String> attachedChannels) {
        this.setAttachedChannels(attachedChannels);
        return this;
    }

    public List<InputDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<InputDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<InputDestination>(destinations);
    }

    public Input withDestinations(InputDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<InputDestination>(destinations.length));
        }
        for (InputDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public Input withDestinations(Collection<InputDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Input withId(String id) {
        this.setId(id);
        return this;
    }

    public List<MediaConnectFlow> getMediaConnectFlows() {
        return this.mediaConnectFlows;
    }

    public void setMediaConnectFlows(Collection<MediaConnectFlow> mediaConnectFlows) {
        if (mediaConnectFlows == null) {
            this.mediaConnectFlows = null;
            return;
        }
        this.mediaConnectFlows = new ArrayList<MediaConnectFlow>(mediaConnectFlows);
    }

    public Input withMediaConnectFlows(MediaConnectFlow ... mediaConnectFlows) {
        if (this.mediaConnectFlows == null) {
            this.setMediaConnectFlows(new ArrayList<MediaConnectFlow>(mediaConnectFlows.length));
        }
        for (MediaConnectFlow ele : mediaConnectFlows) {
            this.mediaConnectFlows.add(ele);
        }
        return this;
    }

    public Input withMediaConnectFlows(Collection<MediaConnectFlow> mediaConnectFlows) {
        this.setMediaConnectFlows(mediaConnectFlows);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Input withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public Input withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<String>(securityGroups);
    }

    public Input withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public Input withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public List<InputSource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<InputSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<InputSource>(sources);
    }

    public Input withSources(InputSource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<InputSource>(sources.length));
        }
        for (InputSource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public Input withSources(Collection<InputSource> sources) {
        this.setSources(sources);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Input withState(String state) {
        this.setState(state);
        return this;
    }

    public Input withState(InputState state) {
        this.state = state.toString();
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Input withType(String type) {
        this.setType(type);
        return this;
    }

    public Input withType(InputType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAttachedChannels() != null) {
            sb.append("AttachedChannels: ").append(this.getAttachedChannels()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getMediaConnectFlows() != null) {
            sb.append("MediaConnectFlows: ").append(this.getMediaConnectFlows()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAttachedChannels() == null ^ this.getAttachedChannels() == null) {
            return false;
        }
        if (other.getAttachedChannels() != null && !other.getAttachedChannels().equals(this.getAttachedChannels())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getMediaConnectFlows() == null ^ this.getMediaConnectFlows() == null) {
            return false;
        }
        if (other.getMediaConnectFlows() != null && !other.getMediaConnectFlows().equals(this.getMediaConnectFlows())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAttachedChannels() == null ? 0 : this.getAttachedChannels().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getMediaConnectFlows() == null ? 0 : this.getMediaConnectFlows().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public Input clone() {
        try {
            return (Input)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

