/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.CaptionLanguageMapping;
import com.amazonaws.services.medialive.model.HlsAdMarkers;
import com.amazonaws.services.medialive.model.HlsCaptionLanguageSetting;
import com.amazonaws.services.medialive.model.HlsCdnSettings;
import com.amazonaws.services.medialive.model.HlsClientCache;
import com.amazonaws.services.medialive.model.HlsCodecSpecification;
import com.amazonaws.services.medialive.model.HlsDirectoryStructure;
import com.amazonaws.services.medialive.model.HlsEncryptionType;
import com.amazonaws.services.medialive.model.HlsIvInManifest;
import com.amazonaws.services.medialive.model.HlsIvSource;
import com.amazonaws.services.medialive.model.HlsManifestCompression;
import com.amazonaws.services.medialive.model.HlsManifestDurationFormat;
import com.amazonaws.services.medialive.model.HlsMode;
import com.amazonaws.services.medialive.model.HlsOutputSelection;
import com.amazonaws.services.medialive.model.HlsProgramDateTime;
import com.amazonaws.services.medialive.model.HlsRedundantManifest;
import com.amazonaws.services.medialive.model.HlsSegmentationMode;
import com.amazonaws.services.medialive.model.HlsStreamInfResolution;
import com.amazonaws.services.medialive.model.HlsTimedMetadataId3Frame;
import com.amazonaws.services.medialive.model.HlsTsFileMode;
import com.amazonaws.services.medialive.model.InputLossActionForHlsOut;
import com.amazonaws.services.medialive.model.KeyProviderSettings;
import com.amazonaws.services.medialive.model.OutputLocationRef;
import com.amazonaws.services.medialive.model.transform.HlsGroupSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HlsGroupSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> adMarkers;
    private String baseUrlContent;
    private String baseUrlManifest;
    private List<CaptionLanguageMapping> captionLanguageMappings;
    private String captionLanguageSetting;
    private String clientCache;
    private String codecSpecification;
    private String constantIv;
    private OutputLocationRef destination;
    private String directoryStructure;
    private String encryptionType;
    private HlsCdnSettings hlsCdnSettings;
    private Integer indexNSegments;
    private String inputLossAction;
    private String ivInManifest;
    private String ivSource;
    private Integer keepSegments;
    private String keyFormat;
    private String keyFormatVersions;
    private KeyProviderSettings keyProviderSettings;
    private String manifestCompression;
    private String manifestDurationFormat;
    private Integer minSegmentLength;
    private String mode;
    private String outputSelection;
    private String programDateTime;
    private Integer programDateTimePeriod;
    private String redundantManifest;
    private Integer segmentLength;
    private String segmentationMode;
    private Integer segmentsPerSubdirectory;
    private String streamInfResolution;
    private String timedMetadataId3Frame;
    private Integer timedMetadataId3Period;
    private Integer timestampDeltaMilliseconds;
    private String tsFileMode;

    public List<String> getAdMarkers() {
        return this.adMarkers;
    }

    public void setAdMarkers(Collection<String> adMarkers) {
        if (adMarkers == null) {
            this.adMarkers = null;
            return;
        }
        this.adMarkers = new ArrayList<String>(adMarkers);
    }

    public HlsGroupSettings withAdMarkers(String ... adMarkers) {
        if (this.adMarkers == null) {
            this.setAdMarkers(new ArrayList<String>(adMarkers.length));
        }
        for (String ele : adMarkers) {
            this.adMarkers.add(ele);
        }
        return this;
    }

    public HlsGroupSettings withAdMarkers(Collection<String> adMarkers) {
        this.setAdMarkers(adMarkers);
        return this;
    }

    public HlsGroupSettings withAdMarkers(HlsAdMarkers ... adMarkers) {
        ArrayList<String> adMarkersCopy = new ArrayList<String>(adMarkers.length);
        for (HlsAdMarkers value : adMarkers) {
            adMarkersCopy.add(value.toString());
        }
        if (this.getAdMarkers() == null) {
            this.setAdMarkers(adMarkersCopy);
        } else {
            this.getAdMarkers().addAll(adMarkersCopy);
        }
        return this;
    }

    public void setBaseUrlContent(String baseUrlContent) {
        this.baseUrlContent = baseUrlContent;
    }

    public String getBaseUrlContent() {
        return this.baseUrlContent;
    }

    public HlsGroupSettings withBaseUrlContent(String baseUrlContent) {
        this.setBaseUrlContent(baseUrlContent);
        return this;
    }

    public void setBaseUrlManifest(String baseUrlManifest) {
        this.baseUrlManifest = baseUrlManifest;
    }

    public String getBaseUrlManifest() {
        return this.baseUrlManifest;
    }

    public HlsGroupSettings withBaseUrlManifest(String baseUrlManifest) {
        this.setBaseUrlManifest(baseUrlManifest);
        return this;
    }

    public List<CaptionLanguageMapping> getCaptionLanguageMappings() {
        return this.captionLanguageMappings;
    }

    public void setCaptionLanguageMappings(Collection<CaptionLanguageMapping> captionLanguageMappings) {
        if (captionLanguageMappings == null) {
            this.captionLanguageMappings = null;
            return;
        }
        this.captionLanguageMappings = new ArrayList<CaptionLanguageMapping>(captionLanguageMappings);
    }

    public HlsGroupSettings withCaptionLanguageMappings(CaptionLanguageMapping ... captionLanguageMappings) {
        if (this.captionLanguageMappings == null) {
            this.setCaptionLanguageMappings(new ArrayList<CaptionLanguageMapping>(captionLanguageMappings.length));
        }
        for (CaptionLanguageMapping ele : captionLanguageMappings) {
            this.captionLanguageMappings.add(ele);
        }
        return this;
    }

    public HlsGroupSettings withCaptionLanguageMappings(Collection<CaptionLanguageMapping> captionLanguageMappings) {
        this.setCaptionLanguageMappings(captionLanguageMappings);
        return this;
    }

    public void setCaptionLanguageSetting(String captionLanguageSetting) {
        this.captionLanguageSetting = captionLanguageSetting;
    }

    public String getCaptionLanguageSetting() {
        return this.captionLanguageSetting;
    }

    public HlsGroupSettings withCaptionLanguageSetting(String captionLanguageSetting) {
        this.setCaptionLanguageSetting(captionLanguageSetting);
        return this;
    }

    public HlsGroupSettings withCaptionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
        this.captionLanguageSetting = captionLanguageSetting.toString();
        return this;
    }

    public void setClientCache(String clientCache) {
        this.clientCache = clientCache;
    }

    public String getClientCache() {
        return this.clientCache;
    }

    public HlsGroupSettings withClientCache(String clientCache) {
        this.setClientCache(clientCache);
        return this;
    }

    public HlsGroupSettings withClientCache(HlsClientCache clientCache) {
        this.clientCache = clientCache.toString();
        return this;
    }

    public void setCodecSpecification(String codecSpecification) {
        this.codecSpecification = codecSpecification;
    }

    public String getCodecSpecification() {
        return this.codecSpecification;
    }

    public HlsGroupSettings withCodecSpecification(String codecSpecification) {
        this.setCodecSpecification(codecSpecification);
        return this;
    }

    public HlsGroupSettings withCodecSpecification(HlsCodecSpecification codecSpecification) {
        this.codecSpecification = codecSpecification.toString();
        return this;
    }

    public void setConstantIv(String constantIv) {
        this.constantIv = constantIv;
    }

    public String getConstantIv() {
        return this.constantIv;
    }

    public HlsGroupSettings withConstantIv(String constantIv) {
        this.setConstantIv(constantIv);
        return this;
    }

    public void setDestination(OutputLocationRef destination) {
        this.destination = destination;
    }

    public OutputLocationRef getDestination() {
        return this.destination;
    }

    public HlsGroupSettings withDestination(OutputLocationRef destination) {
        this.setDestination(destination);
        return this;
    }

    public void setDirectoryStructure(String directoryStructure) {
        this.directoryStructure = directoryStructure;
    }

    public String getDirectoryStructure() {
        return this.directoryStructure;
    }

    public HlsGroupSettings withDirectoryStructure(String directoryStructure) {
        this.setDirectoryStructure(directoryStructure);
        return this;
    }

    public HlsGroupSettings withDirectoryStructure(HlsDirectoryStructure directoryStructure) {
        this.directoryStructure = directoryStructure.toString();
        return this;
    }

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public HlsGroupSettings withEncryptionType(String encryptionType) {
        this.setEncryptionType(encryptionType);
        return this;
    }

    public HlsGroupSettings withEncryptionType(HlsEncryptionType encryptionType) {
        this.encryptionType = encryptionType.toString();
        return this;
    }

    public void setHlsCdnSettings(HlsCdnSettings hlsCdnSettings) {
        this.hlsCdnSettings = hlsCdnSettings;
    }

    public HlsCdnSettings getHlsCdnSettings() {
        return this.hlsCdnSettings;
    }

    public HlsGroupSettings withHlsCdnSettings(HlsCdnSettings hlsCdnSettings) {
        this.setHlsCdnSettings(hlsCdnSettings);
        return this;
    }

    public void setIndexNSegments(Integer indexNSegments) {
        this.indexNSegments = indexNSegments;
    }

    public Integer getIndexNSegments() {
        return this.indexNSegments;
    }

    public HlsGroupSettings withIndexNSegments(Integer indexNSegments) {
        this.setIndexNSegments(indexNSegments);
        return this;
    }

    public void setInputLossAction(String inputLossAction) {
        this.inputLossAction = inputLossAction;
    }

    public String getInputLossAction() {
        return this.inputLossAction;
    }

    public HlsGroupSettings withInputLossAction(String inputLossAction) {
        this.setInputLossAction(inputLossAction);
        return this;
    }

    public HlsGroupSettings withInputLossAction(InputLossActionForHlsOut inputLossAction) {
        this.inputLossAction = inputLossAction.toString();
        return this;
    }

    public void setIvInManifest(String ivInManifest) {
        this.ivInManifest = ivInManifest;
    }

    public String getIvInManifest() {
        return this.ivInManifest;
    }

    public HlsGroupSettings withIvInManifest(String ivInManifest) {
        this.setIvInManifest(ivInManifest);
        return this;
    }

    public HlsGroupSettings withIvInManifest(HlsIvInManifest ivInManifest) {
        this.ivInManifest = ivInManifest.toString();
        return this;
    }

    public void setIvSource(String ivSource) {
        this.ivSource = ivSource;
    }

    public String getIvSource() {
        return this.ivSource;
    }

    public HlsGroupSettings withIvSource(String ivSource) {
        this.setIvSource(ivSource);
        return this;
    }

    public HlsGroupSettings withIvSource(HlsIvSource ivSource) {
        this.ivSource = ivSource.toString();
        return this;
    }

    public void setKeepSegments(Integer keepSegments) {
        this.keepSegments = keepSegments;
    }

    public Integer getKeepSegments() {
        return this.keepSegments;
    }

    public HlsGroupSettings withKeepSegments(Integer keepSegments) {
        this.setKeepSegments(keepSegments);
        return this;
    }

    public void setKeyFormat(String keyFormat) {
        this.keyFormat = keyFormat;
    }

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public HlsGroupSettings withKeyFormat(String keyFormat) {
        this.setKeyFormat(keyFormat);
        return this;
    }

    public void setKeyFormatVersions(String keyFormatVersions) {
        this.keyFormatVersions = keyFormatVersions;
    }

    public String getKeyFormatVersions() {
        return this.keyFormatVersions;
    }

    public HlsGroupSettings withKeyFormatVersions(String keyFormatVersions) {
        this.setKeyFormatVersions(keyFormatVersions);
        return this;
    }

    public void setKeyProviderSettings(KeyProviderSettings keyProviderSettings) {
        this.keyProviderSettings = keyProviderSettings;
    }

    public KeyProviderSettings getKeyProviderSettings() {
        return this.keyProviderSettings;
    }

    public HlsGroupSettings withKeyProviderSettings(KeyProviderSettings keyProviderSettings) {
        this.setKeyProviderSettings(keyProviderSettings);
        return this;
    }

    public void setManifestCompression(String manifestCompression) {
        this.manifestCompression = manifestCompression;
    }

    public String getManifestCompression() {
        return this.manifestCompression;
    }

    public HlsGroupSettings withManifestCompression(String manifestCompression) {
        this.setManifestCompression(manifestCompression);
        return this;
    }

    public HlsGroupSettings withManifestCompression(HlsManifestCompression manifestCompression) {
        this.manifestCompression = manifestCompression.toString();
        return this;
    }

    public void setManifestDurationFormat(String manifestDurationFormat) {
        this.manifestDurationFormat = manifestDurationFormat;
    }

    public String getManifestDurationFormat() {
        return this.manifestDurationFormat;
    }

    public HlsGroupSettings withManifestDurationFormat(String manifestDurationFormat) {
        this.setManifestDurationFormat(manifestDurationFormat);
        return this;
    }

    public HlsGroupSettings withManifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
        this.manifestDurationFormat = manifestDurationFormat.toString();
        return this;
    }

    public void setMinSegmentLength(Integer minSegmentLength) {
        this.minSegmentLength = minSegmentLength;
    }

    public Integer getMinSegmentLength() {
        return this.minSegmentLength;
    }

    public HlsGroupSettings withMinSegmentLength(Integer minSegmentLength) {
        this.setMinSegmentLength(minSegmentLength);
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public HlsGroupSettings withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public HlsGroupSettings withMode(HlsMode mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setOutputSelection(String outputSelection) {
        this.outputSelection = outputSelection;
    }

    public String getOutputSelection() {
        return this.outputSelection;
    }

    public HlsGroupSettings withOutputSelection(String outputSelection) {
        this.setOutputSelection(outputSelection);
        return this;
    }

    public HlsGroupSettings withOutputSelection(HlsOutputSelection outputSelection) {
        this.outputSelection = outputSelection.toString();
        return this;
    }

    public void setProgramDateTime(String programDateTime) {
        this.programDateTime = programDateTime;
    }

    public String getProgramDateTime() {
        return this.programDateTime;
    }

    public HlsGroupSettings withProgramDateTime(String programDateTime) {
        this.setProgramDateTime(programDateTime);
        return this;
    }

    public HlsGroupSettings withProgramDateTime(HlsProgramDateTime programDateTime) {
        this.programDateTime = programDateTime.toString();
        return this;
    }

    public void setProgramDateTimePeriod(Integer programDateTimePeriod) {
        this.programDateTimePeriod = programDateTimePeriod;
    }

    public Integer getProgramDateTimePeriod() {
        return this.programDateTimePeriod;
    }

    public HlsGroupSettings withProgramDateTimePeriod(Integer programDateTimePeriod) {
        this.setProgramDateTimePeriod(programDateTimePeriod);
        return this;
    }

    public void setRedundantManifest(String redundantManifest) {
        this.redundantManifest = redundantManifest;
    }

    public String getRedundantManifest() {
        return this.redundantManifest;
    }

    public HlsGroupSettings withRedundantManifest(String redundantManifest) {
        this.setRedundantManifest(redundantManifest);
        return this;
    }

    public HlsGroupSettings withRedundantManifest(HlsRedundantManifest redundantManifest) {
        this.redundantManifest = redundantManifest.toString();
        return this;
    }

    public void setSegmentLength(Integer segmentLength) {
        this.segmentLength = segmentLength;
    }

    public Integer getSegmentLength() {
        return this.segmentLength;
    }

    public HlsGroupSettings withSegmentLength(Integer segmentLength) {
        this.setSegmentLength(segmentLength);
        return this;
    }

    public void setSegmentationMode(String segmentationMode) {
        this.segmentationMode = segmentationMode;
    }

    public String getSegmentationMode() {
        return this.segmentationMode;
    }

    public HlsGroupSettings withSegmentationMode(String segmentationMode) {
        this.setSegmentationMode(segmentationMode);
        return this;
    }

    public HlsGroupSettings withSegmentationMode(HlsSegmentationMode segmentationMode) {
        this.segmentationMode = segmentationMode.toString();
        return this;
    }

    public void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
        this.segmentsPerSubdirectory = segmentsPerSubdirectory;
    }

    public Integer getSegmentsPerSubdirectory() {
        return this.segmentsPerSubdirectory;
    }

    public HlsGroupSettings withSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
        this.setSegmentsPerSubdirectory(segmentsPerSubdirectory);
        return this;
    }

    public void setStreamInfResolution(String streamInfResolution) {
        this.streamInfResolution = streamInfResolution;
    }

    public String getStreamInfResolution() {
        return this.streamInfResolution;
    }

    public HlsGroupSettings withStreamInfResolution(String streamInfResolution) {
        this.setStreamInfResolution(streamInfResolution);
        return this;
    }

    public HlsGroupSettings withStreamInfResolution(HlsStreamInfResolution streamInfResolution) {
        this.streamInfResolution = streamInfResolution.toString();
        return this;
    }

    public void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
        this.timedMetadataId3Frame = timedMetadataId3Frame;
    }

    public String getTimedMetadataId3Frame() {
        return this.timedMetadataId3Frame;
    }

    public HlsGroupSettings withTimedMetadataId3Frame(String timedMetadataId3Frame) {
        this.setTimedMetadataId3Frame(timedMetadataId3Frame);
        return this;
    }

    public HlsGroupSettings withTimedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
        this.timedMetadataId3Frame = timedMetadataId3Frame.toString();
        return this;
    }

    public void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
        this.timedMetadataId3Period = timedMetadataId3Period;
    }

    public Integer getTimedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public HlsGroupSettings withTimedMetadataId3Period(Integer timedMetadataId3Period) {
        this.setTimedMetadataId3Period(timedMetadataId3Period);
        return this;
    }

    public void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
        this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
    }

    public Integer getTimestampDeltaMilliseconds() {
        return this.timestampDeltaMilliseconds;
    }

    public HlsGroupSettings withTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
        this.setTimestampDeltaMilliseconds(timestampDeltaMilliseconds);
        return this;
    }

    public void setTsFileMode(String tsFileMode) {
        this.tsFileMode = tsFileMode;
    }

    public String getTsFileMode() {
        return this.tsFileMode;
    }

    public HlsGroupSettings withTsFileMode(String tsFileMode) {
        this.setTsFileMode(tsFileMode);
        return this;
    }

    public HlsGroupSettings withTsFileMode(HlsTsFileMode tsFileMode) {
        this.tsFileMode = tsFileMode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdMarkers() != null) {
            sb.append("AdMarkers: ").append(this.getAdMarkers()).append(",");
        }
        if (this.getBaseUrlContent() != null) {
            sb.append("BaseUrlContent: ").append(this.getBaseUrlContent()).append(",");
        }
        if (this.getBaseUrlManifest() != null) {
            sb.append("BaseUrlManifest: ").append(this.getBaseUrlManifest()).append(",");
        }
        if (this.getCaptionLanguageMappings() != null) {
            sb.append("CaptionLanguageMappings: ").append(this.getCaptionLanguageMappings()).append(",");
        }
        if (this.getCaptionLanguageSetting() != null) {
            sb.append("CaptionLanguageSetting: ").append(this.getCaptionLanguageSetting()).append(",");
        }
        if (this.getClientCache() != null) {
            sb.append("ClientCache: ").append(this.getClientCache()).append(",");
        }
        if (this.getCodecSpecification() != null) {
            sb.append("CodecSpecification: ").append(this.getCodecSpecification()).append(",");
        }
        if (this.getConstantIv() != null) {
            sb.append("ConstantIv: ").append(this.getConstantIv()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getDirectoryStructure() != null) {
            sb.append("DirectoryStructure: ").append(this.getDirectoryStructure()).append(",");
        }
        if (this.getEncryptionType() != null) {
            sb.append("EncryptionType: ").append(this.getEncryptionType()).append(",");
        }
        if (this.getHlsCdnSettings() != null) {
            sb.append("HlsCdnSettings: ").append(this.getHlsCdnSettings()).append(",");
        }
        if (this.getIndexNSegments() != null) {
            sb.append("IndexNSegments: ").append(this.getIndexNSegments()).append(",");
        }
        if (this.getInputLossAction() != null) {
            sb.append("InputLossAction: ").append(this.getInputLossAction()).append(",");
        }
        if (this.getIvInManifest() != null) {
            sb.append("IvInManifest: ").append(this.getIvInManifest()).append(",");
        }
        if (this.getIvSource() != null) {
            sb.append("IvSource: ").append(this.getIvSource()).append(",");
        }
        if (this.getKeepSegments() != null) {
            sb.append("KeepSegments: ").append(this.getKeepSegments()).append(",");
        }
        if (this.getKeyFormat() != null) {
            sb.append("KeyFormat: ").append(this.getKeyFormat()).append(",");
        }
        if (this.getKeyFormatVersions() != null) {
            sb.append("KeyFormatVersions: ").append(this.getKeyFormatVersions()).append(",");
        }
        if (this.getKeyProviderSettings() != null) {
            sb.append("KeyProviderSettings: ").append(this.getKeyProviderSettings()).append(",");
        }
        if (this.getManifestCompression() != null) {
            sb.append("ManifestCompression: ").append(this.getManifestCompression()).append(",");
        }
        if (this.getManifestDurationFormat() != null) {
            sb.append("ManifestDurationFormat: ").append(this.getManifestDurationFormat()).append(",");
        }
        if (this.getMinSegmentLength() != null) {
            sb.append("MinSegmentLength: ").append(this.getMinSegmentLength()).append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getOutputSelection() != null) {
            sb.append("OutputSelection: ").append(this.getOutputSelection()).append(",");
        }
        if (this.getProgramDateTime() != null) {
            sb.append("ProgramDateTime: ").append(this.getProgramDateTime()).append(",");
        }
        if (this.getProgramDateTimePeriod() != null) {
            sb.append("ProgramDateTimePeriod: ").append(this.getProgramDateTimePeriod()).append(",");
        }
        if (this.getRedundantManifest() != null) {
            sb.append("RedundantManifest: ").append(this.getRedundantManifest()).append(",");
        }
        if (this.getSegmentLength() != null) {
            sb.append("SegmentLength: ").append(this.getSegmentLength()).append(",");
        }
        if (this.getSegmentationMode() != null) {
            sb.append("SegmentationMode: ").append(this.getSegmentationMode()).append(",");
        }
        if (this.getSegmentsPerSubdirectory() != null) {
            sb.append("SegmentsPerSubdirectory: ").append(this.getSegmentsPerSubdirectory()).append(",");
        }
        if (this.getStreamInfResolution() != null) {
            sb.append("StreamInfResolution: ").append(this.getStreamInfResolution()).append(",");
        }
        if (this.getTimedMetadataId3Frame() != null) {
            sb.append("TimedMetadataId3Frame: ").append(this.getTimedMetadataId3Frame()).append(",");
        }
        if (this.getTimedMetadataId3Period() != null) {
            sb.append("TimedMetadataId3Period: ").append(this.getTimedMetadataId3Period()).append(",");
        }
        if (this.getTimestampDeltaMilliseconds() != null) {
            sb.append("TimestampDeltaMilliseconds: ").append(this.getTimestampDeltaMilliseconds()).append(",");
        }
        if (this.getTsFileMode() != null) {
            sb.append("TsFileMode: ").append(this.getTsFileMode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings)obj;
        if (other.getAdMarkers() == null ^ this.getAdMarkers() == null) {
            return false;
        }
        if (other.getAdMarkers() != null && !other.getAdMarkers().equals(this.getAdMarkers())) {
            return false;
        }
        if (other.getBaseUrlContent() == null ^ this.getBaseUrlContent() == null) {
            return false;
        }
        if (other.getBaseUrlContent() != null && !other.getBaseUrlContent().equals(this.getBaseUrlContent())) {
            return false;
        }
        if (other.getBaseUrlManifest() == null ^ this.getBaseUrlManifest() == null) {
            return false;
        }
        if (other.getBaseUrlManifest() != null && !other.getBaseUrlManifest().equals(this.getBaseUrlManifest())) {
            return false;
        }
        if (other.getCaptionLanguageMappings() == null ^ this.getCaptionLanguageMappings() == null) {
            return false;
        }
        if (other.getCaptionLanguageMappings() != null && !other.getCaptionLanguageMappings().equals(this.getCaptionLanguageMappings())) {
            return false;
        }
        if (other.getCaptionLanguageSetting() == null ^ this.getCaptionLanguageSetting() == null) {
            return false;
        }
        if (other.getCaptionLanguageSetting() != null && !other.getCaptionLanguageSetting().equals(this.getCaptionLanguageSetting())) {
            return false;
        }
        if (other.getClientCache() == null ^ this.getClientCache() == null) {
            return false;
        }
        if (other.getClientCache() != null && !other.getClientCache().equals(this.getClientCache())) {
            return false;
        }
        if (other.getCodecSpecification() == null ^ this.getCodecSpecification() == null) {
            return false;
        }
        if (other.getCodecSpecification() != null && !other.getCodecSpecification().equals(this.getCodecSpecification())) {
            return false;
        }
        if (other.getConstantIv() == null ^ this.getConstantIv() == null) {
            return false;
        }
        if (other.getConstantIv() != null && !other.getConstantIv().equals(this.getConstantIv())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getDirectoryStructure() == null ^ this.getDirectoryStructure() == null) {
            return false;
        }
        if (other.getDirectoryStructure() != null && !other.getDirectoryStructure().equals(this.getDirectoryStructure())) {
            return false;
        }
        if (other.getEncryptionType() == null ^ this.getEncryptionType() == null) {
            return false;
        }
        if (other.getEncryptionType() != null && !other.getEncryptionType().equals(this.getEncryptionType())) {
            return false;
        }
        if (other.getHlsCdnSettings() == null ^ this.getHlsCdnSettings() == null) {
            return false;
        }
        if (other.getHlsCdnSettings() != null && !other.getHlsCdnSettings().equals(this.getHlsCdnSettings())) {
            return false;
        }
        if (other.getIndexNSegments() == null ^ this.getIndexNSegments() == null) {
            return false;
        }
        if (other.getIndexNSegments() != null && !other.getIndexNSegments().equals(this.getIndexNSegments())) {
            return false;
        }
        if (other.getInputLossAction() == null ^ this.getInputLossAction() == null) {
            return false;
        }
        if (other.getInputLossAction() != null && !other.getInputLossAction().equals(this.getInputLossAction())) {
            return false;
        }
        if (other.getIvInManifest() == null ^ this.getIvInManifest() == null) {
            return false;
        }
        if (other.getIvInManifest() != null && !other.getIvInManifest().equals(this.getIvInManifest())) {
            return false;
        }
        if (other.getIvSource() == null ^ this.getIvSource() == null) {
            return false;
        }
        if (other.getIvSource() != null && !other.getIvSource().equals(this.getIvSource())) {
            return false;
        }
        if (other.getKeepSegments() == null ^ this.getKeepSegments() == null) {
            return false;
        }
        if (other.getKeepSegments() != null && !other.getKeepSegments().equals(this.getKeepSegments())) {
            return false;
        }
        if (other.getKeyFormat() == null ^ this.getKeyFormat() == null) {
            return false;
        }
        if (other.getKeyFormat() != null && !other.getKeyFormat().equals(this.getKeyFormat())) {
            return false;
        }
        if (other.getKeyFormatVersions() == null ^ this.getKeyFormatVersions() == null) {
            return false;
        }
        if (other.getKeyFormatVersions() != null && !other.getKeyFormatVersions().equals(this.getKeyFormatVersions())) {
            return false;
        }
        if (other.getKeyProviderSettings() == null ^ this.getKeyProviderSettings() == null) {
            return false;
        }
        if (other.getKeyProviderSettings() != null && !other.getKeyProviderSettings().equals(this.getKeyProviderSettings())) {
            return false;
        }
        if (other.getManifestCompression() == null ^ this.getManifestCompression() == null) {
            return false;
        }
        if (other.getManifestCompression() != null && !other.getManifestCompression().equals(this.getManifestCompression())) {
            return false;
        }
        if (other.getManifestDurationFormat() == null ^ this.getManifestDurationFormat() == null) {
            return false;
        }
        if (other.getManifestDurationFormat() != null && !other.getManifestDurationFormat().equals(this.getManifestDurationFormat())) {
            return false;
        }
        if (other.getMinSegmentLength() == null ^ this.getMinSegmentLength() == null) {
            return false;
        }
        if (other.getMinSegmentLength() != null && !other.getMinSegmentLength().equals(this.getMinSegmentLength())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getOutputSelection() == null ^ this.getOutputSelection() == null) {
            return false;
        }
        if (other.getOutputSelection() != null && !other.getOutputSelection().equals(this.getOutputSelection())) {
            return false;
        }
        if (other.getProgramDateTime() == null ^ this.getProgramDateTime() == null) {
            return false;
        }
        if (other.getProgramDateTime() != null && !other.getProgramDateTime().equals(this.getProgramDateTime())) {
            return false;
        }
        if (other.getProgramDateTimePeriod() == null ^ this.getProgramDateTimePeriod() == null) {
            return false;
        }
        if (other.getProgramDateTimePeriod() != null && !other.getProgramDateTimePeriod().equals(this.getProgramDateTimePeriod())) {
            return false;
        }
        if (other.getRedundantManifest() == null ^ this.getRedundantManifest() == null) {
            return false;
        }
        if (other.getRedundantManifest() != null && !other.getRedundantManifest().equals(this.getRedundantManifest())) {
            return false;
        }
        if (other.getSegmentLength() == null ^ this.getSegmentLength() == null) {
            return false;
        }
        if (other.getSegmentLength() != null && !other.getSegmentLength().equals(this.getSegmentLength())) {
            return false;
        }
        if (other.getSegmentationMode() == null ^ this.getSegmentationMode() == null) {
            return false;
        }
        if (other.getSegmentationMode() != null && !other.getSegmentationMode().equals(this.getSegmentationMode())) {
            return false;
        }
        if (other.getSegmentsPerSubdirectory() == null ^ this.getSegmentsPerSubdirectory() == null) {
            return false;
        }
        if (other.getSegmentsPerSubdirectory() != null && !other.getSegmentsPerSubdirectory().equals(this.getSegmentsPerSubdirectory())) {
            return false;
        }
        if (other.getStreamInfResolution() == null ^ this.getStreamInfResolution() == null) {
            return false;
        }
        if (other.getStreamInfResolution() != null && !other.getStreamInfResolution().equals(this.getStreamInfResolution())) {
            return false;
        }
        if (other.getTimedMetadataId3Frame() == null ^ this.getTimedMetadataId3Frame() == null) {
            return false;
        }
        if (other.getTimedMetadataId3Frame() != null && !other.getTimedMetadataId3Frame().equals(this.getTimedMetadataId3Frame())) {
            return false;
        }
        if (other.getTimedMetadataId3Period() == null ^ this.getTimedMetadataId3Period() == null) {
            return false;
        }
        if (other.getTimedMetadataId3Period() != null && !other.getTimedMetadataId3Period().equals(this.getTimedMetadataId3Period())) {
            return false;
        }
        if (other.getTimestampDeltaMilliseconds() == null ^ this.getTimestampDeltaMilliseconds() == null) {
            return false;
        }
        if (other.getTimestampDeltaMilliseconds() != null && !other.getTimestampDeltaMilliseconds().equals(this.getTimestampDeltaMilliseconds())) {
            return false;
        }
        if (other.getTsFileMode() == null ^ this.getTsFileMode() == null) {
            return false;
        }
        return other.getTsFileMode() == null || other.getTsFileMode().equals(this.getTsFileMode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdMarkers() == null ? 0 : this.getAdMarkers().hashCode());
        hashCode = 31 * hashCode + (this.getBaseUrlContent() == null ? 0 : this.getBaseUrlContent().hashCode());
        hashCode = 31 * hashCode + (this.getBaseUrlManifest() == null ? 0 : this.getBaseUrlManifest().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionLanguageMappings() == null ? 0 : this.getCaptionLanguageMappings().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionLanguageSetting() == null ? 0 : this.getCaptionLanguageSetting().hashCode());
        hashCode = 31 * hashCode + (this.getClientCache() == null ? 0 : this.getClientCache().hashCode());
        hashCode = 31 * hashCode + (this.getCodecSpecification() == null ? 0 : this.getCodecSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getConstantIv() == null ? 0 : this.getConstantIv().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryStructure() == null ? 0 : this.getDirectoryStructure().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionType() == null ? 0 : this.getEncryptionType().hashCode());
        hashCode = 31 * hashCode + (this.getHlsCdnSettings() == null ? 0 : this.getHlsCdnSettings().hashCode());
        hashCode = 31 * hashCode + (this.getIndexNSegments() == null ? 0 : this.getIndexNSegments().hashCode());
        hashCode = 31 * hashCode + (this.getInputLossAction() == null ? 0 : this.getInputLossAction().hashCode());
        hashCode = 31 * hashCode + (this.getIvInManifest() == null ? 0 : this.getIvInManifest().hashCode());
        hashCode = 31 * hashCode + (this.getIvSource() == null ? 0 : this.getIvSource().hashCode());
        hashCode = 31 * hashCode + (this.getKeepSegments() == null ? 0 : this.getKeepSegments().hashCode());
        hashCode = 31 * hashCode + (this.getKeyFormat() == null ? 0 : this.getKeyFormat().hashCode());
        hashCode = 31 * hashCode + (this.getKeyFormatVersions() == null ? 0 : this.getKeyFormatVersions().hashCode());
        hashCode = 31 * hashCode + (this.getKeyProviderSettings() == null ? 0 : this.getKeyProviderSettings().hashCode());
        hashCode = 31 * hashCode + (this.getManifestCompression() == null ? 0 : this.getManifestCompression().hashCode());
        hashCode = 31 * hashCode + (this.getManifestDurationFormat() == null ? 0 : this.getManifestDurationFormat().hashCode());
        hashCode = 31 * hashCode + (this.getMinSegmentLength() == null ? 0 : this.getMinSegmentLength().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getOutputSelection() == null ? 0 : this.getOutputSelection().hashCode());
        hashCode = 31 * hashCode + (this.getProgramDateTime() == null ? 0 : this.getProgramDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getProgramDateTimePeriod() == null ? 0 : this.getProgramDateTimePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getRedundantManifest() == null ? 0 : this.getRedundantManifest().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentLength() == null ? 0 : this.getSegmentLength().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentationMode() == null ? 0 : this.getSegmentationMode().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentsPerSubdirectory() == null ? 0 : this.getSegmentsPerSubdirectory().hashCode());
        hashCode = 31 * hashCode + (this.getStreamInfResolution() == null ? 0 : this.getStreamInfResolution().hashCode());
        hashCode = 31 * hashCode + (this.getTimedMetadataId3Frame() == null ? 0 : this.getTimedMetadataId3Frame().hashCode());
        hashCode = 31 * hashCode + (this.getTimedMetadataId3Period() == null ? 0 : this.getTimedMetadataId3Period().hashCode());
        hashCode = 31 * hashCode + (this.getTimestampDeltaMilliseconds() == null ? 0 : this.getTimestampDeltaMilliseconds().hashCode());
        hashCode = 31 * hashCode + (this.getTsFileMode() == null ? 0 : this.getTsFileMode().hashCode());
        return hashCode;
    }

    public HlsGroupSettings clone() {
        try {
            return (HlsGroupSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

