/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AllowedRenditionSize;
import com.amazonaws.services.mediaconvert.model.ForceIncludeRenditionSize;
import com.amazonaws.services.mediaconvert.model.MinBottomRenditionSize;
import com.amazonaws.services.mediaconvert.model.MinTopRenditionSize;
import com.amazonaws.services.mediaconvert.model.RuleType;
import com.amazonaws.services.mediaconvert.model.transform.AutomatedAbrRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutomatedAbrRule
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AllowedRenditionSize> allowedRenditions;
    private List<ForceIncludeRenditionSize> forceIncludeRenditions;
    private MinBottomRenditionSize minBottomRenditionSize;
    private MinTopRenditionSize minTopRenditionSize;
    private String type;

    public List<AllowedRenditionSize> getAllowedRenditions() {
        return this.allowedRenditions;
    }

    public void setAllowedRenditions(Collection<AllowedRenditionSize> allowedRenditions) {
        if (allowedRenditions == null) {
            this.allowedRenditions = null;
            return;
        }
        this.allowedRenditions = new ArrayList<AllowedRenditionSize>(allowedRenditions);
    }

    public AutomatedAbrRule withAllowedRenditions(AllowedRenditionSize ... allowedRenditions) {
        if (this.allowedRenditions == null) {
            this.setAllowedRenditions(new ArrayList<AllowedRenditionSize>(allowedRenditions.length));
        }
        for (AllowedRenditionSize ele : allowedRenditions) {
            this.allowedRenditions.add(ele);
        }
        return this;
    }

    public AutomatedAbrRule withAllowedRenditions(Collection<AllowedRenditionSize> allowedRenditions) {
        this.setAllowedRenditions(allowedRenditions);
        return this;
    }

    public List<ForceIncludeRenditionSize> getForceIncludeRenditions() {
        return this.forceIncludeRenditions;
    }

    public void setForceIncludeRenditions(Collection<ForceIncludeRenditionSize> forceIncludeRenditions) {
        if (forceIncludeRenditions == null) {
            this.forceIncludeRenditions = null;
            return;
        }
        this.forceIncludeRenditions = new ArrayList<ForceIncludeRenditionSize>(forceIncludeRenditions);
    }

    public AutomatedAbrRule withForceIncludeRenditions(ForceIncludeRenditionSize ... forceIncludeRenditions) {
        if (this.forceIncludeRenditions == null) {
            this.setForceIncludeRenditions(new ArrayList<ForceIncludeRenditionSize>(forceIncludeRenditions.length));
        }
        for (ForceIncludeRenditionSize ele : forceIncludeRenditions) {
            this.forceIncludeRenditions.add(ele);
        }
        return this;
    }

    public AutomatedAbrRule withForceIncludeRenditions(Collection<ForceIncludeRenditionSize> forceIncludeRenditions) {
        this.setForceIncludeRenditions(forceIncludeRenditions);
        return this;
    }

    public void setMinBottomRenditionSize(MinBottomRenditionSize minBottomRenditionSize) {
        this.minBottomRenditionSize = minBottomRenditionSize;
    }

    public MinBottomRenditionSize getMinBottomRenditionSize() {
        return this.minBottomRenditionSize;
    }

    public AutomatedAbrRule withMinBottomRenditionSize(MinBottomRenditionSize minBottomRenditionSize) {
        this.setMinBottomRenditionSize(minBottomRenditionSize);
        return this;
    }

    public void setMinTopRenditionSize(MinTopRenditionSize minTopRenditionSize) {
        this.minTopRenditionSize = minTopRenditionSize;
    }

    public MinTopRenditionSize getMinTopRenditionSize() {
        return this.minTopRenditionSize;
    }

    public AutomatedAbrRule withMinTopRenditionSize(MinTopRenditionSize minTopRenditionSize) {
        this.setMinTopRenditionSize(minTopRenditionSize);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public AutomatedAbrRule withType(String type) {
        this.setType(type);
        return this;
    }

    public AutomatedAbrRule withType(RuleType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowedRenditions() != null) {
            sb.append("AllowedRenditions: ").append(this.getAllowedRenditions()).append(",");
        }
        if (this.getForceIncludeRenditions() != null) {
            sb.append("ForceIncludeRenditions: ").append(this.getForceIncludeRenditions()).append(",");
        }
        if (this.getMinBottomRenditionSize() != null) {
            sb.append("MinBottomRenditionSize: ").append(this.getMinBottomRenditionSize()).append(",");
        }
        if (this.getMinTopRenditionSize() != null) {
            sb.append("MinTopRenditionSize: ").append(this.getMinTopRenditionSize()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedAbrRule)) {
            return false;
        }
        AutomatedAbrRule other = (AutomatedAbrRule)obj;
        if (other.getAllowedRenditions() == null ^ this.getAllowedRenditions() == null) {
            return false;
        }
        if (other.getAllowedRenditions() != null && !other.getAllowedRenditions().equals(this.getAllowedRenditions())) {
            return false;
        }
        if (other.getForceIncludeRenditions() == null ^ this.getForceIncludeRenditions() == null) {
            return false;
        }
        if (other.getForceIncludeRenditions() != null && !other.getForceIncludeRenditions().equals(this.getForceIncludeRenditions())) {
            return false;
        }
        if (other.getMinBottomRenditionSize() == null ^ this.getMinBottomRenditionSize() == null) {
            return false;
        }
        if (other.getMinBottomRenditionSize() != null && !other.getMinBottomRenditionSize().equals(this.getMinBottomRenditionSize())) {
            return false;
        }
        if (other.getMinTopRenditionSize() == null ^ this.getMinTopRenditionSize() == null) {
            return false;
        }
        if (other.getMinTopRenditionSize() != null && !other.getMinTopRenditionSize().equals(this.getMinTopRenditionSize())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowedRenditions() == null ? 0 : this.getAllowedRenditions().hashCode());
        hashCode = 31 * hashCode + (this.getForceIncludeRenditions() == null ? 0 : this.getForceIncludeRenditions().hashCode());
        hashCode = 31 * hashCode + (this.getMinBottomRenditionSize() == null ? 0 : this.getMinBottomRenditionSize().hashCode());
        hashCode = 31 * hashCode + (this.getMinTopRenditionSize() == null ? 0 : this.getMinTopRenditionSize().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public AutomatedAbrRule clone() {
        try {
            return (AutomatedAbrRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomatedAbrRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

