/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.DecryptionMode;
import com.amazonaws.services.mediaconvert.model.transform.InputDecryptionSettingsMarshaller;
import java.io.Serializable;

public class InputDecryptionSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String decryptionMode;
    private String encryptedDecryptionKey;
    private String initializationVector;
    private String kmsKeyRegion;

    public void setDecryptionMode(String decryptionMode) {
        this.decryptionMode = decryptionMode;
    }

    public String getDecryptionMode() {
        return this.decryptionMode;
    }

    public InputDecryptionSettings withDecryptionMode(String decryptionMode) {
        this.setDecryptionMode(decryptionMode);
        return this;
    }

    public InputDecryptionSettings withDecryptionMode(DecryptionMode decryptionMode) {
        this.decryptionMode = decryptionMode.toString();
        return this;
    }

    public void setEncryptedDecryptionKey(String encryptedDecryptionKey) {
        this.encryptedDecryptionKey = encryptedDecryptionKey;
    }

    public String getEncryptedDecryptionKey() {
        return this.encryptedDecryptionKey;
    }

    public InputDecryptionSettings withEncryptedDecryptionKey(String encryptedDecryptionKey) {
        this.setEncryptedDecryptionKey(encryptedDecryptionKey);
        return this;
    }

    public void setInitializationVector(String initializationVector) {
        this.initializationVector = initializationVector;
    }

    public String getInitializationVector() {
        return this.initializationVector;
    }

    public InputDecryptionSettings withInitializationVector(String initializationVector) {
        this.setInitializationVector(initializationVector);
        return this;
    }

    public void setKmsKeyRegion(String kmsKeyRegion) {
        this.kmsKeyRegion = kmsKeyRegion;
    }

    public String getKmsKeyRegion() {
        return this.kmsKeyRegion;
    }

    public InputDecryptionSettings withKmsKeyRegion(String kmsKeyRegion) {
        this.setKmsKeyRegion(kmsKeyRegion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDecryptionMode() != null) {
            sb.append("DecryptionMode: ").append(this.getDecryptionMode()).append(",");
        }
        if (this.getEncryptedDecryptionKey() != null) {
            sb.append("EncryptedDecryptionKey: ").append(this.getEncryptedDecryptionKey()).append(",");
        }
        if (this.getInitializationVector() != null) {
            sb.append("InitializationVector: ").append(this.getInitializationVector()).append(",");
        }
        if (this.getKmsKeyRegion() != null) {
            sb.append("KmsKeyRegion: ").append(this.getKmsKeyRegion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDecryptionSettings)) {
            return false;
        }
        InputDecryptionSettings other = (InputDecryptionSettings)obj;
        if (other.getDecryptionMode() == null ^ this.getDecryptionMode() == null) {
            return false;
        }
        if (other.getDecryptionMode() != null && !other.getDecryptionMode().equals(this.getDecryptionMode())) {
            return false;
        }
        if (other.getEncryptedDecryptionKey() == null ^ this.getEncryptedDecryptionKey() == null) {
            return false;
        }
        if (other.getEncryptedDecryptionKey() != null && !other.getEncryptedDecryptionKey().equals(this.getEncryptedDecryptionKey())) {
            return false;
        }
        if (other.getInitializationVector() == null ^ this.getInitializationVector() == null) {
            return false;
        }
        if (other.getInitializationVector() != null && !other.getInitializationVector().equals(this.getInitializationVector())) {
            return false;
        }
        if (other.getKmsKeyRegion() == null ^ this.getKmsKeyRegion() == null) {
            return false;
        }
        return other.getKmsKeyRegion() == null || other.getKmsKeyRegion().equals(this.getKmsKeyRegion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDecryptionMode() == null ? 0 : this.getDecryptionMode().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptedDecryptionKey() == null ? 0 : this.getEncryptedDecryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getInitializationVector() == null ? 0 : this.getInitializationVector().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyRegion() == null ? 0 : this.getKmsKeyRegion().hashCode());
        return hashCode;
    }

    public InputDecryptionSettings clone() {
        try {
            return (InputDecryptionSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDecryptionSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

