/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/PutPolicy" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutPolicyRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * A policy configures behavior that you allow or disallow for your account. For information about MediaConvert
     * policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    private Policy policy;

    /**
     * A policy configures behavior that you allow or disallow for your account. For information about MediaConvert
     * policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     * 
     * @param policy
     *        A policy configures behavior that you allow or disallow for your account. For information about
     *        MediaConvert policies, see the user guide at
     *        http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    /**
     * A policy configures behavior that you allow or disallow for your account. For information about MediaConvert
     * policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     * 
     * @return A policy configures behavior that you allow or disallow for your account. For information about
     *         MediaConvert policies, see the user guide at
     *         http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */

    public Policy getPolicy() {
        return this.policy;
    }

    /**
     * A policy configures behavior that you allow or disallow for your account. For information about MediaConvert
     * policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     * 
     * @param policy
     *        A policy configures behavior that you allow or disallow for your account. For information about
     *        MediaConvert policies, see the user guide at
     *        http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutPolicyRequest withPolicy(Policy policy) {
        setPolicy(policy);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPolicy() != null)
            sb.append("Policy: ").append(getPolicy());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutPolicyRequest == false)
            return false;
        PutPolicyRequest other = (PutPolicyRequest) obj;
        if (other.getPolicy() == null ^ this.getPolicy() == null)
            return false;
        if (other.getPolicy() != null && other.getPolicy().equals(this.getPolicy()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPolicy() == null) ? 0 : getPolicy().hashCode());
        return hashCode;
    }

    @Override
    public PutPolicyRequest clone() {
        return (PutPolicyRequest) super.clone();
    }

}
