/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * Specified video input in a template.
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/InputTemplate" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class InputTemplate implements Serializable, Cloneable, StructuredPojo {

    /**
     * Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before encoding. The
     * Advanced input filter removes more types of compression artifacts and is an improvement when compared to basic
     * Deblock and Denoise filters. To remove video compression artifacts from your input and improve the video quality:
     * Choose Enabled. Additionally, this filter can help increase the video quality of your output relative to its
     * bitrate, since noisy inputs are more complex and require more bits to encode. To help restore loss of detail after
     * applying the filter, you can optionally add texture or sharpening as an additional step. Jobs that use this
     * feature incur pro-tier pricing. To not apply advanced input filtering: Choose Disabled. Note that you can still
     * apply basic filtering with Deblock and Denoise.
     */
    private String advancedInputFilter;
    /** Optional settings for Advanced input filter when you set Advanced input filter to Enabled. */
    private AdvancedInputFilterSettings advancedInputFilterSettings;
    /**
     * Use audio selector groups to combine multiple sidecar audio inputs so that you can assign them to a single output
     * audio tab. Note that, if you're working with embedded audio, it's simpler to assign multiple input tracks into a
     * single audio selector rather than use an audio selector group.
     */
    private java.util.Map<String, AudioSelectorGroup> audioSelectorGroups;
    /**
     * Use Audio selectors to specify a track or set of tracks from the input that you will use in your outputs. You can
     * use multiple Audio selectors per input.
     */
    private java.util.Map<String, AudioSelector> audioSelectors;
    /**
     * Use captions selectors to specify the captions data from your input that you use in your outputs. You can use up
     * to 100 captions selectors per input.
     */
    private java.util.Map<String, CaptionSelector> captionSelectors;
    /**
     * Use Cropping selection to specify the video area that the service will include in the output video frame. If you
     * specify a value here, it will override any value that you specify in the output setting Cropping selection.
     */
    private Rectangle crop;
    /**
     * Enable Deblock to produce smoother motion in the output. Default is disabled. Only manually controllable for
     * MPEG2 and uncompressed video inputs.
     */
    private String deblockFilter;
    /**
     * Enable Denoise to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and
     * uncompressed video inputs.
     */
    private String denoiseFilter;
    /**
     * Use this setting only when your video source has Dolby Vision studio mastering metadata that is carried in a
     * separate XML file. Specify the Amazon S3 location for the metadata XML file. MediaConvert uses this file to
     * provide global and frame-level metadata for Dolby Vision preprocessing. When you specify a file here and your
     * input also has interleaved global and frame level metadata, MediaConvert ignores the interleaved metadata and uses
     * only the the metadata from this external XML file. Note that your IAM service role must grant MediaConvert read
     * permissions to this file. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     */
    private String dolbyVisionMetadataXml;
    /**
     * Specify whether to apply input filtering to improve the video quality of your input. To apply filtering depending
     * on your input type and quality: Choose Auto. To apply no filtering: Choose Disable. To apply filtering regardless
     * of your input type and quality: Choose Force. When you do, you must also specify a value for Filter strength.
     */
    private String filterEnable;
    /**
     * Specify the strength of the input filter. To apply an automatic amount of filtering based the compression
     * artifacts measured in your input: We recommend that you leave Filter strength blank and set Filter enable to
     * Auto. To manually apply filtering: Enter a value from 1 to 5, where 1 is the least amount of filtering and 5 is
     * the most. The value that you enter applies to the strength of the Deblock or Denoise filters, or to the strength
     * of the Advanced input filter.
     */
    private Integer filterStrength;
    /**
     * Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for
     * each input individually. This setting is disabled by default.
     */
    private ImageInserter imageInserter;
    /**
     * Contains sets of start and end times that together specify a portion of the input to be used in the outputs. If
     * you provide only a start time, the clip will be the entire input from that point to the end. If you provide only
     * an end time, it will be the entire input up to that point. When you specify more than one input clip, the
     * transcoding service creates the job outputs by stringing the clips together in the order you specify them.
     */
    private java.util.List<InputClipping> inputClippings;
    /**
     * When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF. MediaConvert
     * doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better preservation of video
     * quality when you do deinterlacing and frame rate conversion. If you don't specify, the default value is Auto. Auto
     * is the correct setting for all inputs that are not PsF. Don't set this value to PsF when your input is interlaced.
     * Doing so creates horizontal interlacing artifacts.
     */
    private String inputScanType;
    /**
     * Use Selection placement to define the video area in your output frame. The area outside of the rectangle that you
     * specify here is black. If you specify a value here, it will override any value that you specify in the output
     * setting Selection placement. If you specify a value here, this will override any AFD values in your input, even if
     * you set Respond to AFD to Respond. If you specify a value here, this will ignore anything that you specify for the
     * setting Scaling Behavior.
     */
    private Rectangle position;
    /**
     * Use Program to select a specific program from within a multi-program transport stream. Note that Quad 4K is not
     * currently supported. Default is the first program within the transport stream. If the program you specify doesn't
     * exist, the transcoding service will use this default.
     */
    private Integer programNumber;
    /**
     * Set PSI control for transport stream inputs to specify which data the demux process to scans. Ignore PSI - Scan
     * all PIDs for audio and video. Use PSI - Scan only PSI data.
     */
    private String psiControl;
    /**
     * Use this Timecode source setting, located under the input settings, to specify how the service counts input video
     * frames. This input frame count affects only the behavior of features that apply to a single input at a time, such
     * as input clipping and synchronizing some captions formats. Choose Embedded to use the timecodes in your input
     * video. Choose Start at zero to start the first frame at zero. Choose Specified start to start the first frame at
     * the timecode that you specify in the setting Start timecode. If you don't specify a value for Timecode source, the
     * service will use Embedded by default. For more information about timecodes, see
     * https://docs.aws.amazon.com/console/mediaconvert/timecode.
     */
    private String timecodeSource;
    /**
     * Specify the timecode that you want the service to use for this input's initial frame. To use this setting, you
     * must set the Timecode source setting, located under the input settings, to Specified start. For more information
     * about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     */
    private String timecodeStart;
    /**
     * Input video selectors contain the video settings for the input. Each of your inputs can have up to one video
     * selector.
     */
    private VideoSelector videoSelector;

    /**
     * Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before encoding. The
     * Advanced input filter removes more types of compression artifacts and is an improvement when compared to basic
     * Deblock and Denoise filters. To remove video compression artifacts from your input and improve the video quality:
     * Choose Enabled. Additionally, this filter can help increase the video quality of your output relative to its
     * bitrate, since noisy inputs are more complex and require more bits to encode. To help restore loss of detail after
     * applying the filter, you can optionally add texture or sharpening as an additional step. Jobs that use this
     * feature incur pro-tier pricing. To not apply advanced input filtering: Choose Disabled. Note that you can still
     * apply basic filtering with Deblock and Denoise.
     * 
     * @param advancedInputFilter
     *        Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before
     *        encoding. The Advanced input filter removes more types of compression artifacts and is an improvement when
     *        compared to basic Deblock and Denoise filters. To remove video compression artifacts from your input and
     *        improve the video quality: Choose Enabled. Additionally, this filter can help increase the video quality
     *        of your output relative to its bitrate, since noisy inputs are more complex and require more bits to
     *        encode. To help restore loss of detail after applying the filter, you can optionally add texture or
     *        sharpening as an additional step. Jobs that use this feature incur pro-tier pricing. To not apply advanced
     *        input filtering: Choose Disabled. Note that you can still apply basic filtering with Deblock and Denoise.
     * @see AdvancedInputFilter
     */

    public void setAdvancedInputFilter(String advancedInputFilter) {
        this.advancedInputFilter = advancedInputFilter;
    }

    /**
     * Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before encoding. The
     * Advanced input filter removes more types of compression artifacts and is an improvement when compared to basic
     * Deblock and Denoise filters. To remove video compression artifacts from your input and improve the video quality:
     * Choose Enabled. Additionally, this filter can help increase the video quality of your output relative to its
     * bitrate, since noisy inputs are more complex and require more bits to encode. To help restore loss of detail after
     * applying the filter, you can optionally add texture or sharpening as an additional step. Jobs that use this
     * feature incur pro-tier pricing. To not apply advanced input filtering: Choose Disabled. Note that you can still
     * apply basic filtering with Deblock and Denoise.
     * 
     * @return Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before
     *         encoding. The Advanced input filter removes more types of compression artifacts and is an improvement
     *         when compared to basic Deblock and Denoise filters. To remove video compression artifacts from your input
     *         and improve the video quality: Choose Enabled. Additionally, this filter can help increase the video
     *         quality of your output relative to its bitrate, since noisy inputs are more complex and require more bits
     *         to encode. To help restore loss of detail after applying the filter, you can optionally add texture or
     *         sharpening as an additional step. Jobs that use this feature incur pro-tier pricing. To not apply
     *         advanced input filtering: Choose Disabled. Note that you can still apply basic filtering with Deblock and
     *         Denoise.
     * @see AdvancedInputFilter
     */

    public String getAdvancedInputFilter() {
        return this.advancedInputFilter;
    }

    /**
     * Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before encoding. The
     * Advanced input filter removes more types of compression artifacts and is an improvement when compared to basic
     * Deblock and Denoise filters. To remove video compression artifacts from your input and improve the video quality:
     * Choose Enabled. Additionally, this filter can help increase the video quality of your output relative to its
     * bitrate, since noisy inputs are more complex and require more bits to encode. To help restore loss of detail after
     * applying the filter, you can optionally add texture or sharpening as an additional step. Jobs that use this
     * feature incur pro-tier pricing. To not apply advanced input filtering: Choose Disabled. Note that you can still
     * apply basic filtering with Deblock and Denoise.
     * 
     * @param advancedInputFilter
     *        Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before
     *        encoding. The Advanced input filter removes more types of compression artifacts and is an improvement when
     *        compared to basic Deblock and Denoise filters. To remove video compression artifacts from your input and
     *        improve the video quality: Choose Enabled. Additionally, this filter can help increase the video quality
     *        of your output relative to its bitrate, since noisy inputs are more complex and require more bits to
     *        encode. To help restore loss of detail after applying the filter, you can optionally add texture or
     *        sharpening as an additional step. Jobs that use this feature incur pro-tier pricing. To not apply advanced
     *        input filtering: Choose Disabled. Note that you can still apply basic filtering with Deblock and Denoise.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AdvancedInputFilter
     */

    public InputTemplate withAdvancedInputFilter(String advancedInputFilter) {
        setAdvancedInputFilter(advancedInputFilter);
        return this;
    }

    /**
     * Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before encoding. The
     * Advanced input filter removes more types of compression artifacts and is an improvement when compared to basic
     * Deblock and Denoise filters. To remove video compression artifacts from your input and improve the video quality:
     * Choose Enabled. Additionally, this filter can help increase the video quality of your output relative to its
     * bitrate, since noisy inputs are more complex and require more bits to encode. To help restore loss of detail after
     * applying the filter, you can optionally add texture or sharpening as an additional step. Jobs that use this
     * feature incur pro-tier pricing. To not apply advanced input filtering: Choose Disabled. Note that you can still
     * apply basic filtering with Deblock and Denoise.
     * 
     * @param advancedInputFilter
     *        Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before
     *        encoding. The Advanced input filter removes more types of compression artifacts and is an improvement when
     *        compared to basic Deblock and Denoise filters. To remove video compression artifacts from your input and
     *        improve the video quality: Choose Enabled. Additionally, this filter can help increase the video quality
     *        of your output relative to its bitrate, since noisy inputs are more complex and require more bits to
     *        encode. To help restore loss of detail after applying the filter, you can optionally add texture or
     *        sharpening as an additional step. Jobs that use this feature incur pro-tier pricing. To not apply advanced
     *        input filtering: Choose Disabled. Note that you can still apply basic filtering with Deblock and Denoise.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AdvancedInputFilter
     */

    public InputTemplate withAdvancedInputFilter(AdvancedInputFilter advancedInputFilter) {
        this.advancedInputFilter = advancedInputFilter.toString();
        return this;
    }

    /**
     * Optional settings for Advanced input filter when you set Advanced input filter to Enabled.
     * 
     * @param advancedInputFilterSettings
     *        Optional settings for Advanced input filter when you set Advanced input filter to Enabled.
     */

    public void setAdvancedInputFilterSettings(AdvancedInputFilterSettings advancedInputFilterSettings) {
        this.advancedInputFilterSettings = advancedInputFilterSettings;
    }

    /**
     * Optional settings for Advanced input filter when you set Advanced input filter to Enabled.
     * 
     * @return Optional settings for Advanced input filter when you set Advanced input filter to Enabled.
     */

    public AdvancedInputFilterSettings getAdvancedInputFilterSettings() {
        return this.advancedInputFilterSettings;
    }

    /**
     * Optional settings for Advanced input filter when you set Advanced input filter to Enabled.
     * 
     * @param advancedInputFilterSettings
     *        Optional settings for Advanced input filter when you set Advanced input filter to Enabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withAdvancedInputFilterSettings(AdvancedInputFilterSettings advancedInputFilterSettings) {
        setAdvancedInputFilterSettings(advancedInputFilterSettings);
        return this;
    }

    /**
     * Use audio selector groups to combine multiple sidecar audio inputs so that you can assign them to a single output
     * audio tab. Note that, if you're working with embedded audio, it's simpler to assign multiple input tracks into a
     * single audio selector rather than use an audio selector group.
     * 
     * @return Use audio selector groups to combine multiple sidecar audio inputs so that you can assign them to a
     *         single output audio tab. Note that, if you're working with embedded audio, it's simpler to assign
     *         multiple input tracks into a single audio selector rather than use an audio selector group.
     */

    public java.util.Map<String, AudioSelectorGroup> getAudioSelectorGroups() {
        return audioSelectorGroups;
    }

    /**
     * Use audio selector groups to combine multiple sidecar audio inputs so that you can assign them to a single output
     * audio tab. Note that, if you're working with embedded audio, it's simpler to assign multiple input tracks into a
     * single audio selector rather than use an audio selector group.
     * 
     * @param audioSelectorGroups
     *        Use audio selector groups to combine multiple sidecar audio inputs so that you can assign them to a single
     *        output audio tab. Note that, if you're working with embedded audio, it's simpler to assign multiple input
     *        tracks into a single audio selector rather than use an audio selector group.
     */

    public void setAudioSelectorGroups(java.util.Map<String, AudioSelectorGroup> audioSelectorGroups) {
        this.audioSelectorGroups = audioSelectorGroups;
    }

    /**
     * Use audio selector groups to combine multiple sidecar audio inputs so that you can assign them to a single output
     * audio tab. Note that, if you're working with embedded audio, it's simpler to assign multiple input tracks into a
     * single audio selector rather than use an audio selector group.
     * 
     * @param audioSelectorGroups
     *        Use audio selector groups to combine multiple sidecar audio inputs so that you can assign them to a single
     *        output audio tab. Note that, if you're working with embedded audio, it's simpler to assign multiple input
     *        tracks into a single audio selector rather than use an audio selector group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withAudioSelectorGroups(java.util.Map<String, AudioSelectorGroup> audioSelectorGroups) {
        setAudioSelectorGroups(audioSelectorGroups);
        return this;
    }

    /**
     * Add a single AudioSelectorGroups entry
     *
     * @see InputTemplate#withAudioSelectorGroups
     * @returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate addAudioSelectorGroupsEntry(String key, AudioSelectorGroup value) {
        if (null == this.audioSelectorGroups) {
            this.audioSelectorGroups = new java.util.HashMap<String, AudioSelectorGroup>();
        }
        if (this.audioSelectorGroups.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.audioSelectorGroups.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into AudioSelectorGroups.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate clearAudioSelectorGroupsEntries() {
        this.audioSelectorGroups = null;
        return this;
    }

    /**
     * Use Audio selectors to specify a track or set of tracks from the input that you will use in your outputs. You can
     * use multiple Audio selectors per input.
     * 
     * @return Use Audio selectors to specify a track or set of tracks from the input that you will use in your outputs.
     *         You can use multiple Audio selectors per input.
     */

    public java.util.Map<String, AudioSelector> getAudioSelectors() {
        return audioSelectors;
    }

    /**
     * Use Audio selectors to specify a track or set of tracks from the input that you will use in your outputs. You can
     * use multiple Audio selectors per input.
     * 
     * @param audioSelectors
     *        Use Audio selectors to specify a track or set of tracks from the input that you will use in your outputs.
     *        You can use multiple Audio selectors per input.
     */

    public void setAudioSelectors(java.util.Map<String, AudioSelector> audioSelectors) {
        this.audioSelectors = audioSelectors;
    }

    /**
     * Use Audio selectors to specify a track or set of tracks from the input that you will use in your outputs. You can
     * use multiple Audio selectors per input.
     * 
     * @param audioSelectors
     *        Use Audio selectors to specify a track or set of tracks from the input that you will use in your outputs.
     *        You can use multiple Audio selectors per input.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withAudioSelectors(java.util.Map<String, AudioSelector> audioSelectors) {
        setAudioSelectors(audioSelectors);
        return this;
    }

    /**
     * Add a single AudioSelectors entry
     *
     * @see InputTemplate#withAudioSelectors
     * @returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate addAudioSelectorsEntry(String key, AudioSelector value) {
        if (null == this.audioSelectors) {
            this.audioSelectors = new java.util.HashMap<String, AudioSelector>();
        }
        if (this.audioSelectors.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.audioSelectors.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into AudioSelectors.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate clearAudioSelectorsEntries() {
        this.audioSelectors = null;
        return this;
    }

    /**
     * Use captions selectors to specify the captions data from your input that you use in your outputs. You can use up
     * to 100 captions selectors per input.
     * 
     * @return Use captions selectors to specify the captions data from your input that you use in your outputs. You can
     *         use up to 100 captions selectors per input.
     */

    public java.util.Map<String, CaptionSelector> getCaptionSelectors() {
        return captionSelectors;
    }

    /**
     * Use captions selectors to specify the captions data from your input that you use in your outputs. You can use up
     * to 100 captions selectors per input.
     * 
     * @param captionSelectors
     *        Use captions selectors to specify the captions data from your input that you use in your outputs. You can
     *        use up to 100 captions selectors per input.
     */

    public void setCaptionSelectors(java.util.Map<String, CaptionSelector> captionSelectors) {
        this.captionSelectors = captionSelectors;
    }

    /**
     * Use captions selectors to specify the captions data from your input that you use in your outputs. You can use up
     * to 100 captions selectors per input.
     * 
     * @param captionSelectors
     *        Use captions selectors to specify the captions data from your input that you use in your outputs. You can
     *        use up to 100 captions selectors per input.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withCaptionSelectors(java.util.Map<String, CaptionSelector> captionSelectors) {
        setCaptionSelectors(captionSelectors);
        return this;
    }

    /**
     * Add a single CaptionSelectors entry
     *
     * @see InputTemplate#withCaptionSelectors
     * @returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate addCaptionSelectorsEntry(String key, CaptionSelector value) {
        if (null == this.captionSelectors) {
            this.captionSelectors = new java.util.HashMap<String, CaptionSelector>();
        }
        if (this.captionSelectors.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.captionSelectors.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into CaptionSelectors.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate clearCaptionSelectorsEntries() {
        this.captionSelectors = null;
        return this;
    }

    /**
     * Use Cropping selection to specify the video area that the service will include in the output video frame. If you
     * specify a value here, it will override any value that you specify in the output setting Cropping selection.
     * 
     * @param crop
     *        Use Cropping selection to specify the video area that the service will include in the output video frame.
     *        If you specify a value here, it will override any value that you specify in the output setting Cropping
     *        selection.
     */

    public void setCrop(Rectangle crop) {
        this.crop = crop;
    }

    /**
     * Use Cropping selection to specify the video area that the service will include in the output video frame. If you
     * specify a value here, it will override any value that you specify in the output setting Cropping selection.
     * 
     * @return Use Cropping selection to specify the video area that the service will include in the output video frame.
     *         If you specify a value here, it will override any value that you specify in the output setting Cropping
     *         selection.
     */

    public Rectangle getCrop() {
        return this.crop;
    }

    /**
     * Use Cropping selection to specify the video area that the service will include in the output video frame. If you
     * specify a value here, it will override any value that you specify in the output setting Cropping selection.
     * 
     * @param crop
     *        Use Cropping selection to specify the video area that the service will include in the output video frame.
     *        If you specify a value here, it will override any value that you specify in the output setting Cropping
     *        selection.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withCrop(Rectangle crop) {
        setCrop(crop);
        return this;
    }

    /**
     * Enable Deblock to produce smoother motion in the output. Default is disabled. Only manually controllable for
     * MPEG2 and uncompressed video inputs.
     * 
     * @param deblockFilter
     *        Enable Deblock to produce smoother motion in the output. Default is disabled. Only manually controllable
     *        for MPEG2 and uncompressed video inputs.
     * @see InputDeblockFilter
     */

    public void setDeblockFilter(String deblockFilter) {
        this.deblockFilter = deblockFilter;
    }

    /**
     * Enable Deblock to produce smoother motion in the output. Default is disabled. Only manually controllable for
     * MPEG2 and uncompressed video inputs.
     * 
     * @return Enable Deblock to produce smoother motion in the output. Default is disabled. Only manually controllable
     *         for MPEG2 and uncompressed video inputs.
     * @see InputDeblockFilter
     */

    public String getDeblockFilter() {
        return this.deblockFilter;
    }

    /**
     * Enable Deblock to produce smoother motion in the output. Default is disabled. Only manually controllable for
     * MPEG2 and uncompressed video inputs.
     * 
     * @param deblockFilter
     *        Enable Deblock to produce smoother motion in the output. Default is disabled. Only manually controllable
     *        for MPEG2 and uncompressed video inputs.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputDeblockFilter
     */

    public InputTemplate withDeblockFilter(String deblockFilter) {
        setDeblockFilter(deblockFilter);
        return this;
    }

    /**
     * Enable Deblock to produce smoother motion in the output. Default is disabled. Only manually controllable for
     * MPEG2 and uncompressed video inputs.
     * 
     * @param deblockFilter
     *        Enable Deblock to produce smoother motion in the output. Default is disabled. Only manually controllable
     *        for MPEG2 and uncompressed video inputs.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputDeblockFilter
     */

    public InputTemplate withDeblockFilter(InputDeblockFilter deblockFilter) {
        this.deblockFilter = deblockFilter.toString();
        return this;
    }

    /**
     * Enable Denoise to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and
     * uncompressed video inputs.
     * 
     * @param denoiseFilter
     *        Enable Denoise to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264,
     *        H.265, and uncompressed video inputs.
     * @see InputDenoiseFilter
     */

    public void setDenoiseFilter(String denoiseFilter) {
        this.denoiseFilter = denoiseFilter;
    }

    /**
     * Enable Denoise to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and
     * uncompressed video inputs.
     * 
     * @return Enable Denoise to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264,
     *         H.265, and uncompressed video inputs.
     * @see InputDenoiseFilter
     */

    public String getDenoiseFilter() {
        return this.denoiseFilter;
    }

    /**
     * Enable Denoise to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and
     * uncompressed video inputs.
     * 
     * @param denoiseFilter
     *        Enable Denoise to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264,
     *        H.265, and uncompressed video inputs.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputDenoiseFilter
     */

    public InputTemplate withDenoiseFilter(String denoiseFilter) {
        setDenoiseFilter(denoiseFilter);
        return this;
    }

    /**
     * Enable Denoise to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and
     * uncompressed video inputs.
     * 
     * @param denoiseFilter
     *        Enable Denoise to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264,
     *        H.265, and uncompressed video inputs.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputDenoiseFilter
     */

    public InputTemplate withDenoiseFilter(InputDenoiseFilter denoiseFilter) {
        this.denoiseFilter = denoiseFilter.toString();
        return this;
    }

    /**
     * Use this setting only when your video source has Dolby Vision studio mastering metadata that is carried in a
     * separate XML file. Specify the Amazon S3 location for the metadata XML file. MediaConvert uses this file to
     * provide global and frame-level metadata for Dolby Vision preprocessing. When you specify a file here and your
     * input also has interleaved global and frame level metadata, MediaConvert ignores the interleaved metadata and uses
     * only the the metadata from this external XML file. Note that your IAM service role must grant MediaConvert read
     * permissions to this file. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     * 
     * @param dolbyVisionMetadataXml
     *        Use this setting only when your video source has Dolby Vision studio mastering metadata that is carried in
     *        a separate XML file. Specify the Amazon S3 location for the metadata XML file. MediaConvert uses this file
     *        to provide global and frame-level metadata for Dolby Vision preprocessing. When you specify a file here
     *        and your input also has interleaved global and frame level metadata, MediaConvert ignores the interleaved
     *        metadata and uses only the the metadata from this external XML file. Note that your IAM service role must
     *        grant MediaConvert read permissions to this file. For more information, see
     *        https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     */

    public void setDolbyVisionMetadataXml(String dolbyVisionMetadataXml) {
        this.dolbyVisionMetadataXml = dolbyVisionMetadataXml;
    }

    /**
     * Use this setting only when your video source has Dolby Vision studio mastering metadata that is carried in a
     * separate XML file. Specify the Amazon S3 location for the metadata XML file. MediaConvert uses this file to
     * provide global and frame-level metadata for Dolby Vision preprocessing. When you specify a file here and your
     * input also has interleaved global and frame level metadata, MediaConvert ignores the interleaved metadata and uses
     * only the the metadata from this external XML file. Note that your IAM service role must grant MediaConvert read
     * permissions to this file. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     * 
     * @return Use this setting only when your video source has Dolby Vision studio mastering metadata that is carried
     *         in a separate XML file. Specify the Amazon S3 location for the metadata XML file. MediaConvert uses this
     *         file to provide global and frame-level metadata for Dolby Vision preprocessing. When you specify a file
     *         here and your input also has interleaved global and frame level metadata, MediaConvert ignores the
     *         interleaved metadata and uses only the the metadata from this external XML file. Note that your IAM
     *         service role must grant MediaConvert read permissions to this file. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     */

    public String getDolbyVisionMetadataXml() {
        return this.dolbyVisionMetadataXml;
    }

    /**
     * Use this setting only when your video source has Dolby Vision studio mastering metadata that is carried in a
     * separate XML file. Specify the Amazon S3 location for the metadata XML file. MediaConvert uses this file to
     * provide global and frame-level metadata for Dolby Vision preprocessing. When you specify a file here and your
     * input also has interleaved global and frame level metadata, MediaConvert ignores the interleaved metadata and uses
     * only the the metadata from this external XML file. Note that your IAM service role must grant MediaConvert read
     * permissions to this file. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     * 
     * @param dolbyVisionMetadataXml
     *        Use this setting only when your video source has Dolby Vision studio mastering metadata that is carried in
     *        a separate XML file. Specify the Amazon S3 location for the metadata XML file. MediaConvert uses this file
     *        to provide global and frame-level metadata for Dolby Vision preprocessing. When you specify a file here
     *        and your input also has interleaved global and frame level metadata, MediaConvert ignores the interleaved
     *        metadata and uses only the the metadata from this external XML file. Note that your IAM service role must
     *        grant MediaConvert read permissions to this file. For more information, see
     *        https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withDolbyVisionMetadataXml(String dolbyVisionMetadataXml) {
        setDolbyVisionMetadataXml(dolbyVisionMetadataXml);
        return this;
    }

    /**
     * Specify whether to apply input filtering to improve the video quality of your input. To apply filtering depending
     * on your input type and quality: Choose Auto. To apply no filtering: Choose Disable. To apply filtering regardless
     * of your input type and quality: Choose Force. When you do, you must also specify a value for Filter strength.
     * 
     * @param filterEnable
     *        Specify whether to apply input filtering to improve the video quality of your input. To apply filtering
     *        depending on your input type and quality: Choose Auto. To apply no filtering: Choose Disable. To apply
     *        filtering regardless of your input type and quality: Choose Force. When you do, you must also specify a
     *        value for Filter strength.
     * @see InputFilterEnable
     */

    public void setFilterEnable(String filterEnable) {
        this.filterEnable = filterEnable;
    }

    /**
     * Specify whether to apply input filtering to improve the video quality of your input. To apply filtering depending
     * on your input type and quality: Choose Auto. To apply no filtering: Choose Disable. To apply filtering regardless
     * of your input type and quality: Choose Force. When you do, you must also specify a value for Filter strength.
     * 
     * @return Specify whether to apply input filtering to improve the video quality of your input. To apply filtering
     *         depending on your input type and quality: Choose Auto. To apply no filtering: Choose Disable. To apply
     *         filtering regardless of your input type and quality: Choose Force. When you do, you must also specify a
     *         value for Filter strength.
     * @see InputFilterEnable
     */

    public String getFilterEnable() {
        return this.filterEnable;
    }

    /**
     * Specify whether to apply input filtering to improve the video quality of your input. To apply filtering depending
     * on your input type and quality: Choose Auto. To apply no filtering: Choose Disable. To apply filtering regardless
     * of your input type and quality: Choose Force. When you do, you must also specify a value for Filter strength.
     * 
     * @param filterEnable
     *        Specify whether to apply input filtering to improve the video quality of your input. To apply filtering
     *        depending on your input type and quality: Choose Auto. To apply no filtering: Choose Disable. To apply
     *        filtering regardless of your input type and quality: Choose Force. When you do, you must also specify a
     *        value for Filter strength.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputFilterEnable
     */

    public InputTemplate withFilterEnable(String filterEnable) {
        setFilterEnable(filterEnable);
        return this;
    }

    /**
     * Specify whether to apply input filtering to improve the video quality of your input. To apply filtering depending
     * on your input type and quality: Choose Auto. To apply no filtering: Choose Disable. To apply filtering regardless
     * of your input type and quality: Choose Force. When you do, you must also specify a value for Filter strength.
     * 
     * @param filterEnable
     *        Specify whether to apply input filtering to improve the video quality of your input. To apply filtering
     *        depending on your input type and quality: Choose Auto. To apply no filtering: Choose Disable. To apply
     *        filtering regardless of your input type and quality: Choose Force. When you do, you must also specify a
     *        value for Filter strength.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputFilterEnable
     */

    public InputTemplate withFilterEnable(InputFilterEnable filterEnable) {
        this.filterEnable = filterEnable.toString();
        return this;
    }

    /**
     * Specify the strength of the input filter. To apply an automatic amount of filtering based the compression
     * artifacts measured in your input: We recommend that you leave Filter strength blank and set Filter enable to
     * Auto. To manually apply filtering: Enter a value from 1 to 5, where 1 is the least amount of filtering and 5 is
     * the most. The value that you enter applies to the strength of the Deblock or Denoise filters, or to the strength
     * of the Advanced input filter.
     * 
     * @param filterStrength
     *        Specify the strength of the input filter. To apply an automatic amount of filtering based the compression
     *        artifacts measured in your input: We recommend that you leave Filter strength blank and set Filter enable
     *        to Auto. To manually apply filtering: Enter a value from 1 to 5, where 1 is the least amount of filtering
     *        and 5 is the most. The value that you enter applies to the strength of the Deblock or Denoise filters, or
     *        to the strength of the Advanced input filter.
     */

    public void setFilterStrength(Integer filterStrength) {
        this.filterStrength = filterStrength;
    }

    /**
     * Specify the strength of the input filter. To apply an automatic amount of filtering based the compression
     * artifacts measured in your input: We recommend that you leave Filter strength blank and set Filter enable to
     * Auto. To manually apply filtering: Enter a value from 1 to 5, where 1 is the least amount of filtering and 5 is
     * the most. The value that you enter applies to the strength of the Deblock or Denoise filters, or to the strength
     * of the Advanced input filter.
     * 
     * @return Specify the strength of the input filter. To apply an automatic amount of filtering based the compression
     *         artifacts measured in your input: We recommend that you leave Filter strength blank and set Filter enable
     *         to Auto. To manually apply filtering: Enter a value from 1 to 5, where 1 is the least amount of filtering
     *         and 5 is the most. The value that you enter applies to the strength of the Deblock or Denoise filters, or
     *         to the strength of the Advanced input filter.
     */

    public Integer getFilterStrength() {
        return this.filterStrength;
    }

    /**
     * Specify the strength of the input filter. To apply an automatic amount of filtering based the compression
     * artifacts measured in your input: We recommend that you leave Filter strength blank and set Filter enable to
     * Auto. To manually apply filtering: Enter a value from 1 to 5, where 1 is the least amount of filtering and 5 is
     * the most. The value that you enter applies to the strength of the Deblock or Denoise filters, or to the strength
     * of the Advanced input filter.
     * 
     * @param filterStrength
     *        Specify the strength of the input filter. To apply an automatic amount of filtering based the compression
     *        artifacts measured in your input: We recommend that you leave Filter strength blank and set Filter enable
     *        to Auto. To manually apply filtering: Enter a value from 1 to 5, where 1 is the least amount of filtering
     *        and 5 is the most. The value that you enter applies to the strength of the Deblock or Denoise filters, or
     *        to the strength of the Advanced input filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withFilterStrength(Integer filterStrength) {
        setFilterStrength(filterStrength);
        return this;
    }

    /**
     * Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for
     * each input individually. This setting is disabled by default.
     * 
     * @param imageInserter
     *        Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this
     *        feature for each input individually. This setting is disabled by default.
     */

    public void setImageInserter(ImageInserter imageInserter) {
        this.imageInserter = imageInserter;
    }

    /**
     * Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for
     * each input individually. This setting is disabled by default.
     * 
     * @return Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this
     *         feature for each input individually. This setting is disabled by default.
     */

    public ImageInserter getImageInserter() {
        return this.imageInserter;
    }

    /**
     * Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for
     * each input individually. This setting is disabled by default.
     * 
     * @param imageInserter
     *        Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this
     *        feature for each input individually. This setting is disabled by default.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withImageInserter(ImageInserter imageInserter) {
        setImageInserter(imageInserter);
        return this;
    }

    /**
     * Contains sets of start and end times that together specify a portion of the input to be used in the outputs. If
     * you provide only a start time, the clip will be the entire input from that point to the end. If you provide only
     * an end time, it will be the entire input up to that point. When you specify more than one input clip, the
     * transcoding service creates the job outputs by stringing the clips together in the order you specify them.
     * 
     * @return Contains sets of start and end times that together specify a portion of the input to be used in the
     *         outputs. If you provide only a start time, the clip will be the entire input from that point to the end.
     *         If you provide only an end time, it will be the entire input up to that point. When you specify more than
     *         one input clip, the transcoding service creates the job outputs by stringing the clips together in the
     *         order you specify them.
     */

    public java.util.List<InputClipping> getInputClippings() {
        return inputClippings;
    }

    /**
     * Contains sets of start and end times that together specify a portion of the input to be used in the outputs. If
     * you provide only a start time, the clip will be the entire input from that point to the end. If you provide only
     * an end time, it will be the entire input up to that point. When you specify more than one input clip, the
     * transcoding service creates the job outputs by stringing the clips together in the order you specify them.
     * 
     * @param inputClippings
     *        Contains sets of start and end times that together specify a portion of the input to be used in the
     *        outputs. If you provide only a start time, the clip will be the entire input from that point to the end.
     *        If you provide only an end time, it will be the entire input up to that point. When you specify more than
     *        one input clip, the transcoding service creates the job outputs by stringing the clips together in the
     *        order you specify them.
     */

    public void setInputClippings(java.util.Collection<InputClipping> inputClippings) {
        if (inputClippings == null) {
            this.inputClippings = null;
            return;
        }

        this.inputClippings = new java.util.ArrayList<InputClipping>(inputClippings);
    }

    /**
     * Contains sets of start and end times that together specify a portion of the input to be used in the outputs. If
     * you provide only a start time, the clip will be the entire input from that point to the end. If you provide only
     * an end time, it will be the entire input up to that point. When you specify more than one input clip, the
     * transcoding service creates the job outputs by stringing the clips together in the order you specify them.
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setInputClippings(java.util.Collection)} or {@link #withInputClippings(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param inputClippings
     *        Contains sets of start and end times that together specify a portion of the input to be used in the
     *        outputs. If you provide only a start time, the clip will be the entire input from that point to the end.
     *        If you provide only an end time, it will be the entire input up to that point. When you specify more than
     *        one input clip, the transcoding service creates the job outputs by stringing the clips together in the
     *        order you specify them.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withInputClippings(InputClipping... inputClippings) {
        if (this.inputClippings == null) {
            setInputClippings(new java.util.ArrayList<InputClipping>(inputClippings.length));
        }
        for (InputClipping ele : inputClippings) {
            this.inputClippings.add(ele);
        }
        return this;
    }

    /**
     * Contains sets of start and end times that together specify a portion of the input to be used in the outputs. If
     * you provide only a start time, the clip will be the entire input from that point to the end. If you provide only
     * an end time, it will be the entire input up to that point. When you specify more than one input clip, the
     * transcoding service creates the job outputs by stringing the clips together in the order you specify them.
     * 
     * @param inputClippings
     *        Contains sets of start and end times that together specify a portion of the input to be used in the
     *        outputs. If you provide only a start time, the clip will be the entire input from that point to the end.
     *        If you provide only an end time, it will be the entire input up to that point. When you specify more than
     *        one input clip, the transcoding service creates the job outputs by stringing the clips together in the
     *        order you specify them.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withInputClippings(java.util.Collection<InputClipping> inputClippings) {
        setInputClippings(inputClippings);
        return this;
    }

    /**
     * When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF. MediaConvert
     * doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better preservation of video
     * quality when you do deinterlacing and frame rate conversion. If you don't specify, the default value is Auto. Auto
     * is the correct setting for all inputs that are not PsF. Don't set this value to PsF when your input is interlaced.
     * Doing so creates horizontal interlacing artifacts.
     * 
     * @param inputScanType
     *        When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF.
     *        MediaConvert doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better
     *        preservation of video quality when you do deinterlacing and frame rate conversion. If you don't specify,
     *        the default value is Auto. Auto is the correct setting for all inputs that are not PsF. Don't set this
     *        value to PsF when your input is interlaced. Doing so creates horizontal interlacing artifacts.
     * @see InputScanType
     */

    public void setInputScanType(String inputScanType) {
        this.inputScanType = inputScanType;
    }

    /**
     * When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF. MediaConvert
     * doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better preservation of video
     * quality when you do deinterlacing and frame rate conversion. If you don't specify, the default value is Auto. Auto
     * is the correct setting for all inputs that are not PsF. Don't set this value to PsF when your input is interlaced.
     * Doing so creates horizontal interlacing artifacts.
     * 
     * @return When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF.
     *         MediaConvert doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better
     *         preservation of video quality when you do deinterlacing and frame rate conversion. If you don't specify,
     *         the default value is Auto. Auto is the correct setting for all inputs that are not PsF. Don't set this
     *         value to PsF when your input is interlaced. Doing so creates horizontal interlacing artifacts.
     * @see InputScanType
     */

    public String getInputScanType() {
        return this.inputScanType;
    }

    /**
     * When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF. MediaConvert
     * doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better preservation of video
     * quality when you do deinterlacing and frame rate conversion. If you don't specify, the default value is Auto. Auto
     * is the correct setting for all inputs that are not PsF. Don't set this value to PsF when your input is interlaced.
     * Doing so creates horizontal interlacing artifacts.
     * 
     * @param inputScanType
     *        When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF.
     *        MediaConvert doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better
     *        preservation of video quality when you do deinterlacing and frame rate conversion. If you don't specify,
     *        the default value is Auto. Auto is the correct setting for all inputs that are not PsF. Don't set this
     *        value to PsF when your input is interlaced. Doing so creates horizontal interlacing artifacts.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputScanType
     */

    public InputTemplate withInputScanType(String inputScanType) {
        setInputScanType(inputScanType);
        return this;
    }

    /**
     * When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF. MediaConvert
     * doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better preservation of video
     * quality when you do deinterlacing and frame rate conversion. If you don't specify, the default value is Auto. Auto
     * is the correct setting for all inputs that are not PsF. Don't set this value to PsF when your input is interlaced.
     * Doing so creates horizontal interlacing artifacts.
     * 
     * @param inputScanType
     *        When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF.
     *        MediaConvert doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better
     *        preservation of video quality when you do deinterlacing and frame rate conversion. If you don't specify,
     *        the default value is Auto. Auto is the correct setting for all inputs that are not PsF. Don't set this
     *        value to PsF when your input is interlaced. Doing so creates horizontal interlacing artifacts.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputScanType
     */

    public InputTemplate withInputScanType(InputScanType inputScanType) {
        this.inputScanType = inputScanType.toString();
        return this;
    }

    /**
     * Use Selection placement to define the video area in your output frame. The area outside of the rectangle that you
     * specify here is black. If you specify a value here, it will override any value that you specify in the output
     * setting Selection placement. If you specify a value here, this will override any AFD values in your input, even if
     * you set Respond to AFD to Respond. If you specify a value here, this will ignore anything that you specify for the
     * setting Scaling Behavior.
     * 
     * @param position
     *        Use Selection placement to define the video area in your output frame. The area outside of the rectangle
     *        that you specify here is black. If you specify a value here, it will override any value that you specify
     *        in the output setting Selection placement. If you specify a value here, this will override any AFD values
     *        in your input, even if you set Respond to AFD to Respond. If you specify a value here, this will ignore
     *        anything that you specify for the setting Scaling Behavior.
     */

    public void setPosition(Rectangle position) {
        this.position = position;
    }

    /**
     * Use Selection placement to define the video area in your output frame. The area outside of the rectangle that you
     * specify here is black. If you specify a value here, it will override any value that you specify in the output
     * setting Selection placement. If you specify a value here, this will override any AFD values in your input, even if
     * you set Respond to AFD to Respond. If you specify a value here, this will ignore anything that you specify for the
     * setting Scaling Behavior.
     * 
     * @return Use Selection placement to define the video area in your output frame. The area outside of the rectangle
     *         that you specify here is black. If you specify a value here, it will override any value that you specify
     *         in the output setting Selection placement. If you specify a value here, this will override any AFD values
     *         in your input, even if you set Respond to AFD to Respond. If you specify a value here, this will ignore
     *         anything that you specify for the setting Scaling Behavior.
     */

    public Rectangle getPosition() {
        return this.position;
    }

    /**
     * Use Selection placement to define the video area in your output frame. The area outside of the rectangle that you
     * specify here is black. If you specify a value here, it will override any value that you specify in the output
     * setting Selection placement. If you specify a value here, this will override any AFD values in your input, even if
     * you set Respond to AFD to Respond. If you specify a value here, this will ignore anything that you specify for the
     * setting Scaling Behavior.
     * 
     * @param position
     *        Use Selection placement to define the video area in your output frame. The area outside of the rectangle
     *        that you specify here is black. If you specify a value here, it will override any value that you specify
     *        in the output setting Selection placement. If you specify a value here, this will override any AFD values
     *        in your input, even if you set Respond to AFD to Respond. If you specify a value here, this will ignore
     *        anything that you specify for the setting Scaling Behavior.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withPosition(Rectangle position) {
        setPosition(position);
        return this;
    }

    /**
     * Use Program to select a specific program from within a multi-program transport stream. Note that Quad 4K is not
     * currently supported. Default is the first program within the transport stream. If the program you specify doesn't
     * exist, the transcoding service will use this default.
     * 
     * @param programNumber
     *        Use Program to select a specific program from within a multi-program transport stream. Note that Quad 4K
     *        is not currently supported. Default is the first program within the transport stream. If the program you
     *        specify doesn't exist, the transcoding service will use this default.
     */

    public void setProgramNumber(Integer programNumber) {
        this.programNumber = programNumber;
    }

    /**
     * Use Program to select a specific program from within a multi-program transport stream. Note that Quad 4K is not
     * currently supported. Default is the first program within the transport stream. If the program you specify doesn't
     * exist, the transcoding service will use this default.
     * 
     * @return Use Program to select a specific program from within a multi-program transport stream. Note that Quad 4K
     *         is not currently supported. Default is the first program within the transport stream. If the program you
     *         specify doesn't exist, the transcoding service will use this default.
     */

    public Integer getProgramNumber() {
        return this.programNumber;
    }

    /**
     * Use Program to select a specific program from within a multi-program transport stream. Note that Quad 4K is not
     * currently supported. Default is the first program within the transport stream. If the program you specify doesn't
     * exist, the transcoding service will use this default.
     * 
     * @param programNumber
     *        Use Program to select a specific program from within a multi-program transport stream. Note that Quad 4K
     *        is not currently supported. Default is the first program within the transport stream. If the program you
     *        specify doesn't exist, the transcoding service will use this default.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withProgramNumber(Integer programNumber) {
        setProgramNumber(programNumber);
        return this;
    }

    /**
     * Set PSI control for transport stream inputs to specify which data the demux process to scans. Ignore PSI - Scan
     * all PIDs for audio and video. Use PSI - Scan only PSI data.
     * 
     * @param psiControl
     *        Set PSI control for transport stream inputs to specify which data the demux process to scans. Ignore PSI -
     *        Scan all PIDs for audio and video. Use PSI - Scan only PSI data.
     * @see InputPsiControl
     */

    public void setPsiControl(String psiControl) {
        this.psiControl = psiControl;
    }

    /**
     * Set PSI control for transport stream inputs to specify which data the demux process to scans. Ignore PSI - Scan
     * all PIDs for audio and video. Use PSI - Scan only PSI data.
     * 
     * @return Set PSI control for transport stream inputs to specify which data the demux process to scans. Ignore PSI
     *         - Scan all PIDs for audio and video. Use PSI - Scan only PSI data.
     * @see InputPsiControl
     */

    public String getPsiControl() {
        return this.psiControl;
    }

    /**
     * Set PSI control for transport stream inputs to specify which data the demux process to scans. Ignore PSI - Scan
     * all PIDs for audio and video. Use PSI - Scan only PSI data.
     * 
     * @param psiControl
     *        Set PSI control for transport stream inputs to specify which data the demux process to scans. Ignore PSI -
     *        Scan all PIDs for audio and video. Use PSI - Scan only PSI data.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputPsiControl
     */

    public InputTemplate withPsiControl(String psiControl) {
        setPsiControl(psiControl);
        return this;
    }

    /**
     * Set PSI control for transport stream inputs to specify which data the demux process to scans. Ignore PSI - Scan
     * all PIDs for audio and video. Use PSI - Scan only PSI data.
     * 
     * @param psiControl
     *        Set PSI control for transport stream inputs to specify which data the demux process to scans. Ignore PSI -
     *        Scan all PIDs for audio and video. Use PSI - Scan only PSI data.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputPsiControl
     */

    public InputTemplate withPsiControl(InputPsiControl psiControl) {
        this.psiControl = psiControl.toString();
        return this;
    }

    /**
     * Use this Timecode source setting, located under the input settings, to specify how the service counts input video
     * frames. This input frame count affects only the behavior of features that apply to a single input at a time, such
     * as input clipping and synchronizing some captions formats. Choose Embedded to use the timecodes in your input
     * video. Choose Start at zero to start the first frame at zero. Choose Specified start to start the first frame at
     * the timecode that you specify in the setting Start timecode. If you don't specify a value for Timecode source, the
     * service will use Embedded by default. For more information about timecodes, see
     * https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * 
     * @param timecodeSource
     *        Use this Timecode source setting, located under the input settings, to specify how the service counts
     *        input video frames. This input frame count affects only the behavior of features that apply to a single
     *        input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded to use
     *        the timecodes in your input video. Choose Start at zero to start the first frame at zero. Choose Specified
     *        start to start the first frame at the timecode that you specify in the setting Start timecode. If you
     *        don't specify a value for Timecode source, the service will use Embedded by default. For more information
     *        about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * @see InputTimecodeSource
     */

    public void setTimecodeSource(String timecodeSource) {
        this.timecodeSource = timecodeSource;
    }

    /**
     * Use this Timecode source setting, located under the input settings, to specify how the service counts input video
     * frames. This input frame count affects only the behavior of features that apply to a single input at a time, such
     * as input clipping and synchronizing some captions formats. Choose Embedded to use the timecodes in your input
     * video. Choose Start at zero to start the first frame at zero. Choose Specified start to start the first frame at
     * the timecode that you specify in the setting Start timecode. If you don't specify a value for Timecode source, the
     * service will use Embedded by default. For more information about timecodes, see
     * https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * 
     * @return Use this Timecode source setting, located under the input settings, to specify how the service counts
     *         input video frames. This input frame count affects only the behavior of features that apply to a single
     *         input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded to use
     *         the timecodes in your input video. Choose Start at zero to start the first frame at zero. Choose
     *         Specified start to start the first frame at the timecode that you specify in the setting Start timecode.
     *         If you don't specify a value for Timecode source, the service will use Embedded by default. For more
     *         information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * @see InputTimecodeSource
     */

    public String getTimecodeSource() {
        return this.timecodeSource;
    }

    /**
     * Use this Timecode source setting, located under the input settings, to specify how the service counts input video
     * frames. This input frame count affects only the behavior of features that apply to a single input at a time, such
     * as input clipping and synchronizing some captions formats. Choose Embedded to use the timecodes in your input
     * video. Choose Start at zero to start the first frame at zero. Choose Specified start to start the first frame at
     * the timecode that you specify in the setting Start timecode. If you don't specify a value for Timecode source, the
     * service will use Embedded by default. For more information about timecodes, see
     * https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * 
     * @param timecodeSource
     *        Use this Timecode source setting, located under the input settings, to specify how the service counts
     *        input video frames. This input frame count affects only the behavior of features that apply to a single
     *        input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded to use
     *        the timecodes in your input video. Choose Start at zero to start the first frame at zero. Choose Specified
     *        start to start the first frame at the timecode that you specify in the setting Start timecode. If you
     *        don't specify a value for Timecode source, the service will use Embedded by default. For more information
     *        about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputTimecodeSource
     */

    public InputTemplate withTimecodeSource(String timecodeSource) {
        setTimecodeSource(timecodeSource);
        return this;
    }

    /**
     * Use this Timecode source setting, located under the input settings, to specify how the service counts input video
     * frames. This input frame count affects only the behavior of features that apply to a single input at a time, such
     * as input clipping and synchronizing some captions formats. Choose Embedded to use the timecodes in your input
     * video. Choose Start at zero to start the first frame at zero. Choose Specified start to start the first frame at
     * the timecode that you specify in the setting Start timecode. If you don't specify a value for Timecode source, the
     * service will use Embedded by default. For more information about timecodes, see
     * https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * 
     * @param timecodeSource
     *        Use this Timecode source setting, located under the input settings, to specify how the service counts
     *        input video frames. This input frame count affects only the behavior of features that apply to a single
     *        input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded to use
     *        the timecodes in your input video. Choose Start at zero to start the first frame at zero. Choose Specified
     *        start to start the first frame at the timecode that you specify in the setting Start timecode. If you
     *        don't specify a value for Timecode source, the service will use Embedded by default. For more information
     *        about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InputTimecodeSource
     */

    public InputTemplate withTimecodeSource(InputTimecodeSource timecodeSource) {
        this.timecodeSource = timecodeSource.toString();
        return this;
    }

    /**
     * Specify the timecode that you want the service to use for this input's initial frame. To use this setting, you
     * must set the Timecode source setting, located under the input settings, to Specified start. For more information
     * about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * 
     * @param timecodeStart
     *        Specify the timecode that you want the service to use for this input's initial frame. To use this setting,
     *        you must set the Timecode source setting, located under the input settings, to Specified start. For more
     *        information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     */

    public void setTimecodeStart(String timecodeStart) {
        this.timecodeStart = timecodeStart;
    }

    /**
     * Specify the timecode that you want the service to use for this input's initial frame. To use this setting, you
     * must set the Timecode source setting, located under the input settings, to Specified start. For more information
     * about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * 
     * @return Specify the timecode that you want the service to use for this input's initial frame. To use this
     *         setting, you must set the Timecode source setting, located under the input settings, to Specified start.
     *         For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     */

    public String getTimecodeStart() {
        return this.timecodeStart;
    }

    /**
     * Specify the timecode that you want the service to use for this input's initial frame. To use this setting, you
     * must set the Timecode source setting, located under the input settings, to Specified start. For more information
     * about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * 
     * @param timecodeStart
     *        Specify the timecode that you want the service to use for this input's initial frame. To use this setting,
     *        you must set the Timecode source setting, located under the input settings, to Specified start. For more
     *        information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withTimecodeStart(String timecodeStart) {
        setTimecodeStart(timecodeStart);
        return this;
    }

    /**
     * Input video selectors contain the video settings for the input. Each of your inputs can have up to one video
     * selector.
     * 
     * @param videoSelector
     *        Input video selectors contain the video settings for the input. Each of your inputs can have up to one
     *        video selector.
     */

    public void setVideoSelector(VideoSelector videoSelector) {
        this.videoSelector = videoSelector;
    }

    /**
     * Input video selectors contain the video settings for the input. Each of your inputs can have up to one video
     * selector.
     * 
     * @return Input video selectors contain the video settings for the input. Each of your inputs can have up to one
     *         video selector.
     */

    public VideoSelector getVideoSelector() {
        return this.videoSelector;
    }

    /**
     * Input video selectors contain the video settings for the input. Each of your inputs can have up to one video
     * selector.
     * 
     * @param videoSelector
     *        Input video selectors contain the video settings for the input. Each of your inputs can have up to one
     *        video selector.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InputTemplate withVideoSelector(VideoSelector videoSelector) {
        setVideoSelector(videoSelector);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAdvancedInputFilter() != null)
            sb.append("AdvancedInputFilter: ").append(getAdvancedInputFilter()).append(",");
        if (getAdvancedInputFilterSettings() != null)
            sb.append("AdvancedInputFilterSettings: ").append(getAdvancedInputFilterSettings()).append(",");
        if (getAudioSelectorGroups() != null)
            sb.append("AudioSelectorGroups: ").append(getAudioSelectorGroups()).append(",");
        if (getAudioSelectors() != null)
            sb.append("AudioSelectors: ").append(getAudioSelectors()).append(",");
        if (getCaptionSelectors() != null)
            sb.append("CaptionSelectors: ").append(getCaptionSelectors()).append(",");
        if (getCrop() != null)
            sb.append("Crop: ").append(getCrop()).append(",");
        if (getDeblockFilter() != null)
            sb.append("DeblockFilter: ").append(getDeblockFilter()).append(",");
        if (getDenoiseFilter() != null)
            sb.append("DenoiseFilter: ").append(getDenoiseFilter()).append(",");
        if (getDolbyVisionMetadataXml() != null)
            sb.append("DolbyVisionMetadataXml: ").append(getDolbyVisionMetadataXml()).append(",");
        if (getFilterEnable() != null)
            sb.append("FilterEnable: ").append(getFilterEnable()).append(",");
        if (getFilterStrength() != null)
            sb.append("FilterStrength: ").append(getFilterStrength()).append(",");
        if (getImageInserter() != null)
            sb.append("ImageInserter: ").append(getImageInserter()).append(",");
        if (getInputClippings() != null)
            sb.append("InputClippings: ").append(getInputClippings()).append(",");
        if (getInputScanType() != null)
            sb.append("InputScanType: ").append(getInputScanType()).append(",");
        if (getPosition() != null)
            sb.append("Position: ").append(getPosition()).append(",");
        if (getProgramNumber() != null)
            sb.append("ProgramNumber: ").append(getProgramNumber()).append(",");
        if (getPsiControl() != null)
            sb.append("PsiControl: ").append(getPsiControl()).append(",");
        if (getTimecodeSource() != null)
            sb.append("TimecodeSource: ").append(getTimecodeSource()).append(",");
        if (getTimecodeStart() != null)
            sb.append("TimecodeStart: ").append(getTimecodeStart()).append(",");
        if (getVideoSelector() != null)
            sb.append("VideoSelector: ").append(getVideoSelector());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof InputTemplate == false)
            return false;
        InputTemplate other = (InputTemplate) obj;
        if (other.getAdvancedInputFilter() == null ^ this.getAdvancedInputFilter() == null)
            return false;
        if (other.getAdvancedInputFilter() != null && other.getAdvancedInputFilter().equals(this.getAdvancedInputFilter()) == false)
            return false;
        if (other.getAdvancedInputFilterSettings() == null ^ this.getAdvancedInputFilterSettings() == null)
            return false;
        if (other.getAdvancedInputFilterSettings() != null && other.getAdvancedInputFilterSettings().equals(this.getAdvancedInputFilterSettings()) == false)
            return false;
        if (other.getAudioSelectorGroups() == null ^ this.getAudioSelectorGroups() == null)
            return false;
        if (other.getAudioSelectorGroups() != null && other.getAudioSelectorGroups().equals(this.getAudioSelectorGroups()) == false)
            return false;
        if (other.getAudioSelectors() == null ^ this.getAudioSelectors() == null)
            return false;
        if (other.getAudioSelectors() != null && other.getAudioSelectors().equals(this.getAudioSelectors()) == false)
            return false;
        if (other.getCaptionSelectors() == null ^ this.getCaptionSelectors() == null)
            return false;
        if (other.getCaptionSelectors() != null && other.getCaptionSelectors().equals(this.getCaptionSelectors()) == false)
            return false;
        if (other.getCrop() == null ^ this.getCrop() == null)
            return false;
        if (other.getCrop() != null && other.getCrop().equals(this.getCrop()) == false)
            return false;
        if (other.getDeblockFilter() == null ^ this.getDeblockFilter() == null)
            return false;
        if (other.getDeblockFilter() != null && other.getDeblockFilter().equals(this.getDeblockFilter()) == false)
            return false;
        if (other.getDenoiseFilter() == null ^ this.getDenoiseFilter() == null)
            return false;
        if (other.getDenoiseFilter() != null && other.getDenoiseFilter().equals(this.getDenoiseFilter()) == false)
            return false;
        if (other.getDolbyVisionMetadataXml() == null ^ this.getDolbyVisionMetadataXml() == null)
            return false;
        if (other.getDolbyVisionMetadataXml() != null && other.getDolbyVisionMetadataXml().equals(this.getDolbyVisionMetadataXml()) == false)
            return false;
        if (other.getFilterEnable() == null ^ this.getFilterEnable() == null)
            return false;
        if (other.getFilterEnable() != null && other.getFilterEnable().equals(this.getFilterEnable()) == false)
            return false;
        if (other.getFilterStrength() == null ^ this.getFilterStrength() == null)
            return false;
        if (other.getFilterStrength() != null && other.getFilterStrength().equals(this.getFilterStrength()) == false)
            return false;
        if (other.getImageInserter() == null ^ this.getImageInserter() == null)
            return false;
        if (other.getImageInserter() != null && other.getImageInserter().equals(this.getImageInserter()) == false)
            return false;
        if (other.getInputClippings() == null ^ this.getInputClippings() == null)
            return false;
        if (other.getInputClippings() != null && other.getInputClippings().equals(this.getInputClippings()) == false)
            return false;
        if (other.getInputScanType() == null ^ this.getInputScanType() == null)
            return false;
        if (other.getInputScanType() != null && other.getInputScanType().equals(this.getInputScanType()) == false)
            return false;
        if (other.getPosition() == null ^ this.getPosition() == null)
            return false;
        if (other.getPosition() != null && other.getPosition().equals(this.getPosition()) == false)
            return false;
        if (other.getProgramNumber() == null ^ this.getProgramNumber() == null)
            return false;
        if (other.getProgramNumber() != null && other.getProgramNumber().equals(this.getProgramNumber()) == false)
            return false;
        if (other.getPsiControl() == null ^ this.getPsiControl() == null)
            return false;
        if (other.getPsiControl() != null && other.getPsiControl().equals(this.getPsiControl()) == false)
            return false;
        if (other.getTimecodeSource() == null ^ this.getTimecodeSource() == null)
            return false;
        if (other.getTimecodeSource() != null && other.getTimecodeSource().equals(this.getTimecodeSource()) == false)
            return false;
        if (other.getTimecodeStart() == null ^ this.getTimecodeStart() == null)
            return false;
        if (other.getTimecodeStart() != null && other.getTimecodeStart().equals(this.getTimecodeStart()) == false)
            return false;
        if (other.getVideoSelector() == null ^ this.getVideoSelector() == null)
            return false;
        if (other.getVideoSelector() != null && other.getVideoSelector().equals(this.getVideoSelector()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAdvancedInputFilter() == null) ? 0 : getAdvancedInputFilter().hashCode());
        hashCode = prime * hashCode + ((getAdvancedInputFilterSettings() == null) ? 0 : getAdvancedInputFilterSettings().hashCode());
        hashCode = prime * hashCode + ((getAudioSelectorGroups() == null) ? 0 : getAudioSelectorGroups().hashCode());
        hashCode = prime * hashCode + ((getAudioSelectors() == null) ? 0 : getAudioSelectors().hashCode());
        hashCode = prime * hashCode + ((getCaptionSelectors() == null) ? 0 : getCaptionSelectors().hashCode());
        hashCode = prime * hashCode + ((getCrop() == null) ? 0 : getCrop().hashCode());
        hashCode = prime * hashCode + ((getDeblockFilter() == null) ? 0 : getDeblockFilter().hashCode());
        hashCode = prime * hashCode + ((getDenoiseFilter() == null) ? 0 : getDenoiseFilter().hashCode());
        hashCode = prime * hashCode + ((getDolbyVisionMetadataXml() == null) ? 0 : getDolbyVisionMetadataXml().hashCode());
        hashCode = prime * hashCode + ((getFilterEnable() == null) ? 0 : getFilterEnable().hashCode());
        hashCode = prime * hashCode + ((getFilterStrength() == null) ? 0 : getFilterStrength().hashCode());
        hashCode = prime * hashCode + ((getImageInserter() == null) ? 0 : getImageInserter().hashCode());
        hashCode = prime * hashCode + ((getInputClippings() == null) ? 0 : getInputClippings().hashCode());
        hashCode = prime * hashCode + ((getInputScanType() == null) ? 0 : getInputScanType().hashCode());
        hashCode = prime * hashCode + ((getPosition() == null) ? 0 : getPosition().hashCode());
        hashCode = prime * hashCode + ((getProgramNumber() == null) ? 0 : getProgramNumber().hashCode());
        hashCode = prime * hashCode + ((getPsiControl() == null) ? 0 : getPsiControl().hashCode());
        hashCode = prime * hashCode + ((getTimecodeSource() == null) ? 0 : getTimecodeSource().hashCode());
        hashCode = prime * hashCode + ((getTimecodeStart() == null) ? 0 : getTimecodeStart().hashCode());
        hashCode = prime * hashCode + ((getVideoSelector() == null) ? 0 : getVideoSelector().hashCode());
        return hashCode;
    }

    @Override
    public InputTemplate clone() {
        try {
            return (InputTemplate) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mediaconvert.model.transform.InputTemplateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
