/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.MediaStreamOutputConfiguration;
import java.util.List;

@SdkInternalApi
public class MediaStreamOutputConfigurationMarshaller {
    private static final MarshallingInfo<List> DESTINATIONCONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationConfigurations").build();
    private static final MarshallingInfo<String> ENCODINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encodingName").build();
    private static final MarshallingInfo<StructuredPojo> ENCODINGPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encodingParameters").build();
    private static final MarshallingInfo<String> MEDIASTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaStreamName").build();
    private static final MediaStreamOutputConfigurationMarshaller instance = new MediaStreamOutputConfigurationMarshaller();

    public static MediaStreamOutputConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(MediaStreamOutputConfiguration mediaStreamOutputConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (mediaStreamOutputConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(mediaStreamOutputConfiguration.getDestinationConfigurations(), DESTINATIONCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)mediaStreamOutputConfiguration.getEncodingName(), ENCODINGNAME_BINDING);
            protocolMarshaller.marshall((Object)mediaStreamOutputConfiguration.getEncodingParameters(), ENCODINGPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)mediaStreamOutputConfiguration.getMediaStreamName(), MEDIASTREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

