/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediaconnect.AWSMediaConnectAsync;
import com.amazonaws.services.mediaconnect.AWSMediaConnectAsyncClientBuilder;
import com.amazonaws.services.mediaconnect.AWSMediaConnectClient;
import com.amazonaws.services.mediaconnect.model.AddBridgeOutputsRequest;
import com.amazonaws.services.mediaconnect.model.AddBridgeOutputsResult;
import com.amazonaws.services.mediaconnect.model.AddBridgeSourcesRequest;
import com.amazonaws.services.mediaconnect.model.AddBridgeSourcesResult;
import com.amazonaws.services.mediaconnect.model.AddFlowMediaStreamsRequest;
import com.amazonaws.services.mediaconnect.model.AddFlowMediaStreamsResult;
import com.amazonaws.services.mediaconnect.model.AddFlowOutputsRequest;
import com.amazonaws.services.mediaconnect.model.AddFlowOutputsResult;
import com.amazonaws.services.mediaconnect.model.AddFlowSourcesRequest;
import com.amazonaws.services.mediaconnect.model.AddFlowSourcesResult;
import com.amazonaws.services.mediaconnect.model.AddFlowVpcInterfacesRequest;
import com.amazonaws.services.mediaconnect.model.AddFlowVpcInterfacesResult;
import com.amazonaws.services.mediaconnect.model.CreateBridgeRequest;
import com.amazonaws.services.mediaconnect.model.CreateBridgeResult;
import com.amazonaws.services.mediaconnect.model.CreateFlowRequest;
import com.amazonaws.services.mediaconnect.model.CreateFlowResult;
import com.amazonaws.services.mediaconnect.model.CreateGatewayRequest;
import com.amazonaws.services.mediaconnect.model.CreateGatewayResult;
import com.amazonaws.services.mediaconnect.model.DeleteBridgeRequest;
import com.amazonaws.services.mediaconnect.model.DeleteBridgeResult;
import com.amazonaws.services.mediaconnect.model.DeleteFlowRequest;
import com.amazonaws.services.mediaconnect.model.DeleteFlowResult;
import com.amazonaws.services.mediaconnect.model.DeleteGatewayRequest;
import com.amazonaws.services.mediaconnect.model.DeleteGatewayResult;
import com.amazonaws.services.mediaconnect.model.DeregisterGatewayInstanceRequest;
import com.amazonaws.services.mediaconnect.model.DeregisterGatewayInstanceResult;
import com.amazonaws.services.mediaconnect.model.DescribeBridgeRequest;
import com.amazonaws.services.mediaconnect.model.DescribeBridgeResult;
import com.amazonaws.services.mediaconnect.model.DescribeFlowRequest;
import com.amazonaws.services.mediaconnect.model.DescribeFlowResult;
import com.amazonaws.services.mediaconnect.model.DescribeFlowSourceMetadataRequest;
import com.amazonaws.services.mediaconnect.model.DescribeFlowSourceMetadataResult;
import com.amazonaws.services.mediaconnect.model.DescribeGatewayInstanceRequest;
import com.amazonaws.services.mediaconnect.model.DescribeGatewayInstanceResult;
import com.amazonaws.services.mediaconnect.model.DescribeGatewayRequest;
import com.amazonaws.services.mediaconnect.model.DescribeGatewayResult;
import com.amazonaws.services.mediaconnect.model.DescribeOfferingRequest;
import com.amazonaws.services.mediaconnect.model.DescribeOfferingResult;
import com.amazonaws.services.mediaconnect.model.DescribeReservationRequest;
import com.amazonaws.services.mediaconnect.model.DescribeReservationResult;
import com.amazonaws.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import com.amazonaws.services.mediaconnect.model.GrantFlowEntitlementsResult;
import com.amazonaws.services.mediaconnect.model.ListBridgesRequest;
import com.amazonaws.services.mediaconnect.model.ListBridgesResult;
import com.amazonaws.services.mediaconnect.model.ListEntitlementsRequest;
import com.amazonaws.services.mediaconnect.model.ListEntitlementsResult;
import com.amazonaws.services.mediaconnect.model.ListFlowsRequest;
import com.amazonaws.services.mediaconnect.model.ListFlowsResult;
import com.amazonaws.services.mediaconnect.model.ListGatewayInstancesRequest;
import com.amazonaws.services.mediaconnect.model.ListGatewayInstancesResult;
import com.amazonaws.services.mediaconnect.model.ListGatewaysRequest;
import com.amazonaws.services.mediaconnect.model.ListGatewaysResult;
import com.amazonaws.services.mediaconnect.model.ListOfferingsRequest;
import com.amazonaws.services.mediaconnect.model.ListOfferingsResult;
import com.amazonaws.services.mediaconnect.model.ListReservationsRequest;
import com.amazonaws.services.mediaconnect.model.ListReservationsResult;
import com.amazonaws.services.mediaconnect.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediaconnect.model.ListTagsForResourceResult;
import com.amazonaws.services.mediaconnect.model.PurchaseOfferingRequest;
import com.amazonaws.services.mediaconnect.model.PurchaseOfferingResult;
import com.amazonaws.services.mediaconnect.model.RemoveBridgeOutputRequest;
import com.amazonaws.services.mediaconnect.model.RemoveBridgeOutputResult;
import com.amazonaws.services.mediaconnect.model.RemoveBridgeSourceRequest;
import com.amazonaws.services.mediaconnect.model.RemoveBridgeSourceResult;
import com.amazonaws.services.mediaconnect.model.RemoveFlowMediaStreamRequest;
import com.amazonaws.services.mediaconnect.model.RemoveFlowMediaStreamResult;
import com.amazonaws.services.mediaconnect.model.RemoveFlowOutputRequest;
import com.amazonaws.services.mediaconnect.model.RemoveFlowOutputResult;
import com.amazonaws.services.mediaconnect.model.RemoveFlowSourceRequest;
import com.amazonaws.services.mediaconnect.model.RemoveFlowSourceResult;
import com.amazonaws.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest;
import com.amazonaws.services.mediaconnect.model.RemoveFlowVpcInterfaceResult;
import com.amazonaws.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import com.amazonaws.services.mediaconnect.model.RevokeFlowEntitlementResult;
import com.amazonaws.services.mediaconnect.model.StartFlowRequest;
import com.amazonaws.services.mediaconnect.model.StartFlowResult;
import com.amazonaws.services.mediaconnect.model.StopFlowRequest;
import com.amazonaws.services.mediaconnect.model.StopFlowResult;
import com.amazonaws.services.mediaconnect.model.TagResourceRequest;
import com.amazonaws.services.mediaconnect.model.TagResourceResult;
import com.amazonaws.services.mediaconnect.model.UntagResourceRequest;
import com.amazonaws.services.mediaconnect.model.UntagResourceResult;
import com.amazonaws.services.mediaconnect.model.UpdateBridgeOutputRequest;
import com.amazonaws.services.mediaconnect.model.UpdateBridgeOutputResult;
import com.amazonaws.services.mediaconnect.model.UpdateBridgeRequest;
import com.amazonaws.services.mediaconnect.model.UpdateBridgeResult;
import com.amazonaws.services.mediaconnect.model.UpdateBridgeSourceRequest;
import com.amazonaws.services.mediaconnect.model.UpdateBridgeSourceResult;
import com.amazonaws.services.mediaconnect.model.UpdateBridgeStateRequest;
import com.amazonaws.services.mediaconnect.model.UpdateBridgeStateResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowEntitlementResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowMediaStreamRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowMediaStreamResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowOutputRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowOutputResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowSourceRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowSourceResult;
import com.amazonaws.services.mediaconnect.model.UpdateGatewayInstanceRequest;
import com.amazonaws.services.mediaconnect.model.UpdateGatewayInstanceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaConnectAsyncClient
extends AWSMediaConnectClient
implements AWSMediaConnectAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaConnectAsyncClientBuilder asyncBuilder() {
        return AWSMediaConnectAsyncClientBuilder.standard();
    }

    AWSMediaConnectAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMediaConnectAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddBridgeOutputsResult> addBridgeOutputsAsync(AddBridgeOutputsRequest request) {
        return this.addBridgeOutputsAsync(request, null);
    }

    @Override
    public Future<AddBridgeOutputsResult> addBridgeOutputsAsync(AddBridgeOutputsRequest request, final AsyncHandler<AddBridgeOutputsRequest, AddBridgeOutputsResult> asyncHandler) {
        final AddBridgeOutputsRequest finalRequest = (AddBridgeOutputsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddBridgeOutputsResult>(){

            @Override
            public AddBridgeOutputsResult call() throws Exception {
                AddBridgeOutputsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddBridgeOutputs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddBridgeSourcesResult> addBridgeSourcesAsync(AddBridgeSourcesRequest request) {
        return this.addBridgeSourcesAsync(request, null);
    }

    @Override
    public Future<AddBridgeSourcesResult> addBridgeSourcesAsync(AddBridgeSourcesRequest request, final AsyncHandler<AddBridgeSourcesRequest, AddBridgeSourcesResult> asyncHandler) {
        final AddBridgeSourcesRequest finalRequest = (AddBridgeSourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddBridgeSourcesResult>(){

            @Override
            public AddBridgeSourcesResult call() throws Exception {
                AddBridgeSourcesResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddBridgeSources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddFlowMediaStreamsResult> addFlowMediaStreamsAsync(AddFlowMediaStreamsRequest request) {
        return this.addFlowMediaStreamsAsync(request, null);
    }

    @Override
    public Future<AddFlowMediaStreamsResult> addFlowMediaStreamsAsync(AddFlowMediaStreamsRequest request, final AsyncHandler<AddFlowMediaStreamsRequest, AddFlowMediaStreamsResult> asyncHandler) {
        final AddFlowMediaStreamsRequest finalRequest = (AddFlowMediaStreamsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddFlowMediaStreamsResult>(){

            @Override
            public AddFlowMediaStreamsResult call() throws Exception {
                AddFlowMediaStreamsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddFlowMediaStreams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddFlowOutputsResult> addFlowOutputsAsync(AddFlowOutputsRequest request) {
        return this.addFlowOutputsAsync(request, null);
    }

    @Override
    public Future<AddFlowOutputsResult> addFlowOutputsAsync(AddFlowOutputsRequest request, final AsyncHandler<AddFlowOutputsRequest, AddFlowOutputsResult> asyncHandler) {
        final AddFlowOutputsRequest finalRequest = (AddFlowOutputsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddFlowOutputsResult>(){

            @Override
            public AddFlowOutputsResult call() throws Exception {
                AddFlowOutputsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddFlowOutputs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddFlowSourcesResult> addFlowSourcesAsync(AddFlowSourcesRequest request) {
        return this.addFlowSourcesAsync(request, null);
    }

    @Override
    public Future<AddFlowSourcesResult> addFlowSourcesAsync(AddFlowSourcesRequest request, final AsyncHandler<AddFlowSourcesRequest, AddFlowSourcesResult> asyncHandler) {
        final AddFlowSourcesRequest finalRequest = (AddFlowSourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddFlowSourcesResult>(){

            @Override
            public AddFlowSourcesResult call() throws Exception {
                AddFlowSourcesResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddFlowSources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddFlowVpcInterfacesResult> addFlowVpcInterfacesAsync(AddFlowVpcInterfacesRequest request) {
        return this.addFlowVpcInterfacesAsync(request, null);
    }

    @Override
    public Future<AddFlowVpcInterfacesResult> addFlowVpcInterfacesAsync(AddFlowVpcInterfacesRequest request, final AsyncHandler<AddFlowVpcInterfacesRequest, AddFlowVpcInterfacesResult> asyncHandler) {
        final AddFlowVpcInterfacesRequest finalRequest = (AddFlowVpcInterfacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddFlowVpcInterfacesResult>(){

            @Override
            public AddFlowVpcInterfacesResult call() throws Exception {
                AddFlowVpcInterfacesResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddFlowVpcInterfaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBridgeResult> createBridgeAsync(CreateBridgeRequest request) {
        return this.createBridgeAsync(request, null);
    }

    @Override
    public Future<CreateBridgeResult> createBridgeAsync(CreateBridgeRequest request, final AsyncHandler<CreateBridgeRequest, CreateBridgeResult> asyncHandler) {
        final CreateBridgeRequest finalRequest = (CreateBridgeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBridgeResult>(){

            @Override
            public CreateBridgeResult call() throws Exception {
                CreateBridgeResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeCreateBridge(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFlowResult> createFlowAsync(CreateFlowRequest request) {
        return this.createFlowAsync(request, null);
    }

    @Override
    public Future<CreateFlowResult> createFlowAsync(CreateFlowRequest request, final AsyncHandler<CreateFlowRequest, CreateFlowResult> asyncHandler) {
        final CreateFlowRequest finalRequest = (CreateFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFlowResult>(){

            @Override
            public CreateFlowResult call() throws Exception {
                CreateFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeCreateFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGatewayResult> createGatewayAsync(CreateGatewayRequest request) {
        return this.createGatewayAsync(request, null);
    }

    @Override
    public Future<CreateGatewayResult> createGatewayAsync(CreateGatewayRequest request, final AsyncHandler<CreateGatewayRequest, CreateGatewayResult> asyncHandler) {
        final CreateGatewayRequest finalRequest = (CreateGatewayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGatewayResult>(){

            @Override
            public CreateGatewayResult call() throws Exception {
                CreateGatewayResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeCreateGateway(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBridgeResult> deleteBridgeAsync(DeleteBridgeRequest request) {
        return this.deleteBridgeAsync(request, null);
    }

    @Override
    public Future<DeleteBridgeResult> deleteBridgeAsync(DeleteBridgeRequest request, final AsyncHandler<DeleteBridgeRequest, DeleteBridgeResult> asyncHandler) {
        final DeleteBridgeRequest finalRequest = (DeleteBridgeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBridgeResult>(){

            @Override
            public DeleteBridgeResult call() throws Exception {
                DeleteBridgeResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDeleteBridge(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFlowResult> deleteFlowAsync(DeleteFlowRequest request) {
        return this.deleteFlowAsync(request, null);
    }

    @Override
    public Future<DeleteFlowResult> deleteFlowAsync(DeleteFlowRequest request, final AsyncHandler<DeleteFlowRequest, DeleteFlowResult> asyncHandler) {
        final DeleteFlowRequest finalRequest = (DeleteFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFlowResult>(){

            @Override
            public DeleteFlowResult call() throws Exception {
                DeleteFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDeleteFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGatewayResult> deleteGatewayAsync(DeleteGatewayRequest request) {
        return this.deleteGatewayAsync(request, null);
    }

    @Override
    public Future<DeleteGatewayResult> deleteGatewayAsync(DeleteGatewayRequest request, final AsyncHandler<DeleteGatewayRequest, DeleteGatewayResult> asyncHandler) {
        final DeleteGatewayRequest finalRequest = (DeleteGatewayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGatewayResult>(){

            @Override
            public DeleteGatewayResult call() throws Exception {
                DeleteGatewayResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDeleteGateway(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterGatewayInstanceResult> deregisterGatewayInstanceAsync(DeregisterGatewayInstanceRequest request) {
        return this.deregisterGatewayInstanceAsync(request, null);
    }

    @Override
    public Future<DeregisterGatewayInstanceResult> deregisterGatewayInstanceAsync(DeregisterGatewayInstanceRequest request, final AsyncHandler<DeregisterGatewayInstanceRequest, DeregisterGatewayInstanceResult> asyncHandler) {
        final DeregisterGatewayInstanceRequest finalRequest = (DeregisterGatewayInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterGatewayInstanceResult>(){

            @Override
            public DeregisterGatewayInstanceResult call() throws Exception {
                DeregisterGatewayInstanceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDeregisterGatewayInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBridgeResult> describeBridgeAsync(DescribeBridgeRequest request) {
        return this.describeBridgeAsync(request, null);
    }

    @Override
    public Future<DescribeBridgeResult> describeBridgeAsync(DescribeBridgeRequest request, final AsyncHandler<DescribeBridgeRequest, DescribeBridgeResult> asyncHandler) {
        final DescribeBridgeRequest finalRequest = (DescribeBridgeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBridgeResult>(){

            @Override
            public DescribeBridgeResult call() throws Exception {
                DescribeBridgeResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeBridge(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFlowResult> describeFlowAsync(DescribeFlowRequest request) {
        return this.describeFlowAsync(request, null);
    }

    @Override
    public Future<DescribeFlowResult> describeFlowAsync(DescribeFlowRequest request, final AsyncHandler<DescribeFlowRequest, DescribeFlowResult> asyncHandler) {
        final DescribeFlowRequest finalRequest = (DescribeFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFlowResult>(){

            @Override
            public DescribeFlowResult call() throws Exception {
                DescribeFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFlowSourceMetadataResult> describeFlowSourceMetadataAsync(DescribeFlowSourceMetadataRequest request) {
        return this.describeFlowSourceMetadataAsync(request, null);
    }

    @Override
    public Future<DescribeFlowSourceMetadataResult> describeFlowSourceMetadataAsync(DescribeFlowSourceMetadataRequest request, final AsyncHandler<DescribeFlowSourceMetadataRequest, DescribeFlowSourceMetadataResult> asyncHandler) {
        final DescribeFlowSourceMetadataRequest finalRequest = (DescribeFlowSourceMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFlowSourceMetadataResult>(){

            @Override
            public DescribeFlowSourceMetadataResult call() throws Exception {
                DescribeFlowSourceMetadataResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeFlowSourceMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGatewayResult> describeGatewayAsync(DescribeGatewayRequest request) {
        return this.describeGatewayAsync(request, null);
    }

    @Override
    public Future<DescribeGatewayResult> describeGatewayAsync(DescribeGatewayRequest request, final AsyncHandler<DescribeGatewayRequest, DescribeGatewayResult> asyncHandler) {
        final DescribeGatewayRequest finalRequest = (DescribeGatewayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGatewayResult>(){

            @Override
            public DescribeGatewayResult call() throws Exception {
                DescribeGatewayResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeGateway(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGatewayInstanceResult> describeGatewayInstanceAsync(DescribeGatewayInstanceRequest request) {
        return this.describeGatewayInstanceAsync(request, null);
    }

    @Override
    public Future<DescribeGatewayInstanceResult> describeGatewayInstanceAsync(DescribeGatewayInstanceRequest request, final AsyncHandler<DescribeGatewayInstanceRequest, DescribeGatewayInstanceResult> asyncHandler) {
        final DescribeGatewayInstanceRequest finalRequest = (DescribeGatewayInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGatewayInstanceResult>(){

            @Override
            public DescribeGatewayInstanceResult call() throws Exception {
                DescribeGatewayInstanceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeGatewayInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOfferingResult> describeOfferingAsync(DescribeOfferingRequest request) {
        return this.describeOfferingAsync(request, null);
    }

    @Override
    public Future<DescribeOfferingResult> describeOfferingAsync(DescribeOfferingRequest request, final AsyncHandler<DescribeOfferingRequest, DescribeOfferingResult> asyncHandler) {
        final DescribeOfferingRequest finalRequest = (DescribeOfferingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOfferingResult>(){

            @Override
            public DescribeOfferingResult call() throws Exception {
                DescribeOfferingResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeOffering(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservationResult> describeReservationAsync(DescribeReservationRequest request) {
        return this.describeReservationAsync(request, null);
    }

    @Override
    public Future<DescribeReservationResult> describeReservationAsync(DescribeReservationRequest request, final AsyncHandler<DescribeReservationRequest, DescribeReservationResult> asyncHandler) {
        final DescribeReservationRequest finalRequest = (DescribeReservationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReservationResult>(){

            @Override
            public DescribeReservationResult call() throws Exception {
                DescribeReservationResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeReservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GrantFlowEntitlementsResult> grantFlowEntitlementsAsync(GrantFlowEntitlementsRequest request) {
        return this.grantFlowEntitlementsAsync(request, null);
    }

    @Override
    public Future<GrantFlowEntitlementsResult> grantFlowEntitlementsAsync(GrantFlowEntitlementsRequest request, final AsyncHandler<GrantFlowEntitlementsRequest, GrantFlowEntitlementsResult> asyncHandler) {
        final GrantFlowEntitlementsRequest finalRequest = (GrantFlowEntitlementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GrantFlowEntitlementsResult>(){

            @Override
            public GrantFlowEntitlementsResult call() throws Exception {
                GrantFlowEntitlementsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeGrantFlowEntitlements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBridgesResult> listBridgesAsync(ListBridgesRequest request) {
        return this.listBridgesAsync(request, null);
    }

    @Override
    public Future<ListBridgesResult> listBridgesAsync(ListBridgesRequest request, final AsyncHandler<ListBridgesRequest, ListBridgesResult> asyncHandler) {
        final ListBridgesRequest finalRequest = (ListBridgesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBridgesResult>(){

            @Override
            public ListBridgesResult call() throws Exception {
                ListBridgesResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListBridges(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEntitlementsResult> listEntitlementsAsync(ListEntitlementsRequest request) {
        return this.listEntitlementsAsync(request, null);
    }

    @Override
    public Future<ListEntitlementsResult> listEntitlementsAsync(ListEntitlementsRequest request, final AsyncHandler<ListEntitlementsRequest, ListEntitlementsResult> asyncHandler) {
        final ListEntitlementsRequest finalRequest = (ListEntitlementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEntitlementsResult>(){

            @Override
            public ListEntitlementsResult call() throws Exception {
                ListEntitlementsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListEntitlements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFlowsResult> listFlowsAsync(ListFlowsRequest request) {
        return this.listFlowsAsync(request, null);
    }

    @Override
    public Future<ListFlowsResult> listFlowsAsync(ListFlowsRequest request, final AsyncHandler<ListFlowsRequest, ListFlowsResult> asyncHandler) {
        final ListFlowsRequest finalRequest = (ListFlowsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFlowsResult>(){

            @Override
            public ListFlowsResult call() throws Exception {
                ListFlowsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListFlows(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGatewayInstancesResult> listGatewayInstancesAsync(ListGatewayInstancesRequest request) {
        return this.listGatewayInstancesAsync(request, null);
    }

    @Override
    public Future<ListGatewayInstancesResult> listGatewayInstancesAsync(ListGatewayInstancesRequest request, final AsyncHandler<ListGatewayInstancesRequest, ListGatewayInstancesResult> asyncHandler) {
        final ListGatewayInstancesRequest finalRequest = (ListGatewayInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGatewayInstancesResult>(){

            @Override
            public ListGatewayInstancesResult call() throws Exception {
                ListGatewayInstancesResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListGatewayInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGatewaysResult> listGatewaysAsync(ListGatewaysRequest request) {
        return this.listGatewaysAsync(request, null);
    }

    @Override
    public Future<ListGatewaysResult> listGatewaysAsync(ListGatewaysRequest request, final AsyncHandler<ListGatewaysRequest, ListGatewaysResult> asyncHandler) {
        final ListGatewaysRequest finalRequest = (ListGatewaysRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGatewaysResult>(){

            @Override
            public ListGatewaysResult call() throws Exception {
                ListGatewaysResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListGateways(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOfferingsResult> listOfferingsAsync(ListOfferingsRequest request) {
        return this.listOfferingsAsync(request, null);
    }

    @Override
    public Future<ListOfferingsResult> listOfferingsAsync(ListOfferingsRequest request, final AsyncHandler<ListOfferingsRequest, ListOfferingsResult> asyncHandler) {
        final ListOfferingsRequest finalRequest = (ListOfferingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOfferingsResult>(){

            @Override
            public ListOfferingsResult call() throws Exception {
                ListOfferingsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListOfferings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReservationsResult> listReservationsAsync(ListReservationsRequest request) {
        return this.listReservationsAsync(request, null);
    }

    @Override
    public Future<ListReservationsResult> listReservationsAsync(ListReservationsRequest request, final AsyncHandler<ListReservationsRequest, ListReservationsResult> asyncHandler) {
        final ListReservationsRequest finalRequest = (ListReservationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReservationsResult>(){

            @Override
            public ListReservationsResult call() throws Exception {
                ListReservationsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListReservations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PurchaseOfferingResult> purchaseOfferingAsync(PurchaseOfferingRequest request) {
        return this.purchaseOfferingAsync(request, null);
    }

    @Override
    public Future<PurchaseOfferingResult> purchaseOfferingAsync(PurchaseOfferingRequest request, final AsyncHandler<PurchaseOfferingRequest, PurchaseOfferingResult> asyncHandler) {
        final PurchaseOfferingRequest finalRequest = (PurchaseOfferingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PurchaseOfferingResult>(){

            @Override
            public PurchaseOfferingResult call() throws Exception {
                PurchaseOfferingResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executePurchaseOffering(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveBridgeOutputResult> removeBridgeOutputAsync(RemoveBridgeOutputRequest request) {
        return this.removeBridgeOutputAsync(request, null);
    }

    @Override
    public Future<RemoveBridgeOutputResult> removeBridgeOutputAsync(RemoveBridgeOutputRequest request, final AsyncHandler<RemoveBridgeOutputRequest, RemoveBridgeOutputResult> asyncHandler) {
        final RemoveBridgeOutputRequest finalRequest = (RemoveBridgeOutputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveBridgeOutputResult>(){

            @Override
            public RemoveBridgeOutputResult call() throws Exception {
                RemoveBridgeOutputResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveBridgeOutput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveBridgeSourceResult> removeBridgeSourceAsync(RemoveBridgeSourceRequest request) {
        return this.removeBridgeSourceAsync(request, null);
    }

    @Override
    public Future<RemoveBridgeSourceResult> removeBridgeSourceAsync(RemoveBridgeSourceRequest request, final AsyncHandler<RemoveBridgeSourceRequest, RemoveBridgeSourceResult> asyncHandler) {
        final RemoveBridgeSourceRequest finalRequest = (RemoveBridgeSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveBridgeSourceResult>(){

            @Override
            public RemoveBridgeSourceResult call() throws Exception {
                RemoveBridgeSourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveBridgeSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveFlowMediaStreamResult> removeFlowMediaStreamAsync(RemoveFlowMediaStreamRequest request) {
        return this.removeFlowMediaStreamAsync(request, null);
    }

    @Override
    public Future<RemoveFlowMediaStreamResult> removeFlowMediaStreamAsync(RemoveFlowMediaStreamRequest request, final AsyncHandler<RemoveFlowMediaStreamRequest, RemoveFlowMediaStreamResult> asyncHandler) {
        final RemoveFlowMediaStreamRequest finalRequest = (RemoveFlowMediaStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveFlowMediaStreamResult>(){

            @Override
            public RemoveFlowMediaStreamResult call() throws Exception {
                RemoveFlowMediaStreamResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveFlowMediaStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveFlowOutputResult> removeFlowOutputAsync(RemoveFlowOutputRequest request) {
        return this.removeFlowOutputAsync(request, null);
    }

    @Override
    public Future<RemoveFlowOutputResult> removeFlowOutputAsync(RemoveFlowOutputRequest request, final AsyncHandler<RemoveFlowOutputRequest, RemoveFlowOutputResult> asyncHandler) {
        final RemoveFlowOutputRequest finalRequest = (RemoveFlowOutputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveFlowOutputResult>(){

            @Override
            public RemoveFlowOutputResult call() throws Exception {
                RemoveFlowOutputResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveFlowOutput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveFlowSourceResult> removeFlowSourceAsync(RemoveFlowSourceRequest request) {
        return this.removeFlowSourceAsync(request, null);
    }

    @Override
    public Future<RemoveFlowSourceResult> removeFlowSourceAsync(RemoveFlowSourceRequest request, final AsyncHandler<RemoveFlowSourceRequest, RemoveFlowSourceResult> asyncHandler) {
        final RemoveFlowSourceRequest finalRequest = (RemoveFlowSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveFlowSourceResult>(){

            @Override
            public RemoveFlowSourceResult call() throws Exception {
                RemoveFlowSourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveFlowSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveFlowVpcInterfaceResult> removeFlowVpcInterfaceAsync(RemoveFlowVpcInterfaceRequest request) {
        return this.removeFlowVpcInterfaceAsync(request, null);
    }

    @Override
    public Future<RemoveFlowVpcInterfaceResult> removeFlowVpcInterfaceAsync(RemoveFlowVpcInterfaceRequest request, final AsyncHandler<RemoveFlowVpcInterfaceRequest, RemoveFlowVpcInterfaceResult> asyncHandler) {
        final RemoveFlowVpcInterfaceRequest finalRequest = (RemoveFlowVpcInterfaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveFlowVpcInterfaceResult>(){

            @Override
            public RemoveFlowVpcInterfaceResult call() throws Exception {
                RemoveFlowVpcInterfaceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveFlowVpcInterface(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokeFlowEntitlementResult> revokeFlowEntitlementAsync(RevokeFlowEntitlementRequest request) {
        return this.revokeFlowEntitlementAsync(request, null);
    }

    @Override
    public Future<RevokeFlowEntitlementResult> revokeFlowEntitlementAsync(RevokeFlowEntitlementRequest request, final AsyncHandler<RevokeFlowEntitlementRequest, RevokeFlowEntitlementResult> asyncHandler) {
        final RevokeFlowEntitlementRequest finalRequest = (RevokeFlowEntitlementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokeFlowEntitlementResult>(){

            @Override
            public RevokeFlowEntitlementResult call() throws Exception {
                RevokeFlowEntitlementResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRevokeFlowEntitlement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFlowResult> startFlowAsync(StartFlowRequest request) {
        return this.startFlowAsync(request, null);
    }

    @Override
    public Future<StartFlowResult> startFlowAsync(StartFlowRequest request, final AsyncHandler<StartFlowRequest, StartFlowResult> asyncHandler) {
        final StartFlowRequest finalRequest = (StartFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFlowResult>(){

            @Override
            public StartFlowResult call() throws Exception {
                StartFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeStartFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopFlowResult> stopFlowAsync(StopFlowRequest request) {
        return this.stopFlowAsync(request, null);
    }

    @Override
    public Future<StopFlowResult> stopFlowAsync(StopFlowRequest request, final AsyncHandler<StopFlowRequest, StopFlowResult> asyncHandler) {
        final StopFlowRequest finalRequest = (StopFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopFlowResult>(){

            @Override
            public StopFlowResult call() throws Exception {
                StopFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeStopFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBridgeResult> updateBridgeAsync(UpdateBridgeRequest request) {
        return this.updateBridgeAsync(request, null);
    }

    @Override
    public Future<UpdateBridgeResult> updateBridgeAsync(UpdateBridgeRequest request, final AsyncHandler<UpdateBridgeRequest, UpdateBridgeResult> asyncHandler) {
        final UpdateBridgeRequest finalRequest = (UpdateBridgeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBridgeResult>(){

            @Override
            public UpdateBridgeResult call() throws Exception {
                UpdateBridgeResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateBridge(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBridgeOutputResult> updateBridgeOutputAsync(UpdateBridgeOutputRequest request) {
        return this.updateBridgeOutputAsync(request, null);
    }

    @Override
    public Future<UpdateBridgeOutputResult> updateBridgeOutputAsync(UpdateBridgeOutputRequest request, final AsyncHandler<UpdateBridgeOutputRequest, UpdateBridgeOutputResult> asyncHandler) {
        final UpdateBridgeOutputRequest finalRequest = (UpdateBridgeOutputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBridgeOutputResult>(){

            @Override
            public UpdateBridgeOutputResult call() throws Exception {
                UpdateBridgeOutputResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateBridgeOutput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBridgeSourceResult> updateBridgeSourceAsync(UpdateBridgeSourceRequest request) {
        return this.updateBridgeSourceAsync(request, null);
    }

    @Override
    public Future<UpdateBridgeSourceResult> updateBridgeSourceAsync(UpdateBridgeSourceRequest request, final AsyncHandler<UpdateBridgeSourceRequest, UpdateBridgeSourceResult> asyncHandler) {
        final UpdateBridgeSourceRequest finalRequest = (UpdateBridgeSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBridgeSourceResult>(){

            @Override
            public UpdateBridgeSourceResult call() throws Exception {
                UpdateBridgeSourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateBridgeSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBridgeStateResult> updateBridgeStateAsync(UpdateBridgeStateRequest request) {
        return this.updateBridgeStateAsync(request, null);
    }

    @Override
    public Future<UpdateBridgeStateResult> updateBridgeStateAsync(UpdateBridgeStateRequest request, final AsyncHandler<UpdateBridgeStateRequest, UpdateBridgeStateResult> asyncHandler) {
        final UpdateBridgeStateRequest finalRequest = (UpdateBridgeStateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBridgeStateResult>(){

            @Override
            public UpdateBridgeStateResult call() throws Exception {
                UpdateBridgeStateResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateBridgeState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowResult> updateFlowAsync(UpdateFlowRequest request) {
        return this.updateFlowAsync(request, null);
    }

    @Override
    public Future<UpdateFlowResult> updateFlowAsync(UpdateFlowRequest request, final AsyncHandler<UpdateFlowRequest, UpdateFlowResult> asyncHandler) {
        final UpdateFlowRequest finalRequest = (UpdateFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowResult>(){

            @Override
            public UpdateFlowResult call() throws Exception {
                UpdateFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowEntitlementResult> updateFlowEntitlementAsync(UpdateFlowEntitlementRequest request) {
        return this.updateFlowEntitlementAsync(request, null);
    }

    @Override
    public Future<UpdateFlowEntitlementResult> updateFlowEntitlementAsync(UpdateFlowEntitlementRequest request, final AsyncHandler<UpdateFlowEntitlementRequest, UpdateFlowEntitlementResult> asyncHandler) {
        final UpdateFlowEntitlementRequest finalRequest = (UpdateFlowEntitlementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowEntitlementResult>(){

            @Override
            public UpdateFlowEntitlementResult call() throws Exception {
                UpdateFlowEntitlementResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowEntitlement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowMediaStreamResult> updateFlowMediaStreamAsync(UpdateFlowMediaStreamRequest request) {
        return this.updateFlowMediaStreamAsync(request, null);
    }

    @Override
    public Future<UpdateFlowMediaStreamResult> updateFlowMediaStreamAsync(UpdateFlowMediaStreamRequest request, final AsyncHandler<UpdateFlowMediaStreamRequest, UpdateFlowMediaStreamResult> asyncHandler) {
        final UpdateFlowMediaStreamRequest finalRequest = (UpdateFlowMediaStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowMediaStreamResult>(){

            @Override
            public UpdateFlowMediaStreamResult call() throws Exception {
                UpdateFlowMediaStreamResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowMediaStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowOutputResult> updateFlowOutputAsync(UpdateFlowOutputRequest request) {
        return this.updateFlowOutputAsync(request, null);
    }

    @Override
    public Future<UpdateFlowOutputResult> updateFlowOutputAsync(UpdateFlowOutputRequest request, final AsyncHandler<UpdateFlowOutputRequest, UpdateFlowOutputResult> asyncHandler) {
        final UpdateFlowOutputRequest finalRequest = (UpdateFlowOutputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowOutputResult>(){

            @Override
            public UpdateFlowOutputResult call() throws Exception {
                UpdateFlowOutputResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowOutput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowSourceResult> updateFlowSourceAsync(UpdateFlowSourceRequest request) {
        return this.updateFlowSourceAsync(request, null);
    }

    @Override
    public Future<UpdateFlowSourceResult> updateFlowSourceAsync(UpdateFlowSourceRequest request, final AsyncHandler<UpdateFlowSourceRequest, UpdateFlowSourceResult> asyncHandler) {
        final UpdateFlowSourceRequest finalRequest = (UpdateFlowSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowSourceResult>(){

            @Override
            public UpdateFlowSourceResult call() throws Exception {
                UpdateFlowSourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGatewayInstanceResult> updateGatewayInstanceAsync(UpdateGatewayInstanceRequest request) {
        return this.updateGatewayInstanceAsync(request, null);
    }

    @Override
    public Future<UpdateGatewayInstanceResult> updateGatewayInstanceAsync(UpdateGatewayInstanceRequest request, final AsyncHandler<UpdateGatewayInstanceRequest, UpdateGatewayInstanceResult> asyncHandler) {
        final UpdateGatewayInstanceRequest finalRequest = (UpdateGatewayInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGatewayInstanceResult>(){

            @Override
            public UpdateGatewayInstanceResult call() throws Exception {
                UpdateGatewayInstanceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateGatewayInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

